/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.util;

import com.intellij.gradle.toolingExtension.util.GradleReflectionUtil;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleNegotiationUtil {
    private static final GradleVersion gradleBaseVersion = GradleVersion.current().getBaseVersion();
    private static final boolean is33OrBetter = gradleBaseVersion.compareTo(GradleVersion.version((String)"3.3")) >= 0;
    private static final boolean is37OrBetter = gradleBaseVersion.compareTo(GradleVersion.version((String)"3.7")) >= 0;
    private static final boolean is45OrBetter = gradleBaseVersion.compareTo(GradleVersion.version((String)"4.5")) >= 0;
    private static final boolean is51OrBetter = gradleBaseVersion.compareTo(GradleVersion.version((String)"5.1")) >= 0;

    @Nullable
    public static String getProjectIdentityPath(@NotNull Project project) {
        if (project == null) {
            GradleNegotiationUtil.$$$reportNull$$$0(0);
        }
        if (is37OrBetter) {
            return ((ProjectInternal)project).getIdentityPath().getPath();
        }
        return null;
    }

    public static boolean isConfigurationCanBeResolved(@NotNull Configuration configuration, boolean defaultResult) {
        if (configuration == null) {
            GradleNegotiationUtil.$$$reportNull$$$0(1);
        }
        if (is33OrBetter) {
            return configuration.isCanBeResolved();
        }
        return defaultResult;
    }

    @NotNull
    public static String getProjectName(@NotNull ProjectComponentIdentifier identifier) {
        if (identifier == null) {
            GradleNegotiationUtil.$$$reportNull$$$0(2);
        }
        if (is45OrBetter) {
            String string = identifier.getProjectName();
            if (string == null) {
                GradleNegotiationUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = identifier.getProjectPath();
        if (string == null) {
            GradleNegotiationUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getProjectDisplayName(@NotNull Project project) {
        if (project == null) {
            GradleNegotiationUtil.$$$reportNull$$$0(5);
        }
        if (is33OrBetter) {
            String string = project.getDisplayName();
            if (string == null) {
                GradleNegotiationUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (project.getParent() == null && project.getGradle().getParent() == null) {
            String string = "root project '" + project.getName() + "'";
            if (string == null) {
                GradleNegotiationUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = "project '" + project.getPath() + "'";
        if (string == null) {
            GradleNegotiationUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public static File getTaskArchiveFile(@NotNull AbstractArchiveTask task) {
        if (task == null) {
            GradleNegotiationUtil.$$$reportNull$$$0(9);
        }
        if (is51OrBetter) {
            return GradleReflectionUtil.reflectiveGetProperty(task, "getArchiveFile", RegularFile.class).getAsFile();
        }
        return GradleReflectionUtil.reflectiveCall(task, "getArchivePath", File.class);
    }

    @Nullable
    public static String getTaskArchiveFileName(@NotNull AbstractArchiveTask task) {
        if (task == null) {
            GradleNegotiationUtil.$$$reportNull$$$0(10);
        }
        if (is51OrBetter) {
            return GradleReflectionUtil.reflectiveGetProperty(task, "getArchiveFileName", String.class);
        }
        return GradleReflectionUtil.reflectiveCall(task, "getArchiveName", String.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/util/GradleNegotiationUtil";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/util/GradleNegotiationUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectIdentityPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationCanBeResolved";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectName";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDisplayName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTaskArchiveFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTaskArchiveFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

