/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.modelAction;

import com.intellij.gradle.toolingExtension.modelAction.DefaultBuild;
import com.intellij.gradle.toolingExtension.modelAction.DefaultBuildController;
import com.intellij.gradle.toolingExtension.modelAction.GradleModelFetchPhase;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.internal.gradle.DefaultBuildIdentifier;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.model.internal.TurnOffDefaultTasks;
import org.jetbrains.plugins.gradle.tooling.serialization.ModelConverter;

@ApiStatus.Internal
public class GradleModelFetchAction {
    @NotNull
    private final ProjectImportAction.AllModels myAllModels;
    @NotNull
    private final Set<ProjectImportModelProvider> myModelProviders;
    @NotNull
    private final ModelConverter myModelConverter;
    @NotNull
    private final ExecutorService myModelConverterExecutor;
    private final boolean myIsPreviewMode;
    private final boolean myIsProjectsLoadedAction;

    public GradleModelFetchAction(@NotNull ProjectImportAction.AllModels allModels, @NotNull Set<ProjectImportModelProvider> modelProviders, @NotNull ModelConverter modelConverter, @NotNull ExecutorService modelConverterExecutor, boolean isPreviewMode, boolean isProjectsLoadedAction) {
        if (allModels == null) {
            GradleModelFetchAction.$$$reportNull$$$0(0);
        }
        if (modelProviders == null) {
            GradleModelFetchAction.$$$reportNull$$$0(1);
        }
        if (modelConverter == null) {
            GradleModelFetchAction.$$$reportNull$$$0(2);
        }
        if (modelConverterExecutor == null) {
            GradleModelFetchAction.$$$reportNull$$$0(3);
        }
        this.myAllModels = allModels;
        this.myModelProviders = modelProviders;
        this.myModelConverter = modelConverter;
        this.myModelConverterExecutor = modelConverterExecutor;
        this.myIsPreviewMode = isPreviewMode;
        this.myIsProjectsLoadedAction = isProjectsLoadedAction;
    }

    public void execute(@NotNull DefaultBuildController controller) {
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(4);
        }
        GradleBuild mainGradleBuild = controller.getBuildModel();
        Set<GradleBuild> nestedBuilds = GradleModelFetchAction.getNestedBuilds(controller, mainGradleBuild);
        this.addModels(controller, mainGradleBuild);
        for (GradleBuild includedBuild : nestedBuilds) {
            if (!this.myIsProjectsLoadedAction) {
                this.myAllModels.addIncludedBuild(DefaultBuild.convertGradleBuild(includedBuild));
            }
            this.addModels(controller, includedBuild);
        }
        GradleModelFetchAction.setupIncludedBuildsHierarchy(this.myAllModels.getIncludedBuilds(), nestedBuilds);
        if (this.myIsProjectsLoadedAction) {
            controller.getModel(TurnOffDefaultTasks.class);
        }
    }

    private static Set<GradleBuild> getNestedBuilds(@NotNull BuildController controller, @NotNull GradleBuild build) {
        BuildEnvironment environment;
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(5);
        }
        if (build == null) {
            GradleModelFetchAction.$$$reportNull$$$0(6);
        }
        if ((environment = (BuildEnvironment)controller.getModel(BuildEnvironment.class)) == null) {
            return Collections.emptySet();
        }
        GradleVersion gradleVersion = GradleVersion.version((String)environment.getGradle().getGradleVersion());
        if (gradleVersion.compareTo(GradleVersion.version((String)"3.1")) < 0) {
            return Collections.emptySet();
        }
        HashSet<String> processedBuildsPaths = new HashSet<String>();
        LinkedHashSet<GradleBuild> nestedBuilds = new LinkedHashSet<GradleBuild>();
        String rootBuildPath = build.getBuildIdentifier().getRootDir().getPath();
        processedBuildsPaths.add(rootBuildPath);
        ArrayDeque<? extends GradleBuild> queue = new ArrayDeque<GradleBuild>((Collection<? extends GradleBuild>)GradleModelFetchAction.getEditableBuilds(build, gradleVersion));
        while (!queue.isEmpty()) {
            GradleBuild includedBuild = (GradleBuild)queue.remove();
            String includedBuildPath = includedBuild.getBuildIdentifier().getRootDir().getPath();
            if (!processedBuildsPaths.add(includedBuildPath)) continue;
            nestedBuilds.add(includedBuild);
            queue.addAll((Collection<? extends GradleBuild>)GradleModelFetchAction.getEditableBuilds(includedBuild, gradleVersion));
        }
        return nestedBuilds;
    }

    private static DomainObjectSet<? extends GradleBuild> getEditableBuilds(@NotNull GradleBuild build, @NotNull GradleVersion version) {
        if (build == null) {
            GradleModelFetchAction.$$$reportNull$$$0(7);
        }
        if (version == null) {
            GradleModelFetchAction.$$$reportNull$$$0(8);
        }
        if (version.compareTo(GradleVersion.version((String)"8.0")) >= 0) {
            DomainObjectSet builds = build.getEditableBuilds();
            if (builds.isEmpty()) {
                return build.getIncludedBuilds();
            }
            return builds;
        }
        return build.getIncludedBuilds();
    }

    private static void setupIncludedBuildsHierarchy(List<Build> builds, Set<GradleBuild> gradleBuilds) {
        HashSet<Build> updatedBuilds = new HashSet<Build>();
        HashMap<File, Build> rootDirsToBuilds = new HashMap<File, Build>();
        for (Build build : builds) {
            rootDirsToBuilds.put(build.getBuildIdentifier().getRootDir(), build);
        }
        for (GradleBuild gradleBuild : gradleBuilds) {
            Build build = (Build)rootDirsToBuilds.get(gradleBuild.getBuildIdentifier().getRootDir());
            if (build == null) continue;
            for (GradleBuild includedGradleBuild : gradleBuild.getIncludedBuilds()) {
                Build buildToUpdate = (Build)rootDirsToBuilds.get(includedGradleBuild.getBuildIdentifier().getRootDir());
                if (!(buildToUpdate instanceof DefaultBuild) || !updatedBuilds.add(buildToUpdate)) continue;
                ((DefaultBuild)buildToUpdate).setParentBuildIdentifier(new DefaultBuildIdentifier(gradleBuild.getBuildIdentifier().getRootDir()));
            }
        }
    }

    private void forEachModelFetchPhase(@NotNull BiConsumer<GradleModelFetchPhase, List<ProjectImportModelProvider>> consumer) {
        if (consumer == null) {
            GradleModelFetchAction.$$$reportNull$$$0(9);
        }
        this.myModelProviders.stream().collect(Collectors.groupingBy(it -> it.getPhase())).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(it -> consumer.accept((GradleModelFetchPhase)((Object)((Object)it.getKey())), (List)it.getValue()));
    }

    private void addModels(@NotNull BuildController controller, @NotNull GradleBuild gradleBuild) {
        block4: {
            if (controller == null) {
                GradleModelFetchAction.$$$reportNull$$$0(10);
            }
            if (gradleBuild == null) {
                GradleModelFetchAction.$$$reportNull$$$0(11);
            }
            try {
                this.forEachModelFetchPhase((__, modelProviders) -> {
                    for (BasicGradleProject gradleProject : gradleBuild.getProjects()) {
                        for (ProjectImportModelProvider modelProvider : modelProviders) {
                            this.addProjectModels(controller, gradleProject, modelProvider);
                        }
                    }
                    for (ProjectImportModelProvider modelProvider : modelProviders) {
                        this.addBuildModels(controller, gradleBuild, modelProvider);
                    }
                });
            }
            catch (Exception e) {
                if (this.myIsPreviewMode) break block4;
                throw new ExternalSystemException((Throwable)e);
            }
        }
    }

    private void addProjectModels(@NotNull BuildController controller, final @NotNull BasicGradleProject gradleProject, @NotNull ProjectImportModelProvider modelProvider) {
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(12);
        }
        if (gradleProject == null) {
            GradleModelFetchAction.$$$reportNull$$$0(13);
        }
        if (modelProvider == null) {
            GradleModelFetchAction.$$$reportNull$$$0(14);
        }
        final HashSet<String> obtainedModels = new HashSet<String>();
        long startTime = System.currentTimeMillis();
        modelProvider.populateProjectModels(controller, (Model)gradleProject, new ProjectImportModelProvider.ProjectModelConsumer(){

            @Override
            public void consume(@NotNull Object object, @NotNull Class<?> clazz) {
                if (object == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (clazz == null) {
                    1.$$$reportNull$$$0(1);
                }
                obtainedModels.add(clazz.getName());
                GradleModelFetchAction.this.addProjectModel((ProjectModel)gradleProject, object, clazz);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "object";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "clazz";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/gradle/toolingExtension/modelAction/GradleModelFetchAction$1";
                objectArray[2] = "consume";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myAllModels.logPerformance("Ran extension " + modelProvider.getName() + " during " + (Object)((Object)modelProvider.getPhase()) + " for project " + gradleProject.getProjectIdentifier().getProjectPath() + " obtained " + obtainedModels.size() + " model(s): " + GradleModelFetchAction.joinClassNamesToString(obtainedModels), System.currentTimeMillis() - startTime);
    }

    private void addBuildModels(@NotNull BuildController controller, @NotNull GradleBuild gradleBuild, @NotNull ProjectImportModelProvider modelProvider) {
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(15);
        }
        if (gradleBuild == null) {
            GradleModelFetchAction.$$$reportNull$$$0(16);
        }
        if (modelProvider == null) {
            GradleModelFetchAction.$$$reportNull$$$0(17);
        }
        final HashSet<String> obtainedModels = new HashSet<String>();
        long startTime = System.currentTimeMillis();
        modelProvider.populateBuildModels(controller, gradleBuild, new ProjectImportModelProvider.BuildModelConsumer(){

            @Override
            public void consumeProjectModel(@NotNull ProjectModel projectModel, @NotNull Object object, @NotNull Class<?> clazz) {
                if (projectModel == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (object == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (clazz == null) {
                    2.$$$reportNull$$$0(2);
                }
                obtainedModels.add(clazz.getName());
                GradleModelFetchAction.this.addProjectModel(projectModel, object, clazz);
            }

            @Override
            public void consume(@NotNull BuildModel buildModel, @NotNull Object object, @NotNull Class<?> clazz) {
                if (buildModel == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (object == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (clazz == null) {
                    2.$$$reportNull$$$0(5);
                }
                obtainedModels.add(clazz.getName());
                GradleModelFetchAction.this.addBuildModel(buildModel, object, clazz);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectModel";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "buildModel";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/gradle/toolingExtension/modelAction/GradleModelFetchAction$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "consumeProjectModel";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "consume";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myAllModels.logPerformance("Ran extension " + modelProvider.getName() + " during " + (Object)((Object)modelProvider.getPhase()) + " for build " + gradleBuild.getBuildIdentifier().getRootDir().getPath() + " obtained " + obtainedModels.size() + " model(s): " + GradleModelFetchAction.joinClassNamesToString(obtainedModels), System.currentTimeMillis() - startTime);
    }

    private void addProjectModel(@NotNull ProjectModel projectModel, @NotNull Object object, @NotNull Class<?> clazz) {
        if (projectModel == null) {
            GradleModelFetchAction.$$$reportNull$$$0(18);
        }
        if (object == null) {
            GradleModelFetchAction.$$$reportNull$$$0(19);
        }
        if (clazz == null) {
            GradleModelFetchAction.$$$reportNull$$$0(20);
        }
        this.myModelConverterExecutor.execute(() -> {
            Object converted = this.myModelConverter.convert(object);
            this.myAllModels.addModel(converted, (Class)clazz, projectModel);
        });
    }

    private void addBuildModel(@NotNull BuildModel buildModel, @NotNull Object object, @NotNull Class<?> clazz) {
        if (buildModel == null) {
            GradleModelFetchAction.$$$reportNull$$$0(21);
        }
        if (object == null) {
            GradleModelFetchAction.$$$reportNull$$$0(22);
        }
        if (clazz == null) {
            GradleModelFetchAction.$$$reportNull$$$0(23);
        }
        this.myModelConverterExecutor.execute(() -> {
            Object converted = this.myModelConverter.convert(object);
            this.myAllModels.addModel(converted, (Class)clazz, buildModel);
        });
    }

    @NotNull
    private static String joinClassNamesToString(@NotNull Set<String> names) {
        if (names == null) {
            GradleModelFetchAction.$$$reportNull$$$0(24);
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (String name : names) {
            joiner.add(name);
        }
        String string = joiner.toString();
        if (string == null) {
            GradleModelFetchAction.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModels";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelProviders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelConverter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelConverterExecutor";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleBuild";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelProvider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModel";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/modelAction/GradleModelFetchAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/modelAction/GradleModelFetchAction";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "joinClassNamesToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNestedBuilds";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEditableBuilds";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forEachModelFetchPhase";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addModels";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addProjectModels";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addBuildModels";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addProjectModel";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addBuildModel";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "joinClassNamesToString";
                break;
            }
            case 25: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

