/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.model.Config;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.model.ConfigProperty;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.model.io.xpp3.SecurityConfigurationXpp3Reader;

public class SecUtil {
    public static final String PROTOCOL_DELIM = "://";
    public static final int PROTOCOL_DELIM_LEN = "://".length();
    public static final String[] URL_PROTOCOLS = new String[]{"http", "https", "dav", "file", "davs", "webdav", "webdavs", "dav+http", "dav+https"};

    public static SettingsSecurity read(String location, boolean cycle) throws SecDispatcherException {
        if (location == null) {
            throw new SecDispatcherException("location to read from is null");
        }
        InputStream in = null;
        try {
            in = SecUtil.toStream(location);
            SettingsSecurity sec = new SecurityConfigurationXpp3Reader().read(in);
            in.close();
            if (cycle && sec.getRelocation() != null) {
                SettingsSecurity settingsSecurity = SecUtil.read(sec.getRelocation(), true);
                return settingsSecurity;
            }
            SettingsSecurity settingsSecurity = sec;
            return settingsSecurity;
        }
        catch (Exception e) {
            throw new SecDispatcherException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static InputStream toStream(String resource) throws IOException {
        if (resource == null) {
            return null;
        }
        int ind = resource.indexOf(PROTOCOL_DELIM);
        if (ind > 1) {
            String protocol = resource.substring(0, ind);
            resource = resource.substring(ind + PROTOCOL_DELIM_LEN);
            for (String p : URL_PROTOCOLS) {
                if (!protocol.regionMatches(true, 0, p, 0, p.length())) continue;
                return new URL(p + PROTOCOL_DELIM + resource).openStream();
            }
        }
        return new FileInputStream(resource);
    }

    public static Map<String, String> getConfig(SettingsSecurity sec, String name) {
        if (name == null) {
            return null;
        }
        List<Config> cl = sec.getConfigurations();
        if (cl == null || cl.isEmpty()) {
            return null;
        }
        for (Config cf : cl) {
            if (!name.equals(cf.getName())) continue;
            List<ConfigProperty> pl = cf.getProperties();
            if (pl == null || pl.isEmpty()) {
                return null;
            }
            HashMap<String, String> res = new HashMap<String, String>(pl.size());
            for (ConfigProperty p : pl) {
                res.put(p.getName(), p.getValue());
            }
            return res;
        }
        return null;
    }
}

