/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.gradle.internal.impldep.org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.gradle.internal.impldep.org.sonatype.plexus.components.cipher.PlexusCipher;
import org.gradle.internal.impldep.org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.PasswordDecryptor;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

@Singleton
@Named
public class DefaultSecDispatcher
implements SecDispatcher {
    private static final String DEFAULT_CONFIGURATION = "~/.settings-security.xml";
    public static final String SYSTEM_PROPERTY_SEC_LOCATION = "settings.security";
    public static final String TYPE_ATTR = "type";
    public static final char ATTR_START = '[';
    public static final char ATTR_STOP = ']';
    protected final PlexusCipher _cipher;
    protected final Map<String, PasswordDecryptor> _decryptors;
    protected String _configurationFile;

    @Inject
    public DefaultSecDispatcher(PlexusCipher _cipher, Map<String, PasswordDecryptor> _decryptors, @Named(value="${_configurationFile:-~/.settings-security.xml}") String _configurationFile) {
        this._cipher = _cipher;
        this._decryptors = _decryptors;
        this._configurationFile = _configurationFile;
    }

    public DefaultSecDispatcher(PlexusCipher _cipher) {
        this(_cipher, new HashMap<String, PasswordDecryptor>(), DEFAULT_CONFIGURATION);
    }

    @Override
    public String decrypt(String str) throws SecDispatcherException {
        String bare;
        if (!this.isEncryptedString(str)) {
            return str;
        }
        try {
            bare = this._cipher.unDecorate(str);
        }
        catch (PlexusCipherException e1) {
            throw new SecDispatcherException(e1);
        }
        try {
            Map<String, String> attr = this.stripAttributes(bare);
            SettingsSecurity sec = this.getSec();
            if (attr != null && attr.get(TYPE_ATTR) != null) {
                String type = attr.get(TYPE_ATTR);
                if (this._decryptors == null) {
                    throw new SecDispatcherException("plexus container did not supply any required dispatchers - cannot lookup " + type);
                }
                Map<String, String> conf = SecUtil.getConfig(sec, type);
                PasswordDecryptor dispatcher = this._decryptors.get(type);
                if (dispatcher == null) {
                    throw new SecDispatcherException("no dispatcher for hint " + type);
                }
                String pass = attr == null ? bare : this.strip(bare);
                return dispatcher.decrypt(pass, attr, conf);
            }
            String master = this.getMaster(sec);
            String res = this._cipher.decrypt(bare, master);
            return res;
        }
        catch (Exception e) {
            throw new SecDispatcherException(e);
        }
    }

    private String strip(String str) {
        int pos = str.indexOf(93);
        if (pos == str.length()) {
            return null;
        }
        if (pos != -1) {
            return str.substring(pos + 1);
        }
        return str;
    }

    private Map<String, String> stripAttributes(String str) {
        int start = str.indexOf(91);
        int stop = str.indexOf(93);
        if (start != -1 && stop != -1 && stop > start) {
            if (stop == start + 1) {
                return null;
            }
            String attrs = str.substring(start + 1, stop).trim();
            if (attrs.length() < 1) {
                return null;
            }
            HashMap<String, String> res = null;
            StringTokenizer st = new StringTokenizer(attrs, ", ");
            while (st.hasMoreTokens()) {
                String pair;
                int pos;
                if (res == null) {
                    res = new HashMap<String, String>(st.countTokens());
                }
                if ((pos = (pair = st.nextToken()).indexOf(61)) == -1) continue;
                String key = pair.substring(0, pos).trim();
                if (pos == pair.length()) {
                    res.put(key, null);
                    continue;
                }
                String val = pair.substring(pos + 1);
                res.put(key, val.trim());
            }
            return res;
        }
        return null;
    }

    private boolean isEncryptedString(String str) {
        if (str == null) {
            return false;
        }
        return this._cipher.isEncryptedString(str);
    }

    private SettingsSecurity getSec() throws SecDispatcherException {
        String location = System.getProperty(SYSTEM_PROPERTY_SEC_LOCATION, this.getConfigurationFile());
        String realLocation = location.charAt(0) == '~' ? System.getProperty("user.home") + location.substring(1) : location;
        SettingsSecurity sec = SecUtil.read(realLocation, true);
        if (sec == null) {
            throw new SecDispatcherException("cannot retrieve master password. Please check that " + realLocation + " exists and has data");
        }
        return sec;
    }

    private String getMaster(SettingsSecurity sec) throws SecDispatcherException {
        String master = sec.getMaster();
        if (master == null) {
            throw new SecDispatcherException("master password is not set");
        }
        try {
            return this._cipher.decryptDecorated(master, SYSTEM_PROPERTY_SEC_LOCATION);
        }
        catch (PlexusCipherException e) {
            throw new SecDispatcherException(e);
        }
    }

    public String getConfigurationFile() {
        return this._configurationFile;
    }

    public void setConfigurationFile(String file) {
        this._configurationFile = file;
    }

    private static boolean propertyExists(String[] values, String[] av) {
        if (values != null) {
            for (String item : values) {
                String p = System.getProperty(item);
                if (p == null) continue;
                return true;
            }
            if (av != null) {
                for (String value : values) {
                    for (String s : av) {
                        if (!("--" + value).equals(s)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static void usage() {
        System.out.println("usage: java -jar ...jar [-m|-p]\n-m: encrypt master password\n-p: encrypt password");
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 1) {
            DefaultSecDispatcher.usage();
            return;
        }
        if ("-m".equals(args[0]) || DefaultSecDispatcher.propertyExists(SYSTEM_PROPERTY_MASTER_PASSWORD, args)) {
            DefaultSecDispatcher.show(true);
        } else if ("-p".equals(args[0]) || DefaultSecDispatcher.propertyExists(SYSTEM_PROPERTY_SERVER_PASSWORD, args)) {
            DefaultSecDispatcher.show(false);
        } else {
            DefaultSecDispatcher.usage();
        }
    }

    private static void show(boolean showMaster) throws Exception {
        if (showMaster) {
            System.out.print("\nsettings master password\n");
        } else {
            System.out.print("\nsettings server password\n");
        }
        System.out.print("enter password: ");
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        String pass = r.readLine();
        System.out.println("\n");
        DefaultPlexusCipher dc = new DefaultPlexusCipher();
        DefaultSecDispatcher dd = new DefaultSecDispatcher(dc);
        if (showMaster) {
            System.out.println(dc.encryptAndDecorate(pass, SYSTEM_PROPERTY_SEC_LOCATION));
        } else {
            SettingsSecurity sec = dd.getSec();
            System.out.println(dc.encryptAndDecorate(pass, dd.getMaster(sec)));
        }
    }
}

