/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.launcher.core;

import org.gradle.internal.impldep.org.junit.platform.launcher.LauncherDiscoveryListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.gradle.internal.impldep.org.junit.platform.launcher.LauncherSession;
import org.gradle.internal.impldep.org.junit.platform.launcher.LauncherSessionListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestExecutionListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestPlan;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.DefaultLauncherSession;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.InternalLauncher;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.ListenerRegistry;

class SessionPerRequestLauncher
implements InternalLauncher {
    private final InternalLauncher delegate;
    private final LauncherSessionListener sessionListener;

    SessionPerRequestLauncher(InternalLauncher delegate, LauncherSessionListener sessionListener) {
        this.delegate = delegate;
        this.sessionListener = sessionListener;
    }

    @Override
    public void registerLauncherDiscoveryListeners(LauncherDiscoveryListener ... listeners) {
        this.delegate.registerLauncherDiscoveryListeners(listeners);
    }

    @Override
    public void registerTestExecutionListeners(TestExecutionListener ... listeners) {
        this.delegate.registerTestExecutionListeners(listeners);
    }

    @Override
    public TestPlan discover(LauncherDiscoveryRequest launcherDiscoveryRequest) {
        try (LauncherSession session = this.createSession();){
            TestPlan testPlan = session.getLauncher().discover(launcherDiscoveryRequest);
            return testPlan;
        }
    }

    @Override
    public void execute(LauncherDiscoveryRequest launcherDiscoveryRequest, TestExecutionListener ... listeners) {
        try (LauncherSession session = this.createSession();){
            session.getLauncher().execute(launcherDiscoveryRequest, listeners);
        }
    }

    @Override
    public void execute(TestPlan testPlan, TestExecutionListener ... listeners) {
        try (LauncherSession session = this.createSession();){
            session.getLauncher().execute(testPlan, listeners);
        }
    }

    @Override
    public ListenerRegistry<TestExecutionListener> getTestExecutionListenerRegistry() {
        return this.delegate.getTestExecutionListenerRegistry();
    }

    @Override
    public ListenerRegistry<LauncherDiscoveryListener> getLauncherDiscoveryListenerRegistry() {
        return this.delegate.getLauncherDiscoveryListenerRegistry();
    }

    private LauncherSession createSession() {
        return new DefaultLauncherSession(this.delegate, this.sessionListener);
    }
}

