/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.commons.logging;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.JUnitException;
import org.gradle.internal.impldep.org.junit.platform.commons.logging.LogRecordListener;
import org.gradle.internal.impldep.org.junit.platform.commons.logging.Logger;

@API(status=API.Status.INTERNAL, since="1.0")
public final class LoggerFactory {
    private static final Set<LogRecordListener> listeners = ConcurrentHashMap.newKeySet();

    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> clazz) {
        if (clazz == null) {
            throw new JUnitException("Class must not be null");
        }
        return new DelegatingLogger(clazz.getName());
    }

    public static void addListener(LogRecordListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(LogRecordListener listener) {
        listeners.remove(listener);
    }

    private static final class DelegatingLogger
    implements Logger {
        private static final String FQCN = DelegatingLogger.class.getName();
        private final String name;
        private final java.util.logging.Logger julLogger;

        DelegatingLogger(String name) {
            this.name = name;
            this.julLogger = java.util.logging.Logger.getLogger(this.name);
        }

        @Override
        public void error(Supplier<String> messageSupplier) {
            this.log(Level.SEVERE, null, messageSupplier);
        }

        @Override
        public void error(Throwable throwable, Supplier<String> messageSupplier) {
            this.log(Level.SEVERE, throwable, messageSupplier);
        }

        @Override
        public void warn(Supplier<String> messageSupplier) {
            this.log(Level.WARNING, null, messageSupplier);
        }

        @Override
        public void warn(Throwable throwable, Supplier<String> messageSupplier) {
            this.log(Level.WARNING, throwable, messageSupplier);
        }

        @Override
        public void info(Supplier<String> messageSupplier) {
            this.log(Level.INFO, null, messageSupplier);
        }

        @Override
        public void info(Throwable throwable, Supplier<String> messageSupplier) {
            this.log(Level.INFO, throwable, messageSupplier);
        }

        @Override
        public void config(Supplier<String> messageSupplier) {
            this.log(Level.CONFIG, null, messageSupplier);
        }

        @Override
        public void config(Throwable throwable, Supplier<String> messageSupplier) {
            this.log(Level.CONFIG, throwable, messageSupplier);
        }

        @Override
        public void debug(Supplier<String> messageSupplier) {
            this.log(Level.FINE, null, messageSupplier);
        }

        @Override
        public void debug(Throwable throwable, Supplier<String> messageSupplier) {
            this.log(Level.FINE, throwable, messageSupplier);
        }

        @Override
        public void trace(Supplier<String> messageSupplier) {
            this.log(Level.FINER, null, messageSupplier);
        }

        @Override
        public void trace(Throwable throwable, Supplier<String> messageSupplier) {
            this.log(Level.FINER, throwable, messageSupplier);
        }

        private void log(Level level, Throwable throwable, Supplier<String> messageSupplier) {
            boolean loggable = this.julLogger.isLoggable(level);
            if (loggable || !listeners.isEmpty()) {
                LogRecord logRecord = this.createLogRecord(level, throwable, DelegatingLogger.nullSafeGet(messageSupplier));
                if (loggable) {
                    this.julLogger.log(logRecord);
                }
                listeners.forEach(listener -> listener.logRecordSubmitted(logRecord));
            }
        }

        private LogRecord createLogRecord(Level level, Throwable throwable, String message) {
            String sourceClassName = null;
            String sourceMethodName = null;
            boolean found = false;
            for (StackTraceElement element : new Throwable().getStackTrace()) {
                String className = element.getClassName();
                if (FQCN.equals(className)) {
                    found = true;
                    continue;
                }
                if (!found) continue;
                sourceClassName = className;
                sourceMethodName = element.getMethodName();
                break;
            }
            LogRecord logRecord = new LogRecord(level, message);
            logRecord.setLoggerName(this.name);
            logRecord.setThrown(throwable);
            logRecord.setSourceClassName(sourceClassName);
            logRecord.setSourceMethodName(sourceMethodName);
            logRecord.setResourceBundleName(this.julLogger.getResourceBundleName());
            logRecord.setResourceBundle(this.julLogger.getResourceBundle());
            return logRecord;
        }

        private static String nullSafeGet(Supplier<String> messageSupplier) {
            return messageSupplier != null ? messageSupplier.get() : null;
        }
    }
}

