/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.util;

import java.io.IOException;
import java.text.MessageFormat;
import org.gradle.internal.impldep.org.eclipse.jgit.annotations.Nullable;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.CommandFailedException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.CredentialsProvider;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.RemoteSession;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.SshSessionFactory;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.URIish;
import org.gradle.internal.impldep.org.eclipse.jgit.util.FS;
import org.gradle.internal.impldep.org.eclipse.jgit.util.io.MessageWriter;
import org.gradle.internal.impldep.org.eclipse.jgit.util.io.StreamCopyThread;

public class SshSupport {
    public static String runSshCommand(URIish sshUri, @Nullable CredentialsProvider provider, FS fs, String command, int timeout) throws IOException, CommandFailedException {
        String out;
        MessageWriter stderr;
        CommandFailedException failure;
        Process process;
        RemoteSession session;
        block49: {
            StreamCopyThread outThread;
            block47: {
                StreamCopyThread errorThread;
                block41: {
                    session = null;
                    process = null;
                    errorThread = null;
                    outThread = null;
                    failure = null;
                    stderr = new MessageWriter();
                    try {
                        Throwable throwable = null;
                        Object var13_13 = null;
                        try (MessageWriter stdout = new MessageWriter();){
                            session = SshSessionFactory.getInstance().getSession(sshUri, provider, fs, 1000 * timeout);
                            process = session.exec(command, 0);
                            errorThread = new StreamCopyThread(process.getErrorStream(), stderr.getRawStream());
                            errorThread.start();
                            outThread = new StreamCopyThread(process.getInputStream(), stdout.getRawStream());
                            outThread.start();
                            try {
                                if (process.waitFor() == 0) {
                                    out = stdout.toString();
                                    break block41;
                                }
                                out = null;
                            }
                            catch (InterruptedException e) {
                                out = null;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        block45: {
                            block43: {
                                if (errorThread != null) {
                                    try {
                                        try {
                                            errorThread.halt();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            errorThread = null;
                                            break block43;
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        errorThread = null;
                                        throw throwable3;
                                    }
                                    errorThread = null;
                                }
                            }
                            if (outThread != null) {
                                try {
                                    try {
                                        outThread.halt();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        outThread = null;
                                        break block45;
                                    }
                                }
                                catch (Throwable throwable4) {
                                    outThread = null;
                                    throw throwable4;
                                }
                                outThread = null;
                            }
                        }
                        if (process != null) {
                            if (process.exitValue() != 0) {
                                failure = new CommandFailedException(process.exitValue(), MessageFormat.format(JGitText.get().sshCommandFailed, command, stderr.toString()));
                            }
                            process.destroy();
                        }
                        stderr.close();
                        if (session != null) {
                            SshSessionFactory.getInstance().releaseSession(session);
                        }
                        throw throwable;
                    }
                }
                if (errorThread != null) {
                    try {
                        try {
                            errorThread.halt();
                        }
                        catch (InterruptedException interruptedException) {
                            errorThread = null;
                            break block47;
                        }
                    }
                    catch (Throwable throwable) {
                        errorThread = null;
                        throw throwable;
                    }
                    errorThread = null;
                }
            }
            if (outThread != null) {
                try {
                    try {
                        outThread.halt();
                    }
                    catch (InterruptedException interruptedException) {
                        outThread = null;
                        break block49;
                    }
                }
                catch (Throwable throwable) {
                    outThread = null;
                    throw throwable;
                }
                outThread = null;
            }
        }
        if (process != null) {
            if (process.exitValue() != 0) {
                failure = new CommandFailedException(process.exitValue(), MessageFormat.format(JGitText.get().sshCommandFailed, command, stderr.toString()));
            }
            process.destroy();
        }
        stderr.close();
        if (session != null) {
            SshSessionFactory.getInstance().releaseSession(session);
        }
        if (failure != null) {
            throw failure;
        }
        return out;
    }
}

