/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.util.SystemReader;

public class GitDateParser {
    public static final Date NEVER = new Date(Long.MAX_VALUE);
    private static ThreadLocal<Map<Locale, Map<ParseableSimpleDateFormat, SimpleDateFormat>>> formatCache = new ThreadLocal<Map<Locale, Map<ParseableSimpleDateFormat, SimpleDateFormat>>>(){

        @Override
        protected Map<Locale, Map<ParseableSimpleDateFormat, SimpleDateFormat>> initialValue() {
            return new HashMap<Locale, Map<ParseableSimpleDateFormat, SimpleDateFormat>>();
        }
    };

    private static SimpleDateFormat getDateFormat(ParseableSimpleDateFormat f, Locale locale) {
        Map<Locale, Map<ParseableSimpleDateFormat, SimpleDateFormat>> cache = formatCache.get();
        Map<ParseableSimpleDateFormat, SimpleDateFormat> map = cache.get(locale);
        if (map == null) {
            map = new HashMap<ParseableSimpleDateFormat, SimpleDateFormat>();
            cache.put(locale, map);
            return GitDateParser.getNewSimpleDateFormat(f, locale, map);
        }
        SimpleDateFormat dateFormat = map.get((Object)f);
        if (dateFormat != null) {
            return dateFormat;
        }
        SimpleDateFormat df = GitDateParser.getNewSimpleDateFormat(f, locale, map);
        return df;
    }

    private static SimpleDateFormat getNewSimpleDateFormat(ParseableSimpleDateFormat f, Locale locale, Map<ParseableSimpleDateFormat, SimpleDateFormat> map) {
        SimpleDateFormat df = SystemReader.getInstance().getSimpleDateFormat(f.formatStr, locale);
        map.put(f, df);
        return df;
    }

    public static Date parse(String dateStr, Calendar now) throws ParseException {
        return GitDateParser.parse(dateStr, now, Locale.getDefault());
    }

    public static Date parse(String dateStr, Calendar now, Locale locale) throws ParseException {
        if ("never".equalsIgnoreCase(dateStr = dateStr.trim())) {
            return NEVER;
        }
        Date ret = GitDateParser.parse_relative(dateStr, now);
        if (ret != null) {
            return ret;
        }
        ParseableSimpleDateFormat[] parseableSimpleDateFormatArray = ParseableSimpleDateFormat.values();
        int n = parseableSimpleDateFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParseableSimpleDateFormat f = parseableSimpleDateFormatArray[n2];
            try {
                return GitDateParser.parse_simple(dateStr, f, locale);
            }
            catch (ParseException parseException) {
                ++n2;
            }
        }
        ParseableSimpleDateFormat[] values = ParseableSimpleDateFormat.values();
        StringBuilder allFormats = new StringBuilder("\"").append(values[0].formatStr);
        int i = 1;
        while (i < values.length) {
            allFormats.append("\", \"").append(values[i].formatStr);
            ++i;
        }
        allFormats.append("\"");
        throw new ParseException(MessageFormat.format(JGitText.get().cannotParseDate, dateStr, allFormats.toString()), 0);
    }

    private static Date parse_simple(String dateStr, ParseableSimpleDateFormat f, Locale locale) throws ParseException {
        SimpleDateFormat dateFormat = GitDateParser.getDateFormat(f, locale);
        dateFormat.setLenient(false);
        return dateFormat.parse(dateStr);
    }

    private static Date parse_relative(String dateStr, Calendar now) {
        Calendar cal;
        SystemReader sysRead = SystemReader.getInstance();
        if ("now".equals(dateStr)) {
            return now == null ? new Date(sysRead.getCurrentTime()) : now.getTime();
        }
        if (now == null) {
            cal = new GregorianCalendar(sysRead.getTimeZone(), sysRead.getLocale());
            cal.setTimeInMillis(sysRead.getCurrentTime());
        } else {
            cal = (Calendar)now.clone();
        }
        if ("yesterday".equals(dateStr)) {
            cal.add(5, -1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        String[] parts = dateStr.split("\\.| ");
        int partsLength = parts.length;
        if (partsLength < 3 || (partsLength & 1) == 0 || !"ago".equals(parts[parts.length - 1])) {
            return null;
        }
        int i = 0;
        while (i < parts.length - 2) {
            int number;
            try {
                number = Integer.parseInt(parts[i]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (parts[i + 1] == null) {
                return null;
            }
            switch (parts[i + 1]) {
                case "year": 
                case "years": {
                    cal.add(1, -number);
                    break;
                }
                case "months": 
                case "month": {
                    cal.add(2, -number);
                    break;
                }
                case "week": 
                case "weeks": {
                    cal.add(3, -number);
                    break;
                }
                case "day": 
                case "days": {
                    cal.add(5, -number);
                    break;
                }
                case "hour": 
                case "hours": {
                    cal.add(11, -number);
                    break;
                }
                case "minute": 
                case "minutes": {
                    cal.add(12, -number);
                    break;
                }
                case "second": 
                case "seconds": {
                    cal.add(13, -number);
                    break;
                }
                default: {
                    return null;
                }
            }
            i += 2;
        }
        return cal.getTime();
    }

    static enum ParseableSimpleDateFormat {
        ISO("yyyy-MM-dd HH:mm:ss Z"),
        RFC("EEE, dd MMM yyyy HH:mm:ss Z"),
        SHORT("yyyy-MM-dd"),
        SHORT_WITH_DOTS_REVERSE("dd.MM.yyyy"),
        SHORT_WITH_DOTS("yyyy.MM.dd"),
        SHORT_WITH_SLASH("MM/dd/yyyy"),
        DEFAULT("EEE MMM dd HH:mm:ss yyyy Z"),
        LOCAL("EEE MMM dd HH:mm:ss yyyy");

        private final String formatStr;

        private ParseableSimpleDateFormat(String formatStr) {
            this.formatStr = formatStr;
        }
    }
}

