/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.cms.bc;

import org.gradle.internal.impldep.org.bouncycastle.cert.X509CertificateHolder;
import org.gradle.internal.impldep.org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.gradle.internal.impldep.org.bouncycastle.cms.SignerInformationVerifier;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.gradle.internal.impldep.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.gradle.internal.impldep.org.bouncycastle.operator.DigestCalculatorProvider;
import org.gradle.internal.impldep.org.bouncycastle.operator.OperatorCreationException;
import org.gradle.internal.impldep.org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.gradle.internal.impldep.org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;

public class BcRSASignerInfoVerifierBuilder {
    private BcRSAContentVerifierProviderBuilder contentVerifierProviderBuilder;
    private DigestCalculatorProvider digestCalculatorProvider;
    private CMSSignatureAlgorithmNameGenerator sigAlgNameGen;
    private SignatureAlgorithmIdentifierFinder sigAlgIdFinder;

    public BcRSASignerInfoVerifierBuilder(CMSSignatureAlgorithmNameGenerator cMSSignatureAlgorithmNameGenerator, SignatureAlgorithmIdentifierFinder signatureAlgorithmIdentifierFinder, DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigAlgNameGen = cMSSignatureAlgorithmNameGenerator;
        this.sigAlgIdFinder = signatureAlgorithmIdentifierFinder;
        this.contentVerifierProviderBuilder = new BcRSAContentVerifierProviderBuilder(digestAlgorithmIdentifierFinder);
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public SignerInformationVerifier build(X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(x509CertificateHolder), this.digestCalculatorProvider);
    }

    public SignerInformationVerifier build(AsymmetricKeyParameter asymmetricKeyParameter) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(asymmetricKeyParameter), this.digestCalculatorProvider);
    }
}

