/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.repo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.core.report.ArtifactDownloadReport;
import org.gradle.internal.impldep.org.apache.ivy.osgi.repo.ManifestAndLocation;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public class ArtifactReportManifestIterable
implements Iterable<ManifestAndLocation> {
    private final Map<ModuleRevisionId, List<ArtifactDownloadReport>> artifactReports = new HashMap<ModuleRevisionId, List<ArtifactDownloadReport>>();
    private List<String> sourceTypes;

    public ArtifactReportManifestIterable(List<ArtifactDownloadReport> reports, List<String> sourceTypes) {
        this.sourceTypes = sourceTypes;
        for (ArtifactDownloadReport report : reports) {
            ModuleRevisionId mrid = report.getArtifact().getModuleRevisionId();
            List<ArtifactDownloadReport> moduleReports = this.artifactReports.get(mrid);
            if (moduleReports == null) {
                moduleReports = new ArrayList<ArtifactDownloadReport>();
                this.artifactReports.put(mrid, moduleReports);
            }
            moduleReports.add(report);
        }
    }

    @Override
    public Iterator<ManifestAndLocation> iterator() {
        return new ArtifactReportManifestIterator();
    }

    class ArtifactReportManifestIterator
    implements Iterator<ManifestAndLocation> {
        private ManifestAndLocation next = null;
        private Iterator<ModuleRevisionId> it;

        public ArtifactReportManifestIterator() {
            this.it = ArtifactReportManifestIterable.this.artifactReports.keySet().iterator();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() {
            while (true) {
                Iterator iterator;
                ArtifactDownloadReport source;
                ArtifactDownloadReport jar;
                if (this.next == null && this.it.hasNext()) {
                    ModuleRevisionId mrid = this.it.next();
                    jar = null;
                    source = null;
                    iterator = ((List)ArtifactReportManifestIterable.this.artifactReports.get(mrid)).iterator();
                } else {
                    if (this.next == null) return false;
                    return true;
                }
                while (iterator.hasNext()) {
                    ArtifactDownloadReport report = (ArtifactDownloadReport)iterator.next();
                    if (ArtifactReportManifestIterable.this.sourceTypes != null && ArtifactReportManifestIterable.this.sourceTypes.contains(report.getArtifact().getType())) {
                        source = report;
                        continue;
                    }
                    jar = report;
                }
                if (jar == null) continue;
                URI sourceURI = null;
                if (source != null) {
                    sourceURI = source.getUnpackedLocalFile() != null ? source.getUnpackedLocalFile().toURI() : source.getLocalFile().toURI();
                }
                if (jar.getUnpackedLocalFile() != null && jar.getUnpackedLocalFile().isDirectory()) {
                    try (FileInputStream in2 = new FileInputStream(new File(jar.getUnpackedLocalFile(), "META-INF/MANIFEST.MF"));){
                        this.next = new ManifestAndLocation(new Manifest(in2), jar.getUnpackedLocalFile().toURI(), sourceURI);
                        boolean bl = true;
                        return bl;
                    }
                    catch (FileNotFoundException e) {
                        Message.debug("Bundle directory file just removed: " + jar.getUnpackedLocalFile(), e);
                    }
                    catch (IOException e) {
                        Message.debug("The Manifest in the bundle directory could not be read: " + jar.getUnpackedLocalFile(), e);
                    }
                    continue;
                }
                File artifact = jar.getUnpackedLocalFile() != null ? jar.getUnpackedLocalFile() : jar.getLocalFile();
                try (JarInputStream in = new JarInputStream(new FileInputStream(artifact));){
                    Manifest manifest = in.getManifest();
                    if (manifest != null) {
                        this.next = new ManifestAndLocation(manifest, artifact.toURI(), sourceURI);
                        boolean bl = true;
                        return bl;
                    }
                    Message.debug("No manifest in jar: " + artifact);
                    continue;
                }
                catch (FileNotFoundException e) {
                    Message.debug("Jar file just removed: " + artifact, e);
                }
                catch (IOException e) {
                    Message.warn("Unreadable jar: " + artifact, e);
                    continue;
                }
                break;
            }
        }

        @Override
        public ManifestAndLocation next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ManifestAndLocation manifest = this.next;
            this.next = null;
            return manifest;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

