/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.ivy.core.cache.ResolutionCacheManager;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Configuration;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleId;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.core.report.ArtifactDownloadReport;
import org.gradle.internal.impldep.org.apache.ivy.core.report.ConfigurationResolveReport;
import org.gradle.internal.impldep.org.apache.ivy.core.report.DownloadStatus;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.IvyNode;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveOptions;
import org.gradle.internal.impldep.org.apache.ivy.core.settings.IvySettings;
import org.gradle.internal.impldep.org.apache.ivy.plugins.report.ReportOutputter;
import org.gradle.internal.impldep.org.apache.ivy.util.filter.Filter;

public class ResolveReport {
    private ModuleDescriptor md;
    private Map<String, ConfigurationResolveReport> confReports = new LinkedHashMap<String, ConfigurationResolveReport>();
    private List<String> problemMessages = new ArrayList<String>();
    private List<IvyNode> dependencies = new ArrayList<IvyNode>();
    private List<Artifact> artifacts = new ArrayList<Artifact>();
    private long resolveTime;
    private long downloadTime;
    private String resolveId;
    private long downloadSize;

    public ResolveReport(ModuleDescriptor md) {
        this(md, ResolveOptions.getDefaultResolveId(md));
    }

    public ResolveReport(ModuleDescriptor md, String resolveId) {
        this.md = md;
        this.resolveId = resolveId;
    }

    public void addReport(String conf, ConfigurationResolveReport report) {
        this.confReports.put(conf, report);
    }

    public ConfigurationResolveReport getConfigurationReport(String conf) {
        return this.confReports.get(conf);
    }

    public String[] getConfigurations() {
        return this.confReports.keySet().toArray(new String[this.confReports.size()]);
    }

    public boolean hasError() {
        for (ConfigurationResolveReport report : this.confReports.values()) {
            if (!report.hasError()) continue;
            return true;
        }
        return false;
    }

    public void output(ReportOutputter[] outputters, ResolutionCacheManager cacheMgr, ResolveOptions options) throws IOException {
        for (ReportOutputter outputter : outputters) {
            outputter.output(this, cacheMgr, options);
        }
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.md;
    }

    public IvyNode[] getEvictedNodes() {
        LinkedHashSet<IvyNode> all = new LinkedHashSet<IvyNode>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            all.addAll(Arrays.asList(report.getEvictedNodes()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public IvyNode[] getUnresolvedDependencies() {
        LinkedHashSet<IvyNode> all = new LinkedHashSet<IvyNode>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            all.addAll(Arrays.asList(report.getUnresolvedDependencies()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public ArtifactDownloadReport[] getFailedArtifactsReports() {
        return ConfigurationResolveReport.filterOutMergedArtifacts(this.getArtifactsReports(DownloadStatus.FAILED, true));
    }

    public ArtifactDownloadReport[] getAllArtifactsReports() {
        return this.getArtifactsReports(null, true);
    }

    public ArtifactDownloadReport[] getArtifactsReports(DownloadStatus downloadStatus, boolean withEvicted) {
        LinkedHashSet<ArtifactDownloadReport> all = new LinkedHashSet<ArtifactDownloadReport>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            ArtifactDownloadReport[] reports = report.getArtifactsReports(downloadStatus, withEvicted);
            all.addAll(Arrays.asList(reports));
        }
        return all.toArray(new ArtifactDownloadReport[all.size()]);
    }

    public ArtifactDownloadReport[] getArtifactsReports(ModuleRevisionId mrid) {
        LinkedHashSet<ArtifactDownloadReport> all = new LinkedHashSet<ArtifactDownloadReport>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            all.addAll(Arrays.asList(report.getDownloadReports(mrid)));
        }
        return all.toArray(new ArtifactDownloadReport[all.size()]);
    }

    public void checkIfChanged() {
        for (ConfigurationResolveReport report : this.confReports.values()) {
            report.checkIfChanged();
        }
    }

    public boolean hasChanged() {
        for (ConfigurationResolveReport report : this.confReports.values()) {
            if (!report.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void setProblemMessages(List<String> problems) {
        this.problemMessages = problems;
    }

    public List<String> getProblemMessages() {
        return this.problemMessages;
    }

    public List<String> getAllProblemMessages() {
        ArrayList<String> ret = new ArrayList<String>(this.problemMessages);
        for (ConfigurationResolveReport r : this.confReports.values()) {
            for (IvyNode unresolved : r.getUnresolvedDependencies()) {
                String errMsg = unresolved.getProblemMessage();
                if (errMsg.isEmpty()) {
                    ret.add("unresolved dependency: " + unresolved.getId());
                    continue;
                }
                ret.add("unresolved dependency: " + unresolved.getId() + ": " + errMsg);
            }
            for (ArtifactDownloadReport adr : r.getFailedArtifactsReports()) {
                ret.add("download failed: " + adr.getArtifact());
            }
        }
        return ret;
    }

    public void setDependencies(List<IvyNode> dependencies, Filter<Artifact> artifactFilter) {
        this.dependencies = dependencies;
        this.artifacts = new ArrayList<Artifact>();
        for (IvyNode dependency : dependencies) {
            if (!dependency.isCompletelyEvicted() && !dependency.hasProblem()) {
                this.artifacts.addAll(Arrays.asList(dependency.getSelectedArtifacts(artifactFilter)));
            }
            for (String dconf : dependency.getRootModuleConfigurations()) {
                ConfigurationResolveReport configurationReport = this.getConfigurationReport(dconf);
                if (configurationReport == null) continue;
                configurationReport.addDependency(dependency);
            }
        }
    }

    public List<IvyNode> getDependencies() {
        return this.dependencies;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public List<ModuleId> getModuleIds() {
        ArrayList<ModuleId> ret = new ArrayList<ModuleId>();
        ArrayList<IvyNode> sortedDependencies = new ArrayList<IvyNode>(this.dependencies);
        for (IvyNode dependency : sortedDependencies) {
            ModuleId mid = dependency.getResolvedId().getModuleId();
            if (ret.contains(mid)) continue;
            ret.add(mid);
        }
        return ret;
    }

    public void setResolveTime(long elapsedTime) {
        this.resolveTime = elapsedTime;
    }

    public long getResolveTime() {
        return this.resolveTime;
    }

    public void setDownloadTime(long elapsedTime) {
        this.downloadTime = elapsedTime;
    }

    public long getDownloadTime() {
        return this.downloadTime;
    }

    public void setDownloadSize(long size) {
        this.downloadSize = size;
    }

    public long getDownloadSize() {
        return this.downloadSize;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    private Set<String> getExtendingConfs(String extended) {
        HashSet<String> extendingConfs = new HashSet<String>();
        extendingConfs.add(extended);
        for (String conf : this.md.getConfigurationsNames()) {
            this.gatherExtendingConfs(extendingConfs, conf, extended);
        }
        return extendingConfs;
    }

    private boolean gatherExtendingConfs(Set<String> extendingConfs, String conf, String extended) {
        if (extendingConfs.contains(conf)) {
            return true;
        }
        String[] exts = this.md.getConfiguration(conf).getExtends();
        if (exts == null || exts.length == 0) {
            return false;
        }
        for (String ext : exts) {
            if (extendingConfs.contains(ext)) {
                extendingConfs.add(conf);
                return true;
            }
            if (ext.equals(extended)) {
                extendingConfs.add(conf);
                return true;
            }
            if (!this.gatherExtendingConfs(extendingConfs, ext, extended)) continue;
            extendingConfs.add(conf);
            return true;
        }
        return false;
    }

    public ModuleDescriptor toFixedModuleDescriptor(IvySettings settings, List<ModuleId> midToKeep) {
        DefaultModuleDescriptor fixedmd = new DefaultModuleDescriptor(this.md.getModuleRevisionId(), this.md.getStatus(), new Date());
        for (Map.Entry<String, String> ns : this.md.getExtraAttributesNamespaces().entrySet()) {
            fixedmd.addExtraAttributeNamespace(ns.getKey(), ns.getValue());
        }
        fixedmd.setDescription(this.md.getDescription());
        fixedmd.setHomePage(this.md.getHomePage());
        fixedmd.getExtraInfos().addAll(this.md.getExtraInfos());
        List<String> resolvedConfs = Arrays.asList(this.getConfigurations());
        for (String conf : resolvedConfs) {
            fixedmd.addConfiguration(new Configuration(conf));
        }
        for (String conf : resolvedConfs) {
            for (Artifact a : this.md.getArtifacts(conf)) {
                fixedmd.addArtifact(conf, a);
            }
        }
        for (IvyNode dep : this.dependencies) {
            boolean force;
            ModuleRevisionId depMrid;
            if (midToKeep != null && midToKeep.contains(dep.getModuleId())) {
                depMrid = dep.getId();
                force = false;
            } else {
                depMrid = dep.getResolvedId();
                force = true;
            }
            DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(fixedmd, depMrid, force, false, false);
            boolean evicted = true;
            for (String rootConf : dep.getRootModuleConfigurations()) {
                if (dep.isEvicted(rootConf)) continue;
                evicted = false;
                for (String targetConf : dep.getConfigurations(rootConf)) {
                    dd.addDependencyConfiguration(rootConf, targetConf);
                }
            }
            if (evicted) continue;
            fixedmd.addDependency(dd);
        }
        return fixedmd;
    }
}

