/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.event;

import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.ivy.core.IvyContext;
import org.gradle.internal.impldep.org.apache.ivy.core.event.EventManager;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleId;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.util.StringUtils;

public class IvyEvent {
    private EventManager source;
    private String name;
    private Map<String, String> attributes = new HashMap<String, String>();

    protected IvyEvent(String name) {
        this.source = IvyContext.getContext().getEventManager();
        this.name = name;
    }

    protected void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    protected void addMDAttributes(ModuleDescriptor md) {
        this.addMridAttributes(md.getResolvedModuleRevisionId());
    }

    protected void addMridAttributes(ModuleRevisionId mrid) {
        this.addModuleIdAttributes(mrid.getModuleId());
        this.addAttribute("revision", mrid.getRevision());
        this.addAttribute("branch", mrid.getBranch());
        this.addAttributes(mrid.getQualifiedExtraAttributes());
        this.addAttributes(mrid.getExtraAttributes());
    }

    protected void addModuleIdAttributes(ModuleId moduleId) {
        this.addAttribute("organisation", moduleId.getOrganisation());
        this.addAttribute("module", moduleId.getName());
    }

    protected void addConfsAttribute(String[] confs) {
        this.addAttribute("conf", StringUtils.joinArray(confs, ", "));
    }

    protected void addAttributes(Map<String, String> attributes) {
        this.attributes.putAll(attributes);
    }

    public EventManager getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.attributes);
    }

    public String toString() {
        return this.getName() + " " + this.getAttributes();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IvyEvent)) {
            return false;
        }
        IvyEvent e = (IvyEvent)obj;
        return this.getSource().equals(e.getSource()) && this.getName().equals(e.getName()) && this.attributes.equals(e.attributes);
    }

    public int hashCode() {
        int hash = 37;
        hash = 13 * hash + this.getSource().hashCode();
        hash = 13 * hash + this.getName().hashCode();
        hash = 13 * hash + this.attributes.hashCode();
        return hash;
    }
}

