/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.it.unimi.dsi.fastutil.bytes;

import java.util.function.IntUnaryOperator;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.Function;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.SafeMath;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.bytes.Byte2CharFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.bytes.Byte2DoubleFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.bytes.Byte2FloatFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.bytes.Byte2IntFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.bytes.Byte2LongFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.bytes.Byte2ObjectFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.bytes.Byte2ReferenceFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.bytes.Byte2ShortFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.chars.Char2ByteFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.doubles.Double2ByteFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.floats.Float2ByteFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.Int2ByteFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.longs.Long2ByteFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.objects.Object2ByteFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.objects.Reference2ByteFunction;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.shorts.Short2ByteFunction;

@FunctionalInterface
public interface Byte2ByteFunction
extends Function<Byte, Byte>,
IntUnaryOperator {
    @Override
    @Deprecated
    default public int applyAsInt(int operand) {
        return this.get(SafeMath.safeIntToByte(operand));
    }

    @Override
    default public byte put(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    public byte get(byte var1);

    default public byte getOrDefault(byte key, byte defaultValue) {
        byte v = this.get(key);
        return v != this.defaultReturnValue() || this.containsKey(key) ? v : defaultValue;
    }

    default public byte remove(byte key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public Byte put(Byte key, Byte value) {
        byte k = key;
        boolean containsKey = this.containsKey(k);
        byte v = this.put(k, (byte)value);
        return containsKey ? Byte.valueOf(v) : null;
    }

    @Override
    @Deprecated
    default public Byte get(Object key) {
        if (key == null) {
            return null;
        }
        byte k = (Byte)key;
        byte v = this.get(k);
        return v != this.defaultReturnValue() || this.containsKey(k) ? Byte.valueOf(v) : null;
    }

    @Override
    @Deprecated
    default public Byte getOrDefault(Object key, Byte defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        byte k = (Byte)key;
        byte v = this.get(k);
        return v != this.defaultReturnValue() || this.containsKey(k) ? Byte.valueOf(v) : defaultValue;
    }

    @Override
    @Deprecated
    default public Byte remove(Object key) {
        if (key == null) {
            return null;
        }
        byte k = (Byte)key;
        return this.containsKey(k) ? Byte.valueOf(this.remove(k)) : null;
    }

    default public boolean containsKey(byte key) {
        return true;
    }

    @Override
    @Deprecated
    default public boolean containsKey(Object key) {
        return key == null ? false : this.containsKey((Byte)key);
    }

    default public void defaultReturnValue(byte rv) {
        throw new UnsupportedOperationException();
    }

    default public byte defaultReturnValue() {
        return 0;
    }

    public static Byte2ByteFunction identity() {
        return k -> k;
    }

    @Override
    @Deprecated
    default public <T> java.util.function.Function<T, Byte> compose(java.util.function.Function<? super T, ? extends Byte> before) {
        return Function.super.compose(before);
    }

    @Override
    @Deprecated
    default public <T> java.util.function.Function<Byte, T> andThen(java.util.function.Function<? super Byte, ? extends T> after) {
        return Function.super.andThen(after);
    }

    default public Byte2ByteFunction andThenByte(Byte2ByteFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Byte2ByteFunction composeByte(Byte2ByteFunction before) {
        return k -> this.get(before.get(k));
    }

    default public Byte2ShortFunction andThenShort(Byte2ShortFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Short2ByteFunction composeShort(Short2ByteFunction before) {
        return k -> this.get(before.get(k));
    }

    default public Byte2IntFunction andThenInt(Byte2IntFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Int2ByteFunction composeInt(Int2ByteFunction before) {
        return k -> this.get(before.get(k));
    }

    default public Byte2LongFunction andThenLong(Byte2LongFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Long2ByteFunction composeLong(Long2ByteFunction before) {
        return k -> this.get(before.get(k));
    }

    default public Byte2CharFunction andThenChar(Byte2CharFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Char2ByteFunction composeChar(Char2ByteFunction before) {
        return k -> this.get(before.get(k));
    }

    default public Byte2FloatFunction andThenFloat(Byte2FloatFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Float2ByteFunction composeFloat(Float2ByteFunction before) {
        return k -> this.get(before.get(k));
    }

    default public Byte2DoubleFunction andThenDouble(Byte2DoubleFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Double2ByteFunction composeDouble(Double2ByteFunction before) {
        return k -> this.get(before.get(k));
    }

    default public <T> Byte2ObjectFunction<T> andThenObject(Byte2ObjectFunction<? extends T> after) {
        return k -> after.get(this.get(k));
    }

    default public <T> Object2ByteFunction<T> composeObject(Object2ByteFunction<? super T> before) {
        return k -> this.get(before.getByte(k));
    }

    default public <T> Byte2ReferenceFunction<T> andThenReference(Byte2ReferenceFunction<? extends T> after) {
        return k -> after.get(this.get(k));
    }

    default public <T> Reference2ByteFunction<T> composeReference(Reference2ByteFunction<? super T> before) {
        return k -> this.get(before.getByte(k));
    }
}

