/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.jcraft.jzlib;

import java.io.IOException;
import java.io.OutputStream;
import org.gradle.internal.impldep.com.jcraft.jzlib.Deflater;
import org.gradle.internal.impldep.com.jcraft.jzlib.DeflaterOutputStream;
import org.gradle.internal.impldep.com.jcraft.jzlib.GZIPException;

public class GZIPOutputStream
extends DeflaterOutputStream {
    public GZIPOutputStream(OutputStream out) throws IOException {
        this(out, 512);
    }

    public GZIPOutputStream(OutputStream out, int size) throws IOException {
        this(out, size, true);
    }

    public GZIPOutputStream(OutputStream out, int size, boolean close_out) throws IOException {
        this(out, new Deflater(-1, 31), size, close_out);
        this.mydeflater = true;
    }

    public GZIPOutputStream(OutputStream out, Deflater deflater, int size, boolean close_out) throws IOException {
        super(out, deflater, size, close_out);
    }

    private void check() throws GZIPException {
        if (this.deflater.dstate.status != 42) {
            throw new GZIPException("header is already written.");
        }
    }

    public void setModifiedTime(long mtime) throws GZIPException {
        this.check();
        this.deflater.dstate.getGZIPHeader().setModifiedTime(mtime);
    }

    public void setOS(int os) throws GZIPException {
        this.check();
        this.deflater.dstate.getGZIPHeader().setOS(os);
    }

    public void setName(String name) throws GZIPException {
        this.check();
        this.deflater.dstate.getGZIPHeader().setName(name);
    }

    public void setComment(String comment) throws GZIPException {
        this.check();
        this.deflater.dstate.getGZIPHeader().setComment(comment);
    }

    public long getCRC() throws GZIPException {
        if (this.deflater.dstate.status != 666) {
            throw new GZIPException("checksum is not calculated yet.");
        }
        return this.deflater.dstate.getGZIPHeader().getCRC();
    }
}

