/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.bsh;

import org.gradle.internal.impldep.bsh.BSHAmbiguousName;
import org.gradle.internal.impldep.bsh.BSHBlock;
import org.gradle.internal.impldep.bsh.CallStack;
import org.gradle.internal.impldep.bsh.ClassGenerator;
import org.gradle.internal.impldep.bsh.EvalError;
import org.gradle.internal.impldep.bsh.Interpreter;
import org.gradle.internal.impldep.bsh.Modifiers;
import org.gradle.internal.impldep.bsh.SimpleNode;
import org.gradle.internal.impldep.bsh.UtilEvalError;

class BSHClassDeclaration
extends SimpleNode {
    static final String CLASSINITNAME = "_bshClassInit";
    String name;
    Modifiers modifiers;
    int numInterfaces;
    boolean extend;
    boolean isInterface;

    BSHClassDeclaration(int id) {
        super(id);
    }

    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        int child = 0;
        Class superClass = null;
        if (this.extend) {
            BSHAmbiguousName superNode = (BSHAmbiguousName)this.jjtGetChild(child++);
            superClass = superNode.toClass(callstack, interpreter);
        }
        Class[] interfaces = new Class[this.numInterfaces];
        for (int i = 0; i < this.numInterfaces; ++i) {
            BSHAmbiguousName node = (BSHAmbiguousName)this.jjtGetChild(child++);
            interfaces[i] = node.toClass(callstack, interpreter);
            if (interfaces[i].isInterface()) continue;
            throw new EvalError("Type: " + node.text + " is not an interface!", this, callstack);
        }
        BSHBlock block = child < this.jjtGetNumChildren() ? (BSHBlock)this.jjtGetChild(child) : new BSHBlock(25);
        try {
            return ClassGenerator.getClassGenerator().generateClass(this.name, this.modifiers, interfaces, superClass, block, this.isInterface, callstack, interpreter);
        }
        catch (UtilEvalError e) {
            throw e.toEvalError(this, callstack);
        }
    }

    public String toString() {
        return "ClassDeclaration: " + this.name;
    }
}

