/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.FiniteStringsIterator;

public class LimitedFiniteStringsIterator
extends FiniteStringsIterator {
    private int limit = Integer.MAX_VALUE;
    private int count = 0;

    public LimitedFiniteStringsIterator(Automaton a, int limit) {
        super(a);
        if (limit != -1 && limit <= 0) {
            throw new IllegalArgumentException("limit must be -1 (which means no limit), or > 0; got: " + limit);
        }
        this.limit = limit > 0 ? limit : Integer.MAX_VALUE;
    }

    @Override
    public IntsRef next() {
        if (this.count >= this.limit) {
            return null;
        }
        IntsRef result2 = super.next();
        if (result2 != null) {
            ++this.count;
        }
        return result2;
    }

    public int size() {
        return this.count;
    }
}

