/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.Point2D;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYGeometry;

public final class XYPoint
extends XYGeometry {
    private final float x;
    private final float y;

    public XYPoint(float x, float y) {
        this.x = XYEncodingUtils.checkVal(x);
        this.y = XYEncodingUtils.checkVal(y);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    @Override
    protected Component2D toComponent2D() {
        return Point2D.create(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XYPoint)) {
            return false;
        }
        XYPoint point = (XYPoint)o;
        return point.x == this.x && point.y == this.y;
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.x);
        result2 = 31 * result2 + Float.hashCode(this.y);
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Point(");
        sb.append(this.x);
        sb.append(",");
        sb.append(this.y);
        sb.append(')');
        return sb.toString();
    }
}

