/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.options;

import com.vladsch.flexmark.util.misc.DelimitedBuilder;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.options.MessageProvider;
import com.vladsch.flexmark.util.options.OptionParser;
import com.vladsch.flexmark.util.options.ParsedOption;
import com.vladsch.flexmark.util.options.ParsedOptionStatus;
import com.vladsch.flexmark.util.options.ParserMessage;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.List;

public class OptionsParser<T>
implements OptionParser<T> {
    public static final String OPTION_0_IS_AMBIGUOUS = "Option {0} matches: ";
    public static final String KEY_OPTION_0_IS_AMBIGUOUS = "options.parser.option.ambiguous";
    public static final String OPTION_0_DOES_NOT_MATCH = "Option {0} does not match any of: ";
    public static final String KEY_OPTION_0_DOES_NOT_MATCH = "options.parser.option.unknown";
    private final String optionName;
    private final OptionParser<T>[] parseableOptions;
    private final String optionDelimiter;
    private final String optionValueDelimiter;

    public OptionsParser(String optionName, OptionParser<T>[] parseableOptions, char optionDelimiter, char optionValueDelimiter) {
        this.optionName = optionName;
        this.parseableOptions = parseableOptions;
        this.optionDelimiter = Character.toString(optionDelimiter);
        this.optionValueDelimiter = Character.toString(optionValueDelimiter);
    }

    @Override
    public String getOptionName() {
        return this.optionName;
    }

    @Override
    public Pair<T, List<ParsedOption<T>>> parseOption(BasedSequence optionsText, T options, MessageProvider provider) {
        BasedSequence[] optionsList = (BasedSequence[])optionsText.split(this.optionDelimiter, 0, 6, null);
        T result2 = options;
        if (provider == null) {
            provider = MessageProvider.DEFAULT;
        }
        ArrayList parsedOptions = new ArrayList(optionsList.length);
        for (BasedSequence optionText : optionsList) {
            OptionParser<T> matched = null;
            DelimitedBuilder message = null;
            BasedSequence[] optionList = (BasedSequence[])optionText.split(this.optionValueDelimiter, 2, 4, null);
            if (optionList.length == 0) continue;
            BasedSequence optionName = optionList[0];
            BasedSequence optionValue = optionList.length > 1 ? optionList[1] : optionName.subSequence(optionName.length(), optionName.length());
            for (OptionParser<T> optionParser : this.parseableOptions) {
                if (optionParser.getOptionName().equals(optionName.toString())) {
                    matched = optionParser;
                    message = null;
                    break;
                }
                if (!optionParser.getOptionName().startsWith(optionName.toString())) continue;
                if (matched == null) {
                    matched = optionParser;
                    continue;
                }
                if (message == null) {
                    message = new DelimitedBuilder(", ");
                    message.append(provider.message(KEY_OPTION_0_IS_AMBIGUOUS, OPTION_0_IS_AMBIGUOUS, optionName));
                    message.append(matched.getOptionName()).mark();
                }
                message.append(optionParser.getOptionName()).mark();
            }
            if (matched != null) {
                if (message == null) {
                    Pair<T, List<ParsedOption<T>>> pair = matched.parseOption(optionValue, result2, provider);
                    result2 = pair.getFirst();
                    parsedOptions.add(new ParsedOption<T>(optionText, this, ParsedOptionStatus.VALID, null, pair.getSecond()));
                    continue;
                }
                parsedOptions.add(new ParsedOption(optionText, this, ParsedOptionStatus.ERROR, new ParserMessage(optionName, ParsedOptionStatus.ERROR, message.toString())));
                continue;
            }
            message = new DelimitedBuilder(", ");
            message.append(provider.message(KEY_OPTION_0_DOES_NOT_MATCH, OPTION_0_DOES_NOT_MATCH, optionName));
            this.appendOptionNames(message);
            parsedOptions.add(new ParsedOption(optionText, this, ParsedOptionStatus.ERROR, new ParserMessage(optionName, ParsedOptionStatus.ERROR, message.toString())));
        }
        return new Pair(result2, parsedOptions);
    }

    public void appendOptionNames(DelimitedBuilder out) {
        for (OptionParser<T> parsableOption : this.parseableOptions) {
            out.append(parsableOption.getOptionName()).mark();
        }
    }

    @Override
    public String getOptionText(T options, T defaultOptions) {
        DelimitedBuilder out = new DelimitedBuilder(String.valueOf(this.optionDelimiter));
        for (OptionParser<T> parsableOption : this.parseableOptions) {
            String text = parsableOption.getOptionText(options, defaultOptions).trim();
            if (text.isEmpty()) continue;
            out.append(text).mark();
        }
        return out.toString();
    }
}

