/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.bidi.BidiTextRun;
import com.openhtmltopdf.bidi.ParagraphSplitter;
import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.constants.MarginBoxName;
import com.openhtmltopdf.css.constants.PageElementPosition;
import com.openhtmltopdf.css.extend.ContentFunction;
import com.openhtmltopdf.css.newmatch.CascadedStyle;
import com.openhtmltopdf.css.newmatch.PageInfo;
import com.openhtmltopdf.css.parser.CSSPrimitiveValue;
import com.openhtmltopdf.css.parser.FSFunction;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.EmptyStyle;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.layout.CounterFunction;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.layout.Styleable;
import com.openhtmltopdf.layout.WhitespaceStripper;
import com.openhtmltopdf.layout.counter.AbstractCounterContext;
import com.openhtmltopdf.layout.counter.RootCounterContext;
import com.openhtmltopdf.newtable.TableBox;
import com.openhtmltopdf.newtable.TableCellBox;
import com.openhtmltopdf.newtable.TableColumn;
import com.openhtmltopdf.newtable.TableRowBox;
import com.openhtmltopdf.newtable.TableSectionBox;
import com.openhtmltopdf.render.AnonymousBlockBox;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.FloatedBoxData;
import com.openhtmltopdf.render.FlowingColumnBox;
import com.openhtmltopdf.render.FlowingColumnContainerBox;
import com.openhtmltopdf.render.InlineBox;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.OpenUtil;
import com.openhtmltopdf.util.XRLog;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BoxBuilder {
    public static final int MARGIN_BOX_VERTICAL = 1;
    public static final int MARGIN_BOX_HORIZONTAL = 2;
    private static final int CONTENT_LIST_DOCUMENT = 1;
    private static final int CONTENT_LIST_MARGIN_BOX = 2;

    private static void splitParagraphs(LayoutContext c, Document document) {
        c.getParagraphSplitter().splitRoot(c, document);
        c.getParagraphSplitter().runBidiOnParagraphs(c);
    }

    public static BlockBox createRootBox(LayoutContext c, Document document) {
        BoxBuilder.splitParagraphs(c, document);
        Element root = document.getDocumentElement();
        CalculatedStyle style = c.getSharedContext().getStyle(root);
        BlockBox result2 = style.isTable() || style.isInlineTable() ? new TableBox() : new BlockBox();
        result2.setStyle(style);
        result2.setElement(root);
        c.resolveCounters(style);
        return result2;
    }

    public static void createChildren(LayoutContext c, BlockBox parent) {
        if (parent.shouldBeReplaced()) {
            parent.setChildrenContentType(BlockBox.ContentType.EMPTY);
            return;
        }
        if (BoxBuilder.isInsertedBoxIgnored(parent.getElement())) {
            return;
        }
        ArrayList<Styleable> children = new ArrayList<Styleable>();
        ChildBoxInfo info = new ChildBoxInfo();
        CalculatedStyle parentStyle = parent.getStyle();
        boolean oldAllowFootnotes = c.isFootnoteAllowed();
        if (parentStyle.isFixed() || parentStyle.isRunning()) {
            c.setFootnoteAllowed(false);
        }
        BoxBuilder.createChildren(c, parent, parent.getElement(), children, info, false);
        boolean parentIsNestingTableContent = BoxBuilder.isNestingTableContent(parentStyle.getIdent(CSSName.DISPLAY));
        if (!parentIsNestingTableContent && !info.isContainsTableContent()) {
            BoxBuilder.resolveChildren(c, parent, children, info);
        } else {
            BoxBuilder.stripAllWhitespace(children);
            if (parentIsNestingTableContent) {
                BoxBuilder.resolveTableContent(c, parent, children, info);
            } else {
                BoxBuilder.resolveChildTableContent(c, parent, children, info, IdentValue.TABLE_CELL);
            }
        }
        c.setFootnoteAllowed(oldAllowFootnotes);
    }

    private static boolean isInsertedBoxIgnored(Element element) {
        if (element == null) {
            return false;
        }
        String tag = element.getTagName();
        if (!tag.startsWith("fs-")) {
            return false;
        }
        switch (tag) {
            case "fs-footnote": 
            case "fs-footnote-body": {
                return true;
            }
        }
        return false;
    }

    public static TableBox createMarginTable(LayoutContext c, PageInfo pageInfo, MarginBoxName[] names, int height, int direction) {
        if (!pageInfo.hasAny(names)) {
            return null;
        }
        Element source = c.getRootLayer().getMaster().getElement();
        ChildBoxInfo info = new ChildBoxInfo();
        CalculatedStyle pageStyle = new EmptyStyle().deriveStyle(pageInfo.getPageStyle());
        CalculatedStyle tableStyle = pageStyle.deriveStyle(CascadedStyle.createLayoutStyle(new PropertyDeclaration[]{new PropertyDeclaration(CSSName.DISPLAY, new PropertyValue(IdentValue.TABLE), true, 1), new PropertyDeclaration(CSSName.WIDTH, new PropertyValue(2, 100.0f, "100%"), true, 1)}));
        TableBox result2 = (TableBox)BoxBuilder.createBlockBox(tableStyle, info, false);
        result2.setMarginAreaRoot(true);
        result2.setStyle(tableStyle);
        result2.setElement(source);
        result2.setAnonymous(true);
        result2.setChildrenContentType(BlockBox.ContentType.BLOCK);
        CalculatedStyle tableSectionStyle = pageStyle.createAnonymousStyle(IdentValue.TABLE_ROW_GROUP);
        TableSectionBox section = (TableSectionBox)BoxBuilder.createBlockBox(tableSectionStyle, info, false);
        section.setStyle(tableSectionStyle);
        section.setElement(source);
        section.setAnonymous(true);
        section.setChildrenContentType(BlockBox.ContentType.BLOCK);
        result2.addChild(section);
        TableRowBox row = null;
        if (direction == 2) {
            CalculatedStyle tableRowStyle = pageStyle.createAnonymousStyle(IdentValue.TABLE_ROW);
            row = (TableRowBox)BoxBuilder.createBlockBox(tableRowStyle, info, false);
            row.setStyle(tableRowStyle);
            row.setElement(source);
            row.setAnonymous(true);
            row.setChildrenContentType(BlockBox.ContentType.BLOCK);
            row.setHeightOverride(height);
            section.addChild(row);
        }
        int cellCount = 0;
        boolean alwaysCreate = names.length > 1 && direction == 2;
        for (int i = 0; i < names.length; ++i) {
            TableCellBox cell;
            CascadedStyle cellStyle = pageInfo.createMarginBoxStyle(names[i], alwaysCreate);
            if (cellStyle == null || (cell = BoxBuilder.createMarginBox(c, cellStyle, alwaysCreate)) == null) continue;
            if (direction == 1) {
                CalculatedStyle tableRowStyle = pageStyle.createAnonymousStyle(IdentValue.TABLE_ROW);
                row = (TableRowBox)BoxBuilder.createBlockBox(tableRowStyle, info, false);
                row.setStyle(tableRowStyle);
                row.setElement(source);
                row.setAnonymous(true);
                row.setChildrenContentType(BlockBox.ContentType.BLOCK);
                row.setHeightOverride(height);
                section.addChild(row);
            }
            row.addChild(cell);
            ++cellCount;
        }
        if (direction == 1 && cellCount > 0) {
            TableRowBox r;
            int rHeight = 0;
            Iterator<Box> i = section.getChildIterator();
            while (i.hasNext()) {
                r = (TableRowBox)i.next();
                r.setHeightOverride(height / cellCount);
                rHeight += r.getHeightOverride();
            }
            i = section.getChildIterator();
            while (i.hasNext() && rHeight < height) {
                r = (TableRowBox)i.next();
                r.setHeightOverride(r.getHeightOverride() + 1);
                ++rHeight;
            }
        }
        return cellCount > 0 ? result2 : null;
    }

    private static TableCellBox createMarginBox(LayoutContext c, CascadedStyle cascadedStyle, boolean alwaysCreate) {
        boolean hasContent = true;
        PropertyDeclaration contentDecl = cascadedStyle.propertyByName(CSSName.CONTENT);
        CalculatedStyle style = new EmptyStyle().deriveStyle(cascadedStyle);
        if (style.isDisplayNone() && !alwaysCreate) {
            return null;
        }
        if (style.isIdent(CSSName.CONTENT, IdentValue.NONE) || style.isIdent(CSSName.CONTENT, IdentValue.NORMAL)) {
            hasContent = false;
        }
        if (style.isAutoWidth() && !alwaysCreate && !hasContent) {
            return null;
        }
        ArrayList<Styleable> children = new ArrayList<Styleable>();
        ChildBoxInfo info = new ChildBoxInfo();
        info.setContainsTableContent(true);
        info.setLayoutRunningBlocks(true);
        TableCellBox result2 = new TableCellBox();
        result2.setAnonymous(true);
        result2.setStyle(style);
        result2.setElement(c.getRootLayer().getMaster().getElement());
        if (hasContent && !style.isDisplayNone()) {
            children.addAll(BoxBuilder.createGeneratedMarginBoxContent(c, c.getRootLayer().getMaster().getElement(), (PropertyValue)contentDecl.getValue(), style, info));
            BoxBuilder.stripAllWhitespace(children);
        }
        BoxBuilder.resolveChildTableContent(c, result2, children, info, IdentValue.TABLE_CELL);
        return result2;
    }

    private static void resolveChildren(LayoutContext c, BlockBox owner, List<Styleable> children, ChildBoxInfo info) {
        if (children.size() > 0) {
            if (info.isContainsBlockLevelContent()) {
                BoxBuilder.insertAnonymousBlocks(c.getSharedContext(), owner, children, info.isLayoutRunningBlocks());
                owner.setChildrenContentType(BlockBox.ContentType.BLOCK);
            } else {
                WhitespaceStripper.stripInlineContent(children);
                if (children.size() > 0) {
                    owner.setInlineContent(children);
                    owner.setChildrenContentType(BlockBox.ContentType.INLINE);
                } else {
                    owner.setChildrenContentType(BlockBox.ContentType.EMPTY);
                }
            }
        } else {
            owner.setChildrenContentType(BlockBox.ContentType.EMPTY);
        }
    }

    private static boolean isAllProperTableNesting(IdentValue parentDisplay, List<Styleable> children) {
        return children.stream().allMatch(child -> BoxBuilder.isProperTableNesting(parentDisplay, child.getStyle().getIdent(CSSName.DISPLAY)));
    }

    private static void resolveChildTableContent(LayoutContext c, BlockBox parent, List<Styleable> children, ChildBoxInfo info, IdentValue target) {
        ArrayList<Styleable> childrenForAnonymous = new ArrayList<Styleable>();
        ArrayList<Styleable> childrenWithAnonymous = new ArrayList<Styleable>();
        IdentValue nextUp = BoxBuilder.getPreviousTableNestingLevel(target);
        for (Styleable styleable : children) {
            if (BoxBuilder.matchesTableLevel(target, styleable.getStyle().getIdent(CSSName.DISPLAY))) {
                childrenForAnonymous.add(styleable);
                continue;
            }
            if (childrenForAnonymous.size() > 0) {
                BoxBuilder.createAnonymousTableContent(c, (BlockBox)childrenForAnonymous.get(0), nextUp, childrenForAnonymous, childrenWithAnonymous);
                childrenForAnonymous = new ArrayList();
            }
            childrenWithAnonymous.add(styleable);
        }
        if (childrenForAnonymous.size() > 0) {
            BoxBuilder.createAnonymousTableContent(c, (BlockBox)childrenForAnonymous.get(0), nextUp, childrenForAnonymous, childrenWithAnonymous);
        }
        if (nextUp == IdentValue.TABLE) {
            BoxBuilder.rebalanceInlineContent(childrenWithAnonymous);
            info.setContainsBlockLevelContent(true);
            BoxBuilder.resolveChildren(c, parent, childrenWithAnonymous, info);
        } else {
            BoxBuilder.resolveChildTableContent(c, parent, childrenWithAnonymous, info, nextUp);
        }
    }

    private static boolean matchesTableLevel(IdentValue target, IdentValue value) {
        if (target == IdentValue.TABLE_ROW_GROUP) {
            return value == IdentValue.TABLE_ROW_GROUP || value == IdentValue.TABLE_HEADER_GROUP || value == IdentValue.TABLE_FOOTER_GROUP || value == IdentValue.TABLE_CAPTION;
        }
        return target == value;
    }

    private static void rebalanceInlineContent(List<Styleable> content) {
        HashMap<Element, InlineBox> boxesByElement = new HashMap<Element, InlineBox>();
        for (Styleable styleable : content) {
            if (!(styleable instanceof InlineBox)) continue;
            InlineBox iB = (InlineBox)styleable;
            Element elem = iB.getElement();
            if (!boxesByElement.containsKey(elem)) {
                iB.setStartsHere(true);
            }
            boxesByElement.put(elem, iB);
        }
        for (InlineBox iB : boxesByElement.values()) {
            iB.setEndsHere(true);
        }
    }

    private static void stripAllWhitespace(List<Styleable> content) {
        int start = 0;
        int current = 0;
        boolean started = false;
        for (current = 0; current < content.size(); ++current) {
            Styleable styleable = content.get(current);
            if (!styleable.getStyle().isLayedOutInInlineContext()) {
                if (started) {
                    int before = content.size();
                    WhitespaceStripper.stripInlineContent(content.subList(start, current));
                    int after = content.size();
                    current -= before - after;
                }
                started = false;
                continue;
            }
            if (started) continue;
            started = true;
            start = current;
        }
        if (started) {
            WhitespaceStripper.stripInlineContent(content.subList(start, current));
        }
    }

    private static void resolveTableContent(LayoutContext c, BlockBox parent, List<Styleable> children, ChildBoxInfo info) {
        IdentValue parentDisplay = parent.getStyle().getIdent(CSSName.DISPLAY);
        IdentValue next = BoxBuilder.getNextTableNestingLevel(parentDisplay);
        if (next == null && parent.isAnonymous() && BoxBuilder.containsOrphanedTableContent(children)) {
            BoxBuilder.resolveChildTableContent(c, parent, children, info, IdentValue.TABLE_CELL);
        } else if (next == null || BoxBuilder.isAllProperTableNesting(parentDisplay, children)) {
            if (parent.isAnonymous()) {
                BoxBuilder.rebalanceInlineContent(children);
            }
            BoxBuilder.resolveChildren(c, parent, children, info);
        } else {
            ArrayList<Styleable> childrenForAnonymous = new ArrayList<Styleable>();
            ArrayList<Styleable> childrenWithAnonymous = new ArrayList<Styleable>();
            for (Styleable child : children) {
                IdentValue childDisplay = child.getStyle().getIdent(CSSName.DISPLAY);
                if (BoxBuilder.isProperTableNesting(parentDisplay, childDisplay)) {
                    if (childrenForAnonymous.size() > 0) {
                        BoxBuilder.createAnonymousTableContent(c, parent, next, childrenForAnonymous, childrenWithAnonymous);
                        childrenForAnonymous = new ArrayList();
                    }
                    childrenWithAnonymous.add(child);
                    continue;
                }
                childrenForAnonymous.add(child);
            }
            if (childrenForAnonymous.size() > 0) {
                BoxBuilder.createAnonymousTableContent(c, parent, next, childrenForAnonymous, childrenWithAnonymous);
            }
            info.setContainsBlockLevelContent(true);
            BoxBuilder.resolveChildren(c, parent, childrenWithAnonymous, info);
        }
    }

    private static boolean isTableRowOrRowGroup(Styleable child) {
        IdentValue display = child.getStyle().getIdent(CSSName.DISPLAY);
        return display == IdentValue.TABLE_HEADER_GROUP || display == IdentValue.TABLE_ROW_GROUP || display == IdentValue.TABLE_FOOTER_GROUP || display == IdentValue.TABLE_ROW;
    }

    private static boolean containsOrphanedTableContent(List<Styleable> children) {
        return children.stream().anyMatch(BoxBuilder::isTableRowOrRowGroup);
    }

    private static boolean isParentInline(BlockBox box) {
        CalculatedStyle parentStyle = box.getStyle().getParent();
        return parentStyle != null && parentStyle.isInline();
    }

    private static void createAnonymousTableContent(LayoutContext c, BlockBox source, IdentValue next, List<Styleable> childrenForAnonymous, List<Styleable> childrenWithAnonymous) {
        ChildBoxInfo nested = BoxBuilder.lookForBlockContent(childrenForAnonymous);
        IdentValue anonDisplay = BoxBuilder.isParentInline(source) && next == IdentValue.TABLE ? IdentValue.INLINE_TABLE : next;
        CalculatedStyle anonStyle = source.getStyle().createAnonymousStyle(anonDisplay);
        BlockBox anonBox = BoxBuilder.createBlockBox(anonStyle, nested, false);
        anonBox.setStyle(anonStyle);
        anonBox.setAnonymous(true);
        anonBox.setElement(source.getElement());
        BoxBuilder.resolveTableContent(c, anonBox, childrenForAnonymous, nested);
        if (next == IdentValue.TABLE) {
            childrenWithAnonymous.add(BoxBuilder.reorderTableContent(c, (TableBox)anonBox));
        } else {
            childrenWithAnonymous.add(anonBox);
        }
    }

    private static BlockBox reorderTableContent(LayoutContext c, TableBox table) {
        CalculatedStyle anonStyle;
        ArrayList<Box> topCaptions = new ArrayList<Box>();
        Box header = null;
        ArrayList<Box> bodies = new ArrayList<Box>();
        Box footer = null;
        ArrayList<Box> bottomCaptions = new ArrayList<Box>();
        for (Box b : table.getChildren()) {
            IdentValue display = b.getStyle().getIdent(CSSName.DISPLAY);
            if (display == IdentValue.TABLE_CAPTION) {
                IdentValue side = b.getStyle().getIdent(CSSName.CAPTION_SIDE);
                if (side == IdentValue.BOTTOM) {
                    bottomCaptions.add(b);
                    continue;
                }
                topCaptions.add(b);
                continue;
            }
            if (display == IdentValue.TABLE_HEADER_GROUP && header == null) {
                header = b;
                continue;
            }
            if (display == IdentValue.TABLE_FOOTER_GROUP && footer == null) {
                footer = b;
                continue;
            }
            bodies.add(b);
        }
        table.removeAllChildren();
        if (header != null) {
            ((TableSectionBox)header).setHeader(true);
            table.addChild(header);
        }
        table.addAllChildren(bodies);
        if (footer != null) {
            ((TableSectionBox)footer).setFooter(true);
            table.addChild(footer);
        }
        if (topCaptions.size() == 0 && bottomCaptions.size() == 0) {
            return table;
        }
        if (table.getStyle().isFloated()) {
            CascadedStyle cascadedStyle = CascadedStyle.createLayoutStyle(new PropertyDeclaration[]{CascadedStyle.createLayoutPropertyDeclaration(CSSName.DISPLAY, IdentValue.BLOCK), CascadedStyle.createLayoutPropertyDeclaration(CSSName.FLOAT, table.getStyle().getIdent(CSSName.FLOAT))});
            anonStyle = table.getStyle().deriveStyle(cascadedStyle);
        } else {
            anonStyle = table.getStyle().createAnonymousStyle(IdentValue.BLOCK);
        }
        BlockBox anonBox = new BlockBox();
        anonBox.setStyle(anonStyle);
        anonBox.setAnonymous(true);
        anonBox.setFromCaptionedTable(true);
        anonBox.setElement(table.getElement());
        anonBox.setChildrenContentType(BlockBox.ContentType.BLOCK);
        anonBox.addAllChildren(topCaptions);
        anonBox.addChild(table);
        anonBox.addAllChildren(bottomCaptions);
        if (table.getStyle().isFloated()) {
            anonBox.setFloatedBoxData(new FloatedBoxData());
            table.setFloatedBoxData(null);
            CascadedStyle original = c.getSharedContext().getCss().getCascadedStyle(table.getElement(), false);
            CascadedStyle modified = CascadedStyle.createLayoutStyle(original, new PropertyDeclaration[]{CascadedStyle.createLayoutPropertyDeclaration(CSSName.FLOAT, IdentValue.NONE)});
            table.setStyle(table.getStyle().getParent().deriveStyle(modified));
        }
        return anonBox;
    }

    private static ChildBoxInfo lookForBlockContent(List<Styleable> styleables) {
        ChildBoxInfo result2 = new ChildBoxInfo();
        if (styleables.stream().anyMatch(s -> !s.getStyle().isLayedOutInInlineContext())) {
            result2.setContainsBlockLevelContent(true);
        }
        return result2;
    }

    private static IdentValue getNextTableNestingLevel(IdentValue display) {
        if (display == IdentValue.TABLE || display == IdentValue.INLINE_TABLE) {
            return IdentValue.TABLE_ROW_GROUP;
        }
        if (display == IdentValue.TABLE_HEADER_GROUP || display == IdentValue.TABLE_ROW_GROUP || display == IdentValue.TABLE_FOOTER_GROUP) {
            return IdentValue.TABLE_ROW;
        }
        if (display == IdentValue.TABLE_ROW) {
            return IdentValue.TABLE_CELL;
        }
        return null;
    }

    private static IdentValue getPreviousTableNestingLevel(IdentValue display) {
        if (display == IdentValue.TABLE_CELL) {
            return IdentValue.TABLE_ROW;
        }
        if (display == IdentValue.TABLE_ROW) {
            return IdentValue.TABLE_ROW_GROUP;
        }
        if (display == IdentValue.TABLE_HEADER_GROUP || display == IdentValue.TABLE_ROW_GROUP || display == IdentValue.TABLE_FOOTER_GROUP) {
            return IdentValue.TABLE;
        }
        return null;
    }

    private static boolean isProperTableNesting(IdentValue parent, IdentValue child) {
        return parent == IdentValue.TABLE && (child == IdentValue.TABLE_HEADER_GROUP || child == IdentValue.TABLE_ROW_GROUP || child == IdentValue.TABLE_FOOTER_GROUP || child == IdentValue.TABLE_CAPTION) || (parent == IdentValue.TABLE_HEADER_GROUP || parent == IdentValue.TABLE_ROW_GROUP || parent == IdentValue.TABLE_FOOTER_GROUP) && child == IdentValue.TABLE_ROW || parent == IdentValue.TABLE_ROW && child == IdentValue.TABLE_CELL || parent == IdentValue.INLINE_TABLE && (child == IdentValue.TABLE_HEADER_GROUP || child == IdentValue.TABLE_ROW_GROUP || child == IdentValue.TABLE_FOOTER_GROUP);
    }

    private static boolean isNestingTableContent(IdentValue display) {
        return display == IdentValue.TABLE || display == IdentValue.INLINE_TABLE || display == IdentValue.TABLE_HEADER_GROUP || display == IdentValue.TABLE_ROW_GROUP || display == IdentValue.TABLE_FOOTER_GROUP || display == IdentValue.TABLE_ROW;
    }

    private static boolean isAttrFunction(FSFunction function) {
        List<PropertyValue> params;
        if (function.getName().equals("attr") && (params = function.getParameters()).size() == 1) {
            PropertyValue value = params.get(0);
            return value.getPrimitiveType() == 21;
        }
        return false;
    }

    public static boolean isElementFunction(FSFunction function) {
        if (function.getName().equals("element")) {
            List<PropertyValue> params = function.getParameters();
            if (params.size() < 1 || params.size() > 2) {
                return false;
            }
            boolean ok = true;
            PropertyValue value1 = params.get(0);
            boolean bl = ok = value1.getPrimitiveType() == 21;
            if (ok && params.size() == 2) {
                PropertyValue value2 = params.get(1);
                ok = value2.getPrimitiveType() == 21;
            }
            return ok;
        }
        return false;
    }

    private static CounterFunction makeCounterFunction(FSFunction function, LayoutContext c, CalculatedStyle style) {
        if (function.getName().equals("counter")) {
            List<PropertyValue> params = function.getParameters();
            if (params.size() < 1 || params.size() > 2) {
                return null;
            }
            PropertyValue value = params.get(0);
            if (value.getPrimitiveType() != 21) {
                return null;
            }
            String s = value.getStringValue();
            if (s.equals("page") || s.equals("pages")) {
                return null;
            }
            String counter = value.getStringValue();
            IdentValue listStyleType = IdentValue.DECIMAL;
            if (params.size() == 2) {
                value = params.get(1);
                if (value.getPrimitiveType() != 21) {
                    return null;
                }
                IdentValue identValue = IdentValue.valueOf(value.getStringValue());
                if (identValue != null) {
                    value.setIdentValue(identValue);
                    listStyleType = identValue;
                }
            }
            if ("footnote".equals(s)) {
                RootCounterContext rootCc = c.getSharedContext().getGlobalCounterContext();
                int counterValue = rootCc.getCurrentCounterValue(s);
                return new CounterFunction(counterValue, listStyleType);
            }
            AbstractCounterContext cc = c.getCounterContext(style);
            int counterValue = cc.getCurrentCounterValue(counter);
            return new CounterFunction(counterValue, listStyleType);
        }
        if (function.getName().equals("counters")) {
            List<PropertyValue> params = function.getParameters();
            if (params.size() < 2 || params.size() > 3) {
                return null;
            }
            PropertyValue value = params.get(0);
            if (value.getPrimitiveType() != 21) {
                return null;
            }
            String counter = value.getStringValue();
            value = params.get(1);
            if (value.getPrimitiveType() != 19) {
                return null;
            }
            String separator = value.getStringValue();
            IdentValue listStyleType = IdentValue.DECIMAL;
            if (params.size() == 3) {
                value = params.get(2);
                if (value.getPrimitiveType() != 21) {
                    return null;
                }
                IdentValue identValue = IdentValue.valueOf(value.getStringValue());
                if (identValue != null) {
                    value.setIdentValue(identValue);
                    listStyleType = identValue;
                }
            }
            List<Integer> counterValues = c.getCounterContext(style).getCurrentCounterValues(counter);
            return new CounterFunction(counterValues, separator, listStyleType);
        }
        return null;
    }

    private static String getAttributeValue(FSFunction attrFunc, Element e) {
        PropertyValue value = attrFunc.getParameters().get(0);
        return e.getAttribute(value.getStringValue());
    }

    private static List<Styleable> createGeneratedContentList(LayoutContext c, Element element, List<PropertyValue> values, String peName, CalculatedStyle style, int mode, ChildBoxInfo info, List<Styleable> result2) {
        for (PropertyValue value : values) {
            FSDerivedValue dv;
            ContentFunction contentFunction = null;
            FSFunction function = null;
            String content = null;
            short type = value.getPrimitiveType();
            if (type == 19) {
                content = value.getStringValue();
            } else if (type == 20) {
                Element creator = element != null ? element : c.getRootLayer().getMaster().getElement();
                Document doc = creator.getOwnerDocument();
                Element img = doc.createElement("img");
                img.setAttribute("src", value.getStringValue());
                img.setAttribute("fs-ignore", "true");
                creator.appendChild(img);
                CalculatedStyle anon = style.createAnonymousStyle(IdentValue.INLINE_BLOCK);
                BlockBox iB = new BlockBox();
                iB.setElement(img);
                iB.setStyle(anon);
                iB.setPseudoElementOrClass(peName);
                result2.add(iB);
            } else if (value.getPropertyValueType() == 7) {
                if (mode == 1 && BoxBuilder.isAttrFunction(value.getFunction())) {
                    content = BoxBuilder.getAttributeValue(value.getFunction(), element);
                } else {
                    CounterFunction cFunc = null;
                    if (mode == 1) {
                        cFunc = BoxBuilder.makeCounterFunction(value.getFunction(), c, style);
                    }
                    if (cFunc != null) {
                        content = cFunc.evaluate();
                        contentFunction = null;
                        function = null;
                    } else if (mode == 2 && BoxBuilder.isElementFunction(value.getFunction())) {
                        BlockBox target = BoxBuilder.getRunningBlock(c, value);
                        if (target != null) {
                            result2.add(target.copyOf());
                            info.setContainsBlockLevelContent(true);
                        }
                    } else {
                        contentFunction = c.getContentFunctionFactory().lookupFunction(c, value.getFunction());
                        if (contentFunction != null) {
                            function = value.getFunction();
                            if (contentFunction.isStatic()) {
                                content = contentFunction.calculate(c, function);
                                contentFunction = null;
                                function = null;
                            } else {
                                content = contentFunction.getLayoutReplacementText();
                            }
                        }
                    }
                }
            } else if (type == 21 && (dv = style.valueByName(CSSName.QUOTES)) != IdentValue.NONE) {
                String[] quotes;
                IdentValue ident = value.getIdentValue();
                if (ident == IdentValue.OPEN_QUOTE) {
                    quotes = style.asStringArray(CSSName.QUOTES);
                    content = quotes[0];
                } else if (ident == IdentValue.CLOSE_QUOTE) {
                    quotes = style.asStringArray(CSSName.QUOTES);
                    content = quotes[1];
                }
            }
            if (content == null) continue;
            InlineBox iB = new InlineBox(content);
            iB.setContentFunction(contentFunction);
            iB.setFunction(function);
            iB.setElement(element);
            iB.setPseudoElementOrClass(peName);
            iB.setStartsHere(true);
            iB.setEndsHere(true);
            result2.add(iB);
        }
        return result2;
    }

    private static Element createFootnoteTarget(LayoutContext c, Element parent) {
        if (parent == null) {
            return null;
        }
        Document doc = parent.getOwnerDocument();
        Element target = doc.createElement("fs-footnote-marker");
        target.setAttribute("id", "fs-footnote-" + c.getFootnoteIndex());
        parent.appendChild(target);
        return target;
    }

    private static Element createFootnoteCallAnchor(LayoutContext c, Element parent) {
        if (parent == null) {
            return null;
        }
        Document doc = parent.getOwnerDocument();
        Element anchor = doc.createElement("a");
        anchor.setAttribute("href", "#fs-footnote-" + c.getFootnoteIndex());
        parent.appendChild(anchor);
        return anchor;
    }

    public static BlockBox getRunningBlock(LayoutContext c, PropertyValue value) {
        List<PropertyValue> params = value.getFunction().getParameters();
        String ident = params.get(0).getStringValue();
        PageElementPosition position = null;
        if (params.size() == 2) {
            position = PageElementPosition.valueOf(params.get(1).getStringValue());
        }
        if (position == null) {
            position = PageElementPosition.FIRST;
        }
        BlockBox target = c.getRootDocumentLayer().getRunningBlock(ident, c.getPage(), position);
        return target;
    }

    private static void insertGeneratedContent(LayoutContext c, Element element, CalculatedStyle parentStyle, String peName, List<Styleable> children, ChildBoxInfo info) {
        CascadedStyle peStyle = c.getCss().getPseudoElementStyle(element, peName);
        if (peStyle != null) {
            PropertyDeclaration contentDecl = peStyle.propertyByName(CSSName.CONTENT);
            PropertyDeclaration counterResetDecl = peStyle.propertyByName(CSSName.COUNTER_RESET);
            PropertyDeclaration counterIncrDecl = peStyle.propertyByName(CSSName.COUNTER_INCREMENT);
            CalculatedStyle calculatedStyle = null;
            if (contentDecl != null || counterResetDecl != null || counterIncrDecl != null) {
                calculatedStyle = parentStyle.deriveStyle(peStyle);
                if (calculatedStyle.isDisplayNone() || calculatedStyle.isIdent(CSSName.CONTENT, IdentValue.NONE) || calculatedStyle.isIdent(CSSName.CONTENT, IdentValue.NORMAL) && (peName.equals("before") || peName.equals("after"))) {
                    return;
                }
                if (calculatedStyle.isTable() || calculatedStyle.isTableRow() || calculatedStyle.isTableSection()) {
                    calculatedStyle = parentStyle.createAnonymousStyle(IdentValue.BLOCK);
                }
                c.resolveCounters(calculatedStyle);
            }
            if (contentDecl != null) {
                CSSPrimitiveValue propValue = contentDecl.getValue();
                children.addAll(BoxBuilder.createGeneratedContent(c, element, peName, calculatedStyle, (PropertyValue)propValue, info));
            }
        }
    }

    private static List<Styleable> createGeneratedContent(LayoutContext c, Element element, String peName, CalculatedStyle style, PropertyValue property, ChildBoxInfo info) {
        if (style.isDisplayNone() || style.isIdent(CSSName.DISPLAY, IdentValue.TABLE_COLUMN) || style.isIdent(CSSName.DISPLAY, IdentValue.TABLE_COLUMN_GROUP) || property.getValues() == null) {
            return Collections.emptyList();
        }
        if ("footnote-call".equals(peName) || "footnote-marker".equals(peName)) {
            if (!BoxBuilder.isValidFootnotePseudo(style)) {
                BoxBuilder.logInvalidFootnotePseudo(peName, style);
                return Collections.emptyList();
            }
        } else {
            if (c.isInFloatBottom() && !BoxBuilder.isValidFootnotePseudo(style)) {
                BoxBuilder.logInvalidFootnotePseudo(peName, style);
                return Collections.emptyList();
            }
            if (style.isFootnote()) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.GENERAL_FOOTNOTE_CAN_NOT_BE_PSEUDO, peName);
                return Collections.emptyList();
            }
        }
        ChildBoxInfo childInfo = new ChildBoxInfo();
        List<PropertyValue> values = property.getValues();
        ArrayList<Styleable> result2 = new ArrayList<Styleable>(values.size());
        BoxBuilder.createGeneratedContentList(c, element, values, peName, style, 1, childInfo, result2);
        return BoxBuilder.wrapGeneratedContent(c, element, peName, style, info, childInfo, result2);
    }

    private static List<Styleable> wrapGeneratedContent(LayoutContext c, Element element, String peName, CalculatedStyle style, ChildBoxInfo info, ChildBoxInfo childInfo, List<Styleable> inlineBoxes) {
        Element wrapperElement = element;
        if ("footnote-call".equals(peName)) {
            wrapperElement = BoxBuilder.createFootnoteCallAnchor(c, element);
        } else if ("footnote-marker".equals(peName)) {
            wrapperElement = BoxBuilder.createFootnoteTarget(c, element);
        }
        if (style.isInline()) {
            ArrayList<Styleable> pseudoInlines = new ArrayList<Styleable>(inlineBoxes.size() + 2);
            InlineBox pseudoStart = new InlineBox("");
            pseudoStart.setStartsHere(true);
            pseudoStart.setEndsHere(false);
            pseudoStart.setStyle(style);
            pseudoStart.setElement(wrapperElement);
            pseudoStart.setPseudoElementOrClass(peName);
            pseudoInlines.add(pseudoStart);
            CalculatedStyle inlineContent = style.createAnonymousStyle(IdentValue.INLINE);
            for (Styleable styleable : inlineBoxes) {
                if (styleable instanceof InlineBox) {
                    InlineBox iB = (InlineBox)styleable;
                    iB.setElement(null);
                    iB.setStyle(inlineContent);
                    iB.applyTextTransform();
                }
                pseudoInlines.add(styleable);
            }
            InlineBox pseudoEnd = new InlineBox("");
            pseudoEnd.setStartsHere(false);
            pseudoEnd.setEndsHere(true);
            pseudoEnd.setStyle(style);
            pseudoEnd.setElement(wrapperElement);
            pseudoEnd.setPseudoElementOrClass(peName);
            pseudoInlines.add(pseudoEnd);
            return pseudoInlines;
        }
        CalculatedStyle anon = style.createAnonymousStyle(IdentValue.INLINE);
        for (Styleable styleable : inlineBoxes) {
            if (!(styleable instanceof InlineBox)) continue;
            InlineBox iB = (InlineBox)styleable;
            iB.setElement(null);
            iB.setStyle(anon);
            iB.applyTextTransform();
        }
        BlockBox result2 = BoxBuilder.createBlockBox(style, info, true);
        result2.setStyle(style);
        result2.setInlineContent(inlineBoxes);
        result2.setElement(wrapperElement);
        result2.setChildrenContentType(BlockBox.ContentType.INLINE);
        result2.setPseudoElementOrClass(peName);
        if (!style.isLayedOutInInlineContext()) {
            info.setContainsBlockLevelContent(true);
        }
        return new ArrayList<Styleable>(Collections.singletonList(result2));
    }

    private static List<Styleable> createGeneratedMarginBoxContent(LayoutContext c, Element element, PropertyValue property, CalculatedStyle style, ChildBoxInfo info) {
        List<PropertyValue> values = property.getValues();
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<Styleable> result2 = new ArrayList<Styleable>(values.size());
        BoxBuilder.createGeneratedContentList(c, element, values, null, style, 2, info, result2);
        CalculatedStyle anon = style.createAnonymousStyle(IdentValue.INLINE);
        for (Styleable s : result2) {
            if (!(s instanceof InlineBox)) continue;
            InlineBox iB = (InlineBox)s;
            iB.setElement(null);
            iB.setStyle(anon);
            iB.applyTextTransform();
        }
        return result2;
    }

    private static BlockBox createBlockBox(CalculatedStyle style, ChildBoxInfo info, boolean generated) {
        if (style.isFloated() && !style.isAbsolute() && !style.isFixed()) {
            BlockBox result2;
            if (style.isTable() || style.isInlineTable()) {
                result2 = new TableBox();
            } else if (style.isTableCell()) {
                info.setContainsTableContent(true);
                result2 = new TableCellBox();
            } else {
                result2 = new BlockBox();
            }
            result2.setFloatedBoxData(new FloatedBoxData());
            return result2;
        }
        if (style.isSpecifiedAsBlock()) {
            return new BlockBox();
        }
        if (!generated && (style.isTable() || style.isInlineTable())) {
            return new TableBox();
        }
        if (style.isTableCell()) {
            info.setContainsTableContent(true);
            return new TableCellBox();
        }
        if (!generated && style.isTableRow()) {
            info.setContainsTableContent(true);
            return new TableRowBox();
        }
        if (!generated && style.isTableSection()) {
            info.setContainsTableContent(true);
            return new TableSectionBox();
        }
        if (style.isTableCaption()) {
            info.setContainsTableContent(true);
            return new BlockBox();
        }
        return new BlockBox();
    }

    private static void addColumns(LayoutContext c, TableBox table, TableColumn parent) {
        SharedContext sharedContext = c.getSharedContext();
        boolean found = false;
        for (Node working = parent.getElement().getFirstChild(); working != null; working = working.getNextSibling()) {
            Element element;
            CalculatedStyle style;
            if (working.getNodeType() != 1 || !(style = sharedContext.getStyle(element = (Element)working)).isIdent(CSSName.DISPLAY, IdentValue.TABLE_COLUMN)) continue;
            found = true;
            TableColumn col = new TableColumn(element, style);
            col.setParent(parent);
            table.addStyleColumn(col);
        }
        if (!found) {
            table.addStyleColumn(parent);
        }
    }

    private static void addColumnOrColumnGroup(LayoutContext c, TableBox table, Element e, CalculatedStyle style) {
        if (style.isIdent(CSSName.DISPLAY, IdentValue.TABLE_COLUMN)) {
            table.addStyleColumn(new TableColumn(e, style));
        } else {
            BoxBuilder.addColumns(c, table, new TableColumn(e, style));
        }
    }

    private static InlineBox createInlineBox(String text, Element parent, CalculatedStyle parentStyle, Text node) {
        InlineBox result2 = new InlineBox(text);
        if (parentStyle.isInline() && !(parent.getParentNode() instanceof Document)) {
            result2.setStyle(parentStyle);
            result2.setElement(parent);
        } else {
            result2.setStyle(parentStyle.createAnonymousStyle(IdentValue.INLINE));
        }
        result2.applyTextTransform();
        return result2;
    }

    private static boolean isValidFootnote(LayoutContext c, Element element, CalculatedStyle style) {
        return c.isPrint() && (style.isInline() || style.isSpecifiedAsBlock()) && !style.isPostionedOrFloated() && !style.isRunning() && !c.getSharedContext().getReplacedElementFactory().isReplacedElement(element);
    }

    private static void logInvalidFootnoteStyle(LayoutContext c, Element element, CalculatedStyle style) {
        String cause = "";
        if (!style.isInline() && !style.isSpecifiedAsBlock()) {
            cause = "The footnote element should be display: block (such as <div>)";
        } else if (style.isFloated()) {
            cause = "The footnote element must not be floated";
        } else if (c.getSharedContext().getReplacedElementFactory().isReplacedElement(element)) {
            cause = "The footnote element must not be replaced (such as <img>)";
        } else if (style.isPositioned() || style.isRunning()) {
            cause = "The footnote element must have position: static (not absolute, relative, running or fixed)";
        }
        XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.GENERAL_FOOTNOTE_INVALID, cause);
    }

    private static boolean isValidFootnotePseudo(CalculatedStyle style) {
        return !style.isFixed() && !style.isFootnote();
    }

    private static void logInvalidFootnotePseudo(String peName, CalculatedStyle style) {
        String cause = "";
        if (style.isFixed()) {
            cause = "Footnote pseudo element (" + peName + ") may not have fixed position";
        } else if (style.isFootnote()) {
            cause = "Footnote pseudo element (" + peName + ") may not have float: footnote set itself";
        }
        XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.GENERAL_FOOTNOTE_PSEUDO_INVALID, cause);
    }

    private static boolean isGeneratedElement(Element element) {
        String tag = element.getNodeName();
        return "fs-footnote-marker".equals(tag) || "a".equals(tag) && element.getAttribute("href").startsWith("#fs-footnote") || "img".equals(tag) && element.getAttribute("fs-ignore").equals("true");
    }

    private static void createElementChild(LayoutContext c, Element parent, BlockBox blockParent, Node working, List<Styleable> children, ChildBoxInfo info, CreateChildrenContext context) {
        Element element;
        Styleable child = null;
        SharedContext sharedContext = c.getSharedContext();
        CalculatedStyle style = sharedContext.getStyle(element = (Element)working);
        if (style.isDisplayNone() || BoxBuilder.isGeneratedElement(element)) {
            return;
        }
        BoxBuilder.resolveElementCounters(c, working, element, style);
        if (style.isIdent(CSSName.DISPLAY, IdentValue.TABLE_COLUMN) || style.isIdent(CSSName.DISPLAY, IdentValue.TABLE_COLUMN_GROUP)) {
            if (blockParent != null && (blockParent.getStyle().isTable() || blockParent.getStyle().isInlineTable())) {
                TableBox table = (TableBox)blockParent;
                BoxBuilder.addColumnOrColumnGroup(c, table, element, style);
            }
            return;
        }
        if (style.isFootnote() && !c.isInFloatBottom() && c.isFootnoteAllowed()) {
            if (BoxBuilder.isValidFootnote(c, element, style)) {
                c.setFootnoteIndex(c.getFootnoteIndex() + 1);
                BoxBuilder.insertGeneratedContent(c, element, style, "footnote-call", children, info);
                BlockBox footnoteBody = BoxBuilder.createFootnoteBody(c, element, style);
                InlineBox iB = BoxBuilder.createInlineBox("", parent, context.parentStyle, null);
                iB.setStartsHere(true);
                iB.setEndsHere(true);
                iB.setFootnote(footnoteBody);
                children.add(iB);
                return;
            }
            BoxBuilder.logInvalidFootnoteStyle(c, element, style);
        }
        if (style.isInline()) {
            BoxBuilder.createInlineChildren(c, parent, children, info, context, element);
        } else {
            child = BoxBuilder.createChildBlockBox(c, info, element, style);
        }
        if (child != null) {
            children.add(child);
        }
    }

    private static void createInlineChildren(LayoutContext c, Element parent, List<Styleable> children, ChildBoxInfo info, CreateChildrenContext context, Element element) {
        if (context.needStartText) {
            context.needStartText = false;
            InlineBox iB = BoxBuilder.createInlineBox("", parent, context.parentStyle, null);
            iB.setStartsHere(true);
            iB.setEndsHere(false);
            children.add(iB);
            context.previousIB = iB;
        }
        BoxBuilder.createChildren(c, null, element, children, info, true);
        if (context.inline) {
            if (context.previousIB != null) {
                context.previousIB.setEndsHere(false);
            }
            context.needEndText = true;
        }
    }

    private static Styleable createChildBlockBox(LayoutContext c, ChildBoxInfo info, Element element, CalculatedStyle style) {
        BlockBox block;
        BlockBox child = style.hasColumns() && c.isPrint() ? new FlowingColumnContainerBox() : BoxBuilder.createBlockBox(style, info, false);
        child.setStyle(style);
        child.setElement(element);
        if (style.hasColumns() && c.isPrint()) {
            BoxBuilder.createColumnContainer(c, child, element, style);
        }
        if (style.isListItem()) {
            block = child;
            block.setListCounter(c.getCounterContext(style).getCurrentCounterValue("list-item"));
        }
        if (style.isTable() || style.isInlineTable()) {
            TableBox table = (TableBox)child;
            table.ensureChildren(c);
            child = BoxBuilder.reorderTableContent(c, table);
        }
        if (!info.isContainsBlockLevelContent() && !style.isLayedOutInInlineContext()) {
            info.setContainsBlockLevelContent(true);
        }
        if ((block = child).getStyle().mayHaveFirstLine()) {
            block.setFirstLineStyle(c.getCss().getPseudoElementStyle(element, "first-line"));
        }
        if (block.getStyle().mayHaveFirstLetter()) {
            block.setFirstLetterStyle(c.getCss().getPseudoElementStyle(element, "first-letter"));
        }
        block.ensureChildren(c);
        return child;
    }

    private static BlockBox createFootnoteBody(LayoutContext c, Element element, CalculatedStyle style) {
        ArrayList<Styleable> footnoteChildren = new ArrayList<Styleable>();
        ChildBoxInfo footnoteChildInfo = new ChildBoxInfo();
        BlockBox footnoteBody = new BlockBox();
        CalculatedStyle footnoteBodyStyle = style.createAnonymousStyle(IdentValue.BLOCK);
        Element fnBodyElement = element.getOwnerDocument().createElement("fs-footnote-body");
        c.getRootLayer().getMaster().getElement().appendChild(fnBodyElement);
        footnoteBody.setElement(fnBodyElement);
        footnoteBody.setStyle(footnoteBodyStyle);
        footnoteBody.setContainingBlock(null);
        Layer layer = new Layer(footnoteBody, c, true);
        footnoteBody.setLayer(layer);
        footnoteBody.setContainingLayer(layer);
        c.pushLayer(layer);
        c.setIsInFloatBottom(true);
        CreateChildrenContext context = new CreateChildrenContext(false, false, style.getParent(), false);
        BoxBuilder.createElementChild(c, (Element)element.getParentNode(), footnoteBody, element, footnoteChildren, footnoteChildInfo, context);
        BoxBuilder.resolveChildren(c, footnoteBody, footnoteChildren, footnoteChildInfo);
        c.setFootnoteAllowed(true);
        c.setIsInFloatBottom(false);
        c.popLayer();
        return footnoteBody;
    }

    private static void createColumnContainer(LayoutContext c, Styleable child, Element element, CalculatedStyle style) {
        FlowingColumnContainerBox cont = (FlowingColumnContainerBox)child;
        cont.setOnlyChild(c, new FlowingColumnBox(cont));
        cont.getChild().setStyle(style.createAnonymousStyle(IdentValue.BLOCK));
        cont.getChild().setElement(element);
        cont.getChild().ensureChildren(c);
    }

    private static void resolveElementCounters(LayoutContext c, Node working, Element element, CalculatedStyle style) {
        Integer attrValue = null;
        if ("ol".equals(working.getNodeName()) && element.hasAttribute("start")) {
            attrValue = OpenUtil.parseIntegerOrNull(element.getAttribute("start"));
        } else if ("li".equals(working.getNodeName()) && element.hasAttribute("value")) {
            attrValue = OpenUtil.parseIntegerOrNull(element.getAttribute("value"));
        }
        if (attrValue != null) {
            c.resolveCounters(style, attrValue - 1);
        } else {
            c.resolveCounters(style, null);
        }
    }

    private static void createChildren(LayoutContext c, BlockBox blockParent, Element parent, List<Styleable> children, ChildBoxInfo info, boolean inline) {
        boolean needEndText;
        if (BoxBuilder.isInsertedBoxIgnored(parent)) {
            return;
        }
        SharedContext sharedContext = c.getSharedContext();
        CalculatedStyle parentStyle = sharedContext.getStyle(parent);
        BoxBuilder.insertGeneratedContent(c, parent, parentStyle, "before", children, info);
        if (parentStyle.isFootnote()) {
            if (c.isFootnoteAllowed() && BoxBuilder.isValidFootnote(c, parent, parentStyle)) {
                BoxBuilder.insertGeneratedContent(c, parent, parentStyle, "footnote-marker", children, info);
                c.setFootnoteAllowed(false);
            } else if (!c.isFootnoteAllowed()) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.GENERAL_NO_FOOTNOTES_INSIDE_FOOTNOTES);
            }
        }
        Node working = parent.getFirstChild();
        CreateChildrenContext context = null;
        if (working != null) {
            context = new CreateChildrenContext(inline, inline, parentStyle, inline);
            do {
                short nodeType;
                if ((nodeType = working.getNodeType()) == 1) {
                    BoxBuilder.createElementChild(c, parent, blockParent, working, children, info, context);
                    continue;
                }
                if (nodeType != 3 && nodeType != 4) continue;
                context.needStartText = false;
                context.needEndText = false;
                Text textNode = (Text)working;
                if (textNode.getParentNode().getNodeName().equals("textarea")) continue;
                context.previousIB = BoxBuilder.doBidi(c, textNode, parent, parentStyle, context.previousIB, children);
            } while ((working = working.getNextSibling()) != null);
        }
        boolean needStartText = context != null ? context.needStartText : inline;
        boolean bl = needEndText = context != null ? context.needEndText : inline;
        if (needStartText || needEndText) {
            InlineBox iB = BoxBuilder.createInlineBox("", parent, parentStyle, null);
            iB.setStartsHere(needStartText);
            iB.setEndsHere(needEndText);
            children.add(iB);
        }
        BoxBuilder.insertGeneratedContent(c, parent, parentStyle, "after", children, info);
    }

    private static InlineBox setupInlineChild(InlineBox child, InlineBox previousIB) {
        child.setEndsHere(true);
        if (previousIB == null) {
            child.setStartsHere(true);
        } else {
            previousIB.setEndsHere(false);
        }
        return child;
    }

    private static InlineBox doFakeBidi(LayoutContext c, Text textNode, Element parent, CalculatedStyle parentStyle, InlineBox previousIB, List<Styleable> children) {
        String runText = textNode.getData();
        InlineBox child = BoxBuilder.createInlineBox(runText, parent, parentStyle, textNode);
        child.setTextDirection((byte)0);
        previousIB = BoxBuilder.setupInlineChild(child, previousIB);
        children.add(child);
        return previousIB;
    }

    private static InlineBox doBidi(LayoutContext c, Text textNode, Element parent, CalculatedStyle parentStyle, InlineBox previousIB, List<Styleable> children) {
        ParagraphSplitter.Paragraph para = c.getParagraphSplitter().lookupParagraph(textNode);
        if (para == null) {
            return BoxBuilder.doFakeBidi(c, textNode, parent, parentStyle, previousIB, children);
        }
        int startIndex = para.getFirstCharIndexInParagraph(textNode);
        if (startIndex < 0) {
            return BoxBuilder.doFakeBidi(c, textNode, parent, parentStyle, previousIB, children);
        }
        int nodeIndex = 0;
        BidiTextRun prevSplit = para.prevSplit(startIndex);
        assert (prevSplit != null);
        assert (prevSplit.getStart() <= startIndex);
        int maxRunLength = prevSplit.getLength() - (startIndex - prevSplit.getStart());
        int splitLength = Math.min(maxRunLength, textNode.getLength());
        nodeIndex += splitLength;
        startIndex += splitLength;
        assert (prevSplit.getDirection() == 0 || prevSplit.getDirection() == 1);
        String runText = splitLength == textNode.getLength() ? textNode.getData() : textNode.getData().substring(0, nodeIndex);
        if (prevSplit.getDirection() == 1) {
            runText = c.getBidiReorderer().shapeText(runText);
        }
        InlineBox child = BoxBuilder.createInlineBox(runText, parent, parentStyle, textNode);
        child.setTextDirection(prevSplit.getDirection());
        previousIB = BoxBuilder.setupInlineChild(child, previousIB);
        children.add(child);
        if (splitLength != textNode.getLength()) {
            do {
                int newLength;
                BidiTextRun newSplit = para.nextSplit(startIndex);
                assert (newSplit != null);
                if (newSplit != null) {
                    int newMaxRunLength = newSplit.getLength() - (startIndex - newSplit.getStart());
                    newLength = Math.min(newMaxRunLength, textNode.getLength() - nodeIndex);
                    runText = textNode.getData().substring(nodeIndex, nodeIndex + newLength);
                    if (newSplit.getDirection() == 1) {
                        runText = c.getBidiReorderer().shapeText(runText);
                    }
                    startIndex += newLength;
                    nodeIndex += newLength;
                    child = BoxBuilder.createInlineBox(runText, parent, parentStyle, textNode);
                    child.setTextDirection(newSplit.getDirection());
                    previousIB = BoxBuilder.setupInlineChild(child, previousIB);
                    children.add(child);
                    continue;
                }
                newLength = textNode.getLength() - nodeIndex;
                runText = textNode.getData().substring(nodeIndex, newLength);
                child = BoxBuilder.createInlineBox(runText, parent, parentStyle, textNode);
                child.setTextDirection(c.getDefaultTextDirection());
                previousIB = BoxBuilder.setupInlineChild(child, previousIB);
                children.add(child);
                startIndex += newLength;
                nodeIndex += newLength;
            } while (nodeIndex < textNode.getLength());
        }
        return previousIB;
    }

    private static void insertAnonymousBlocks(SharedContext c, Box parent, List<Styleable> children, boolean layoutRunningBlocks) {
        ArrayList<Styleable> inline = new ArrayList<Styleable>();
        ArrayDeque<InlineBox> parents = new ArrayDeque<InlineBox>();
        ArrayList savedParents = null;
        for (Styleable child : children) {
            if (!(!child.getStyle().isLayedOutInInlineContext() || layoutRunningBlocks && child.getStyle().isRunning() || child.getStyle().isTableCell())) {
                inline.add(child);
                if (!child.getStyle().isInline()) continue;
                InlineBox iB = (InlineBox)child;
                if (iB.isStartsHere()) {
                    parents.add(iB);
                }
                if (!iB.isEndsHere()) continue;
                parents.removeLast();
                continue;
            }
            if (inline.size() > 0) {
                BoxBuilder.createAnonymousBlock(c, parent, inline, savedParents);
                inline = new ArrayList();
                savedParents = new ArrayList(parents);
            }
            parent.addChild((Box)child);
        }
        BoxBuilder.createAnonymousBlock(c, parent, inline, savedParents);
    }

    private static void createAnonymousBlock(SharedContext c, Box parent, List<Styleable> inline, List<InlineBox> savedParents) {
        BoxBuilder.createAnonymousBlock(c, parent, inline, savedParents, IdentValue.BLOCK);
    }

    private static void createAnonymousBlock(SharedContext c, Box parent, List<Styleable> inline, List<InlineBox> savedParents, IdentValue display) {
        WhitespaceStripper.stripInlineContent(inline);
        if (inline.size() > 0) {
            AnonymousBlockBox anon = new AnonymousBlockBox(parent.getElement());
            anon.setStyle(parent.getStyle().createAnonymousStyle(display));
            anon.setAnonymous(true);
            if (savedParents != null && savedParents.size() > 0) {
                anon.setOpenInlineBoxes(savedParents);
            }
            parent.addChild(anon);
            anon.setChildrenContentType(BlockBox.ContentType.INLINE);
            anon.setInlineContent(inline);
        }
    }

    private static class ChildBoxInfo {
        private boolean _containsBlockLevelContent;
        private boolean _containsTableContent;
        private boolean _layoutRunningBlocks;

        public boolean isContainsBlockLevelContent() {
            return this._containsBlockLevelContent;
        }

        public void setContainsBlockLevelContent(boolean containsBlockLevelContent) {
            this._containsBlockLevelContent = containsBlockLevelContent;
        }

        public boolean isContainsTableContent() {
            return this._containsTableContent;
        }

        public void setContainsTableContent(boolean containsTableContent) {
            this._containsTableContent = containsTableContent;
        }

        public boolean isLayoutRunningBlocks() {
            return this._layoutRunningBlocks;
        }

        public void setLayoutRunningBlocks(boolean layoutRunningBlocks) {
            this._layoutRunningBlocks = layoutRunningBlocks;
        }

        public String toString() {
            return String.format("ChildBoxInfo [_containsBlockLevelContent=%s, _containsTableContent=%s, _layoutRunningBlocks=%s]", this._containsBlockLevelContent, this._containsTableContent, this._layoutRunningBlocks);
        }
    }

    private static class CreateChildrenContext {
        boolean needStartText;
        boolean needEndText;
        boolean inline;
        InlineBox previousIB = null;
        final CalculatedStyle parentStyle;

        CreateChildrenContext(boolean needStartText, boolean needEndText, CalculatedStyle parentStyle, boolean inline) {
            this.needStartText = needStartText;
            this.needEndText = needEndText;
            this.parentStyle = parentStyle;
            this.inline = inline;
        }
    }
}

