/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.gradient.ui;

import com.michaelbaranov.microba.common.BoundedTableModel;
import com.michaelbaranov.microba.gradient.GradientBar;
import com.michaelbaranov.microba.gradient.ui.basic.BasicGradientUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class GradientListener
implements TableModelListener,
PropertyChangeListener {
    private final BasicGradientUI gradientUI;
    private GradientBar gradient;

    public GradientListener(BasicGradientUI gradientUI, GradientBar gradient) {
        this.gradientUI = gradientUI;
        this.gradient = gradient;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("dataModel".equals(evt.getPropertyName())) {
            BoundedTableModel oldModel = (BoundedTableModel)evt.getOldValue();
            BoundedTableModel newModel = (BoundedTableModel)evt.getNewValue();
            if (oldModel != null) {
                oldModel.removeTableModelListener(this);
            }
            if (newModel != null) {
                newModel.addTableModelListener(this);
            }
            this.gradient.revalidate();
        }
        if ("orientation".equals(evt.getPropertyName())) {
            this.gradient.revalidate();
        }
        if ("colorPositionColumn".equals(evt.getPropertyName())) {
            this.gradient.repaint();
        }
        if ("colorColumn".equals(evt.getPropertyName())) {
            this.gradient.repaint();
        }
        if ("enabled".equals(evt.getPropertyName())) {
            this.gradient.repaint();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.gradient.repaint();
    }
}

