/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.references;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.tree.injected.InjectedReferenceVisitor;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedReferencesContributor
extends PsiReferenceContributor {
    public static boolean isInjected(@Nullable PsiReference reference) {
        if (reference == null) {
            return false;
        }
        return InjectedReferencesContributor.getInjectedReferences(reference.getElement()) != null;
    }

    public static PsiReference @Nullable [] getInjectedReferences(PsiElement element) {
        if (!(element instanceof ContributedReferenceHost) && !(element instanceof PsiLanguageInjectionHost)) {
            return null;
        }
        Pair<PsiReference[], Boolean> info = InjectedReferencesContributor.getInjectionInfo(element);
        if (!((Boolean)info.second).booleanValue()) {
            return null;
        }
        return (PsiReference[])info.first;
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            InjectedReferencesContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiReference[] psiReferenceArray = (PsiReference[])InjectedReferencesContributor.getInjectionInfo((PsiElement)element).first;
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            public boolean acceptsHints(@NotNull PsiElement element, // Could not load outer class - annotation placement on inner may be incorrect
             @NotNull PsiReferenceService.Hints hints) {
                if (element == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (hints == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (hints == PsiReferenceService.Hints.HIGHLIGHTED_REFERENCES) {
                    return false;
                }
                return super.acceptsHints(element, hints);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/plugins/intelliLang/references/InjectedReferencesContributor$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "hints";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/plugins/intelliLang/references/InjectedReferencesContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "acceptsHints";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static Pair<PsiReference[], Boolean> getInjectionInfo(@NotNull PsiElement element) {
        if (element == null) {
            InjectedReferencesContributor.$$$reportNull$$$0(1);
        }
        return (Pair)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create(InjectedReferencesContributor.doGetReferencesByElement(element, new ProcessingContext()), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static Pair<PsiReference[], Boolean> doGetReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            InjectedReferencesContributor.$$$reportNull$$$0(2);
        }
        if (context == null) {
            InjectedReferencesContributor.$$$reportNull$$$0(3);
        }
        SmartList references = new SmartList();
        Project project = element.getProject();
        Configuration configuration = Configuration.getProjectInstance(project);
        final Ref injected = new Ref((Object)Boolean.FALSE);
        for (ReferenceInjector injector : ReferenceInjector.EXTENSION_POINT_NAME.getExtensionList()) {
            Collection<BaseInjection> injections = configuration.getInjectionsByLanguageId(injector.getId());
            for (BaseInjection injection : injections) {
                if (!injection.acceptForReference(element)) continue;
                injected.set((Object)Boolean.TRUE);
                LanguageInjectionSupport support = InjectorUtils.findInjectionSupport(injection.getSupportId());
                element.putUserData(LanguageInjectionSupport.INJECTOR_SUPPORT, (Object)support);
                List<TextRange> area = injection.getInjectedArea(element);
                for (TextRange range : area) {
                    references.addAll(Arrays.asList(injector.getReferences(element, context, range)));
                }
            }
        }
        if (element instanceof PsiLanguageInjectionHost) {
            final TemporaryPlacesRegistry registry = TemporaryPlacesRegistry.getInstance(project);
            InjectedLanguage language = registry.getLanguageFor((PsiLanguageInjectionHost)element, element.getContainingFile());
            if (language != null) {
                ReferenceInjector injector = ReferenceInjector.findById((String)language.getID());
                if (injector != null) {
                    injected.set((Object)Boolean.TRUE);
                    element.putUserData(LanguageInjectionSupport.INJECTOR_SUPPORT, (Object)registry.getLanguageInjectionSupport());
                    TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
                    references.addAll(Arrays.asList(injector.getReferences(element, context, range)));
                }
            } else {
                PsiFile containingFile = element.getContainingFile();
                InjectedLanguageManager.getInstance((Project)containingFile.getProject()).enumerateEx(element, containingFile, false, (PsiLanguageInjectionHost.InjectedPsiVisitor)new InjectedReferenceVisitor((List)references, context){
                    final /* synthetic */ List val$references;
                    final /* synthetic */ ProcessingContext val$context;
                    {
                        this.val$references = list;
                        this.val$context = processingContext;
                    }

                    public void visitInjectedReference(@NotNull ReferenceInjector injector, @NotNull List<? extends PsiLanguageInjectionHost.Shred> places) {
                        if (injector == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (places == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        injected.set((Object)Boolean.TRUE);
                        element.putUserData(LanguageInjectionSupport.INJECTOR_SUPPORT, (Object)registry.getLanguageInjectionSupport());
                        for (PsiLanguageInjectionHost.Shred shred : places) {
                            if (shred.getHost() != element) continue;
                            this.val$references.addAll(Arrays.asList(injector.getReferences(element, this.val$context, shred.getRangeInsideHost())));
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "injector";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "places";
                                break;
                            }
                        }
                        objectArray[1] = "org/intellij/plugins/intelliLang/references/InjectedReferencesContributor$2";
                        objectArray[2] = "visitInjectedReference";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
        return Pair.create((Object)references.toArray(PsiReference.EMPTY_ARRAY), (Object)((Boolean)injected.get()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/intelliLang/references/InjectedReferencesContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInjectionInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetReferencesByElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

