/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.BuildMetaInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.incremental.storage.RelativeFileToPathConverter;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/build/CommonBuildMetaInfo;", "Lorg/jetbrains/kotlin/build/BuildMetaInfo;", "converter", "Lorg/jetbrains/kotlin/incremental/storage/RelativeFileToPathConverter;", "(Lorg/jetbrains/kotlin/incremental/storage/RelativeFileToPathConverter;)V", "checkIfPlatformSpecificCompilerArgumentWasChanged", "", "key", "", "currentValue", "previousValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "createPropertiesMapFromCompilerArguments", "", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nCommonBuildMetaInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonBuildMetaInfo.kt\norg/jetbrains/kotlin/build/CommonBuildMetaInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class CommonBuildMetaInfo
extends BuildMetaInfo {
    public CommonBuildMetaInfo(@Nullable RelativeFileToPathConverter converter) {
        super(converter);
    }

    @Override
    @Nullable
    public Boolean checkIfPlatformSpecificCompilerArgumentWasChanged(@NotNull String key, @NotNull String currentValue, @NotNull String previousValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
        Intrinsics.checkNotNullParameter((Object)previousValue, (String)"previousValue");
        if (Intrinsics.areEqual((Object)key, (Object)"METADATA_VERSION_STRING")) {
            int[] previousVersionIntArray;
            int[] currentVersionIntArray;
            if (!(currentVersionIntArray != null ? (currentVersionIntArray = BinaryVersion.Companion.parseVersionArray(currentValue)).length == 3 : false)) {
                return null;
            }
            int[] nArray = new int[]{currentVersionIntArray[0], currentVersionIntArray[1], currentVersionIntArray[2]};
            JvmMetadataVersion currentVersion = new JvmMetadataVersion(nArray);
            if (!(previousVersionIntArray != null ? (previousVersionIntArray = BinaryVersion.Companion.parseVersionArray(previousValue)).length == 3 : false)) {
                return null;
            }
            int[] nArray2 = new int[]{previousVersionIntArray[0], previousVersionIntArray[1], previousVersionIntArray[2]};
            JvmMetadataVersion previousVersion = new JvmMetadataVersion(nArray2);
            return Intrinsics.areEqual((Object)currentVersion, (Object)previousVersion);
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, String> createPropertiesMapFromCompilerArguments(@NotNull CommonCompilerArguments args) {
        JvmMetadataVersion jvmMetadataVersion;
        int[] metadataVersionArray;
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Map resultMap = new LinkedHashMap();
        String string = args.getMetadataVersion();
        if (string != null) {
            String it = string;
            boolean bl = false;
            nArray = BinaryVersion.Companion.parseVersionArray(it);
        } else {
            nArray = null;
        }
        if (metadataVersionArray != null) {
            int[] p0 = metadataVersionArray = nArray;
            boolean bl = false;
            jvmMetadataVersion = new JvmMetadataVersion(p0);
        } else {
            jvmMetadataVersion = JvmMetadataVersion.INSTANCE;
        }
        JvmMetadataVersion metadataVersion2 = jvmMetadataVersion;
        String metadataVersionString = metadataVersion2.toString();
        resultMap.put("METADATA_VERSION_STRING", metadataVersionString);
        return MapsKt.plus(super.createPropertiesMapFromCompilerArguments(args), (Map)resultMap);
    }
}

