/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.project.structure.KtCodeFragmentModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0016\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/impl/KtCodeFragmentModuleImpl;", "Lorg/jetbrains/kotlin/analysis/project/structure/KtCodeFragmentModule;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "contextModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "getContextModule", "()Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "directDependsOnDependencies", "", "getDirectDependsOnDependencies", "()Ljava/util/List;", "directFriendDependencies", "getDirectFriendDependencies", "directRegularDependencies", "getDirectRegularDependencies", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "transitiveDependsOnDependencies", "getTransitiveDependsOnDependencies", "equals", "", "other", "", "hashCode", "", "project-structure"})
public final class KtCodeFragmentModuleImpl
implements KtCodeFragmentModule {
    @NotNull
    private final KtCodeFragment codeFragment;
    @NotNull
    private final KtModule contextModule;

    public KtCodeFragmentModuleImpl(@NotNull KtCodeFragment codeFragment, @NotNull KtModule contextModule) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)contextModule, (String)"contextModule");
        this.codeFragment = codeFragment;
        this.contextModule = contextModule;
    }

    @Override
    @NotNull
    public KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @Override
    @NotNull
    public KtModule getContextModule() {
        return this.contextModule;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.getContextModule().getProject();
    }

    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return this.getContextModule().getPlatform();
    }

    @Override
    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return this.getContextModule().getAnalyzerServices();
    }

    @Override
    @NotNull
    public GlobalSearchScope getContentScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)((PsiFile)this.getCodeFragment()));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(...)");
        return globalSearchScope;
    }

    @Override
    @NotNull
    public List<KtModule> getDirectRegularDependencies() {
        return this.getContextModule().getDirectRegularDependencies();
    }

    @Override
    @NotNull
    public List<KtModule> getDirectDependsOnDependencies() {
        return this.getContextModule().getDirectDependsOnDependencies();
    }

    @Override
    @NotNull
    public List<KtModule> getDirectFriendDependencies() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.getContextModule()), (Iterable)this.getContextModule().getDirectFriendDependencies());
    }

    @Override
    @NotNull
    public List<KtModule> getTransitiveDependsOnDependencies() {
        return this.getContextModule().getTransitiveDependsOnDependencies();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof KtCodeFragmentModuleImpl) {
            return Intrinsics.areEqual((Object)this.getCodeFragment(), (Object)((KtCodeFragmentModuleImpl)other).getCodeFragment()) && Intrinsics.areEqual((Object)this.getContextModule(), (Object)((KtCodeFragmentModuleImpl)other).getContextModule());
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getCodeFragment(), this.getContextModule()};
        return Objects.hash(objectArray);
    }
}

