/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.deserialization;

import java.util.LinkedList;
import java.util.List;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import org.jetbrains.annotations.NotNull;

public final class NameResolverImpl
implements NameResolver {
    @NotNull
    private final ProtoBuf.StringTable strings;
    @NotNull
    private final ProtoBuf.QualifiedNameTable qualifiedNames;

    public NameResolverImpl(@NotNull ProtoBuf.StringTable strings2, @NotNull ProtoBuf.QualifiedNameTable qualifiedNames) {
        Intrinsics.checkNotNullParameter((Object)strings2, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)qualifiedNames, (String)"qualifiedNames");
        this.strings = strings2;
        this.qualifiedNames = qualifiedNames;
    }

    @Override
    @NotNull
    public String getString(int index) {
        String string2 = this.strings.getString(index);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"strings.getString(index)");
        return string2;
    }

    @Override
    @NotNull
    public String getQualifiedClassName(int index) {
        Triple<List<String>, List<String>, Boolean> triple = this.traverseIds(index);
        List packageFqNameSegments = (List)triple.component1();
        List relativeClassNameSegments = (List)triple.component2();
        String className2 = CollectionsKt.joinToString$default((Iterable)relativeClassNameSegments, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        return packageFqNameSegments.isEmpty() ? className2 : CollectionsKt.joinToString$default((Iterable)packageFqNameSegments, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null) + '/' + className2;
    }

    @Override
    public boolean isLocalClassName(int index) {
        return (Boolean)this.traverseIds(index).getThird();
    }

    private final Triple<List<String>, List<String>, Boolean> traverseIds(int startingIndex) {
        int index = startingIndex;
        LinkedList<String> packageNameSegments = new LinkedList<String>();
        LinkedList<String> relativeClassNameSegments = new LinkedList<String>();
        boolean local = false;
        while (index != -1) {
            ProtoBuf.QualifiedNameTable.QualifiedName.Kind kind;
            ProtoBuf.QualifiedNameTable.QualifiedName proto = this.qualifiedNames.getQualifiedName(index);
            String shortName = this.strings.getString(proto.getShortName());
            Intrinsics.checkNotNull((Object)proto.getKind());
            int n = WhenMappings.$EnumSwitchMapping$0[kind.ordinal()];
            switch (n) {
                case 1: {
                    relativeClassNameSegments.addFirst(shortName);
                    break;
                }
                case 2: {
                    packageNameSegments.addFirst(shortName);
                    break;
                }
                case 3: {
                    relativeClassNameSegments.addFirst(shortName);
                    local = true;
                }
            }
            index = proto.getParentQualifiedName();
        }
        return new Triple(packageNameSegments, relativeClassNameSegments, (Object)local);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.values().length];
            nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS.ordinal()] = 1;
            nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.PACKAGE.ordinal()] = 2;
            nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.LOCAL.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

