/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.DummyJavaFileObject;
import org.jetbrains.jps.javac.JavacRemoteProto;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.javac.PlainMessageDiagnostic;

public final class ExternalJavacMessageHandler {
    private final DiagnosticOutputConsumer myDiagnosticSink;
    private final OutputFileConsumer myOutputSink;
    @Nullable
    private final String myEncodingName;
    private volatile boolean myTerminatedSuccessfully;
    private final WslSupport myWslSupport;

    public ExternalJavacMessageHandler(DiagnosticOutputConsumer diagnosticSink, OutputFileConsumer outputSink, @Nullable String encodingName, @NotNull WslSupport wslSupport) {
        if (wslSupport == null) {
            ExternalJavacMessageHandler.$$$reportNull$$$0(0);
        }
        this.myDiagnosticSink = diagnosticSink;
        this.myOutputSink = outputSink;
        this.myEncodingName = encodingName;
        this.myWslSupport = wslSupport;
    }

    public DiagnosticOutputConsumer getDiagnosticSink() {
        return this.myDiagnosticSink;
    }

    public boolean handleMessage(MessageLite message) {
        try {
            JavacRemoteProto.Message msg = (JavacRemoteProto.Message)message;
            JavacRemoteProto.Message.Type messageType = msg.getMessageType();
            if (messageType == JavacRemoteProto.Message.Type.RESPONSE) {
                JavacRemoteProto.Message.Response response = msg.getResponse();
                JavacRemoteProto.Message.Response.Type responseType = response.getResponseType();
                if (responseType == JavacRemoteProto.Message.Response.Type.BUILD_MESSAGE) {
                    JavacRemoteProto.Message.Response.CompileMessage compileMessage = response.getCompileMessage();
                    JavacRemoteProto.Message.Response.CompileMessage.Kind messageKind = compileMessage.getKind();
                    if (messageKind == JavacRemoteProto.Message.Response.CompileMessage.Kind.STD_OUT) {
                        if (compileMessage.hasText()) {
                            this.myDiagnosticSink.outputLineAvailable(compileMessage.getText());
                        }
                    } else {
                        String sourceUri = compileMessage.hasSourceUri() ? compileMessage.getSourceUri() : null;
                        DummyJavaFileObject srcFileObject = sourceUri != null ? new DummyJavaFileObject(URI.create(sourceUri)) : null;
                        this.myDiagnosticSink.report(new DummyDiagnostic(ExternalJavacMessageHandler.convertKind(messageKind), srcFileObject, compileMessage));
                    }
                    return false;
                }
                if (responseType == JavacRemoteProto.Message.Response.Type.OUTPUT_OBJECT) {
                    BinaryContent fileObjectContent;
                    ByteString content;
                    JavacRemoteProto.Message.Response.OutputObject outputObject = response.getOutputObject();
                    JavacRemoteProto.Message.Response.OutputObject.Kind kind = outputObject.getKind();
                    String outputRoot = outputObject.hasOutputRoot() ? outputObject.getOutputRoot() : null;
                    File outputRootFile = outputRoot != null ? new File(this.myWslSupport.convertPath(outputRoot)) : null;
                    ByteString byteString = content = outputObject.hasContent() ? outputObject.getContent() : null;
                    if (content != null) {
                        byte[] bytes = content.toByteArray();
                        fileObjectContent = new BinaryContent(bytes, 0, bytes.length);
                    } else {
                        fileObjectContent = null;
                    }
                    JavaFileManager.Location location = outputObject.hasLocation() ? StandardLocation.locationFor(outputObject.getLocation()) : null;
                    ArrayList<URI> sources = new ArrayList<URI>();
                    for (String uri : outputObject.getSourceUriList()) {
                        sources.add(URI.create(uri));
                    }
                    OutputFileObject fileObject = new OutputFileObject(null, outputRootFile, outputObject.hasRelativePath() ? outputObject.getRelativePath() : null, new File(this.myWslSupport.convertPath(outputObject.getFilePath())), ExternalJavacMessageHandler.convertKind(kind), outputObject.hasClassName() ? outputObject.getClassName() : null, sources, this.myEncodingName, fileObjectContent, location, outputObject.getIsGenerated());
                    this.myOutputSink.save(fileObject);
                    return false;
                }
                if (responseType == JavacRemoteProto.Message.Response.Type.SRC_FILE_LOADED) {
                    JavacRemoteProto.Message.Response.OutputObject outputObject = response.getOutputObject();
                    File file = new File(this.myWslSupport.convertPath(outputObject.getFilePath()));
                    this.myDiagnosticSink.javaFileLoaded(file);
                    return false;
                }
                if (responseType == JavacRemoteProto.Message.Response.Type.CUSTOM_OUTPUT_OBJECT) {
                    JavacRemoteProto.Message.Response.OutputObject outputObject = response.getOutputObject();
                    String pluginId = outputObject.getFilePath();
                    String name = outputObject.getClassName();
                    byte[] content = outputObject.hasContent() ? outputObject.getContent().toByteArray() : new byte[]{};
                    this.myDiagnosticSink.customOutputData(pluginId, name, content);
                    return false;
                }
                if (responseType == JavacRemoteProto.Message.Response.Type.BUILD_COMPLETED) {
                    if (response.hasCompletionStatus()) {
                        this.myTerminatedSuccessfully = response.getCompletionStatus();
                    }
                    return true;
                }
                throw new Exception("Unsupported response type: " + responseType.name());
            }
            if (messageType == JavacRemoteProto.Message.Type.FAILURE) {
                JavacRemoteProto.Message.Failure failure = msg.getFailure();
                StringBuilder buf = new StringBuilder();
                if (failure.hasDescription()) {
                    buf.append(failure.getDescription());
                }
                if (failure.hasStacktrace()) {
                    if (buf.length() > 0) {
                        buf.append("\n");
                    }
                    buf.append(failure.getStacktrace());
                }
                this.myDiagnosticSink.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, buf.toString()));
                return true;
            }
            throw new Exception("Unsupported message type: " + messageType.name());
        }
        catch (Throwable e) {
            this.myDiagnosticSink.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, e.getMessage()));
            return true;
        }
    }

    public boolean isTerminatedSuccessfully() {
        return this.myTerminatedSuccessfully;
    }

    private static Diagnostic.Kind convertKind(JavacRemoteProto.Message.Response.CompileMessage.Kind kind) {
        switch (kind) {
            case ERROR: {
                return Diagnostic.Kind.ERROR;
            }
            case WARNING: {
                return Diagnostic.Kind.WARNING;
            }
            case MANDATORY_WARNING: {
                return Diagnostic.Kind.MANDATORY_WARNING;
            }
            case NOTE: {
                return Diagnostic.Kind.NOTE;
            }
        }
        return Diagnostic.Kind.OTHER;
    }

    private static JavaFileObject.Kind convertKind(JavacRemoteProto.Message.Response.OutputObject.Kind kind) {
        switch (kind) {
            case CLASS: {
                return JavaFileObject.Kind.CLASS;
            }
            case HTML: {
                return JavaFileObject.Kind.HTML;
            }
            case SOURCE: {
                return JavaFileObject.Kind.SOURCE;
            }
        }
        return JavaFileObject.Kind.OTHER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wslSupport", "org/jetbrains/jps/javac/ExternalJavacMessageHandler", "<init>"));
    }

    public static interface WslSupport {
        public static final WslSupport DIRECT = new WslSupport(){

            @Override
            public String convertPath(String path) {
                return path != null ? path.replace('\\', '/') : null;
            }
        };

        public String convertPath(String var1);
    }

    private static class DummyDiagnostic
    implements Diagnostic<JavaFileObject> {
        private final Diagnostic.Kind myMessageKind;
        private final JavaFileObject mySrcFileObject;
        private final JavacRemoteProto.Message.Response.CompileMessage myCompileMessage;

        DummyDiagnostic(Diagnostic.Kind messageKind, JavaFileObject srcFileObject, JavacRemoteProto.Message.Response.CompileMessage compileMessage) {
            this.myMessageKind = messageKind;
            this.mySrcFileObject = srcFileObject;
            this.myCompileMessage = compileMessage;
        }

        @Override
        public Diagnostic.Kind getKind() {
            return this.myMessageKind;
        }

        @Override
        public JavaFileObject getSource() {
            return this.mySrcFileObject;
        }

        @Override
        public long getPosition() {
            return this.myCompileMessage.hasProblemLocationOffset() ? this.myCompileMessage.getProblemLocationOffset() : -1L;
        }

        @Override
        public long getStartPosition() {
            return this.myCompileMessage.hasProblemBeginOffset() ? this.myCompileMessage.getProblemBeginOffset() : -1L;
        }

        @Override
        public long getEndPosition() {
            return this.myCompileMessage.hasProblemEndOffset() ? this.myCompileMessage.getProblemEndOffset() : -1L;
        }

        @Override
        public long getLineNumber() {
            return this.myCompileMessage.hasLine() ? this.myCompileMessage.getLine() : -1L;
        }

        @Override
        public long getColumnNumber() {
            return this.myCompileMessage.hasColumn() ? this.myCompileMessage.getColumn() : -1L;
        }

        @Override
        public String getCode() {
            return null;
        }

        @Override
        public String getMessage(Locale locale) {
            return this.myCompileMessage.hasText() ? this.myCompileMessage.getText() : null;
        }
    }
}

