/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.LimitedPool;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.ClosedStorageException;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentMapBase;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.PersistentMapWal;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.stats.PersistentHashMapStatistics;
import com.intellij.util.io.stats.StorageStatsRegistrar;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class PersistentMapImpl<Key, Value>
implements PersistentMapBase<Key, Value> {
    private static final Logger LOG = Logger.getInstance(PersistentMapImpl.class);
    private static final boolean myDoTrace = SystemProperties.getBooleanProperty("idea.trace.persistent.map", false);
    private static final boolean doHardConsistencyChecks = false;
    private static final long DEAD_KEY_NUMBER_MASK = 0xFFFFFFFFL;
    private static final long LIVE_KEY_MASK = 0x100000000L;
    private static final long USED_LONG_VALUE_MASK = 0x4000000000000000L;
    private static final int POSITIVE_VALUE_SHIFT = 1;
    private static final long NULL_ADDR = 0L;
    private static final int DEFAULT_INDEX_INITIAL_SIZE = SystemProperties.getIntProperty("idea.initialIndexSize", 4096);
    private static final int MAX_RECYCLED_BUFFER_SIZE = 4096;
    @NonNls
    static final String DATA_FILE_EXTENSION = ".values";
    @NotNull
    private final PersistentMapBuilder<Key, Value> myBuilder;
    @NotNull
    private final PersistentHashMapValueStorage.CreationTimeOptions myOptions;
    private final Path myStorageFile;
    private final boolean myIsReadOnly;
    private final KeyDescriptor<Key> myKeyDescriptor;
    private PersistentHashMapValueStorage myValueStorage;
    private final SLRUCache<Key, BufferExposingByteArrayOutputStream> myAppendCache;
    private final LowMemoryWatcher myAppendCacheFlusher;
    private final DataExternalizer<Value> myValueExternalizer;
    private long myLiveAndGarbageKeysCounter;
    private int myReadCompactionGarbageSize;
    private final int myParentValueRefOffset;
    private final boolean myIntMapping;
    private final boolean myDirectlyStoreLongFileOffsetMode;
    private final boolean myCanReEnumerate;
    private int myLargeIndexWatermarkId;
    private boolean myIntAddressForNewRecord;
    private final PersistentEnumeratorBase<Key> myEnumerator;
    private final boolean myCompactOnClose;
    private final ReentrantReadWriteLock myLock;
    private final PersistentMapWal<Key, Value> myWal;
    private final LimitedPool<BufferExposingByteArrayOutputStream> myStreamPool;
    private static final ThreadLocalCachedValue<AppendStream> ourFlyweightAppenderStream = new ThreadLocalCachedValue<AppendStream>(){

        @Override
        @NotNull
        protected AppendStream create() {
            return new AppendStream();
        }
    };
    private int smallKeys;
    private int largeKeys;
    private int transformedKeys;
    private int requests;

    @TestOnly
    public boolean isCorrupted() {
        return this.myEnumerator.isCorrupted();
    }

    private boolean canUseIntAddressForNewRecord(long size) {
        return this.myCanReEnumerate && size + 1L < Integer.MAX_VALUE;
    }

    public PersistentMapImpl(@NotNull PersistentMapBuilder<Key, Value> builder) throws IOException {
        if (builder == null) {
            PersistentMapImpl.$$$reportNull$$$0(0);
        }
        this(builder, PersistentHashMapValueStorage.CreationTimeOptions.threadLocalOptions());
    }

    public PersistentMapImpl(@NotNull PersistentMapBuilder<Key, Value> builder, @NotNull PersistentHashMapValueStorage.CreationTimeOptions options) throws IOException {
        if (builder == null) {
            PersistentMapImpl.$$$reportNull$$$0(1);
        }
        if (options == null) {
            PersistentMapImpl.$$$reportNull$$$0(2);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myStreamPool = new LimitedPool<BufferExposingByteArrayOutputStream>(10, new LimitedPool.ObjectFactory<BufferExposingByteArrayOutputStream>(){

            @Override
            @NotNull
            public BufferExposingByteArrayOutputStream create() {
                return new BufferExposingByteArrayOutputStream();
            }

            @Override
            public void cleanup(@NotNull BufferExposingByteArrayOutputStream appendStream) {
                if (appendStream == null) {
                    1.$$$reportNull$$$0(0);
                }
                appendStream.reset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appendStream", "com/intellij/util/io/PersistentMapImpl$1", "cleanup"));
            }
        });
        this.myBuilder = builder.copy();
        Path file2 = this.myBuilder.getFile();
        KeyDescriptor<Key> keyDescriptor = this.myBuilder.getKeyDescriptor();
        DataExternalizer<Value> valueExternalizer = this.myBuilder.getValueExternalizer();
        int initialSize = this.myBuilder.getInitialSize(DEFAULT_INDEX_INITIAL_SIZE);
        int version = this.myBuilder.getVersion(0);
        @Nullable StorageLockContext lockContext = this.myBuilder.getLockContext();
        this.myCompactOnClose = this.myBuilder.getCompactOnClose(false);
        this.myIsReadOnly = this.myBuilder.getReadOnly(false);
        if (this.myIsReadOnly) {
            options = options.setReadOnly();
        }
        this.myOptions = options;
        this.myEnumerator = PersistentEnumerator.createDefaultEnumerator(PersistentMapImpl.checkDataFiles(file2), keyDescriptor, initialSize, lockContext, PersistentMapImpl.modifyVersionDependingOnOptions(version, options), false);
        this.myStorageFile = file2;
        this.myKeyDescriptor = keyDescriptor;
        Path walFile = this.myStorageFile.resolveSibling(this.myStorageFile.getFileName().toString() + ".wal");
        this.myWal = this.myBuilder.isEnableWal() ? new PersistentMapWal<Key, Value>(keyDescriptor, valueExternalizer, options.useCompression(), walFile, this.myBuilder.getWalExecutor(), true) : null;
        @NotNull PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase<?>> recordHandler = this.myEnumerator.getRecordHandler();
        this.myParentValueRefOffset = recordHandler.getRecordBuffer(this.myEnumerator).length;
        boolean inlineValues = this.myBuilder.getInlineValues(false);
        this.myIntMapping = valueExternalizer instanceof IntInlineKeyDescriptor && inlineValues;
        this.myDirectlyStoreLongFileOffsetMode = keyDescriptor instanceof InlineKeyDescriptor && this.myEnumerator instanceof PersistentBTreeEnumerator;
        this.myEnumerator.setRecordHandler(new MyEnumeratorRecordHandler(recordHandler));
        this.myEnumerator.setMarkCleanCallback(() -> {
            this.myEnumerator.putMetaData(this.myLiveAndGarbageKeysCounter);
            this.myEnumerator.putMetaData2((long)this.myLargeIndexWatermarkId | (long)this.myReadCompactionGarbageSize << 32);
        });
        if (myDoTrace) {
            LOG.info("Opened " + this.myStorageFile);
        }
        StorageStatsRegistrar.INSTANCE.registerMap(this.myStorageFile, this);
        try {
            this.myValueExternalizer = valueExternalizer;
            this.myValueStorage = this.myIntMapping ? null : new PersistentHashMapValueStorage(PersistentMapImpl.getDataFile(this.myStorageFile), options);
            this.myAppendCache = this.myIntMapping ? null : this.createAppendCache(keyDescriptor);
            this.myAppendCacheFlusher = this.myIntMapping ? null : LowMemoryWatcher.register(() -> {
                try {
                    this.force();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            });
            this.myLiveAndGarbageKeysCounter = this.myEnumerator.getMetaData();
            long data2 = this.myEnumerator.getMetaData2();
            this.myLargeIndexWatermarkId = (int)(data2 & 0xFFFFFFFFL);
            this.myReadCompactionGarbageSize = (int)(data2 >>> 32);
            this.myCanReEnumerate = this.myEnumerator.canReEnumerate();
            if (!options.isReadOnly() && this.makesSenseToCompact()) {
                this.compact();
            }
        }
        catch (IOException e) {
            try {
                this.close(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        catch (Throwable t) {
            LOG.error(t);
            try {
                this.close(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new CorruptedException(this.myStorageFile);
        }
    }

    public PersistentMapImpl<Key, Value> deriveEmptyMap(@NotNull Path path) throws IOException {
        if (path == null) {
            PersistentMapImpl.$$$reportNull$$$0(3);
        }
        return (PersistentMapImpl)this.myOptions.with(() -> new PersistentMapImpl<Key, Value>(this.myBuilder.copyWithFile(path)));
    }

    @Override
    @NotNull
    public DataExternalizer<Value> getValuesExternalizer() {
        DataExternalizer<Value> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            PersistentMapImpl.$$$reportNull$$$0(4);
        }
        return dataExternalizer;
    }

    @NotNull
    public KeyDescriptor<Key> getKeyDescriptor() {
        KeyDescriptor<Key> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            PersistentMapImpl.$$$reportNull$$$0(5);
        }
        return keyDescriptor;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> builder() {
        PersistentMapBuilder<Key, Value> persistentMapBuilder = this.myBuilder.copy();
        if (persistentMapBuilder == null) {
            PersistentMapImpl.$$$reportNull$$$0(6);
        }
        return persistentMapBuilder;
    }

    private static int modifyVersionDependingOnOptions(int version, @NotNull PersistentHashMapValueStorage.CreationTimeOptions options) {
        if (options == null) {
            PersistentMapImpl.$$$reportNull$$$0(7);
        }
        return version + options.getVersion();
    }

    private SLRUCache<Key, BufferExposingByteArrayOutputStream> createAppendCache(@NotNull KeyDescriptor<Key> keyDescriptor) {
        if (keyDescriptor == null) {
            PersistentMapImpl.$$$reportNull$$$0(8);
        }
        return new SLRUCache<Key, BufferExposingByteArrayOutputStream>(16384, 4096, keyDescriptor){

            @Override
            @NotNull
            public BufferExposingByteArrayOutputStream createValue(Key key) {
                BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = (BufferExposingByteArrayOutputStream)PersistentMapImpl.this.myStreamPool.alloc();
                if (bufferExposingByteArrayOutputStream == null) {
                    2.$$$reportNull$$$0(0);
                }
                return bufferExposingByteArrayOutputStream;
            }

            @Override
            protected void onDropFromCache(Key key, @NotNull BufferExposingByteArrayOutputStream bytes) {
                if (bytes == null) {
                    2.$$$reportNull$$$0(1);
                }
                PersistentMapImpl.this.myEnumerator.lockStorageWrite();
                try {
                    int id;
                    long previousRecord;
                    if (PersistentMapImpl.this.myDirectlyStoreLongFileOffsetMode) {
                        previousRecord = ((PersistentBTreeEnumerator)PersistentMapImpl.this.myEnumerator).getNonNegativeValue(key);
                        id = -1;
                    } else {
                        id = PersistentMapImpl.this.enumerate(key);
                        previousRecord = PersistentMapImpl.this.readValueId(id);
                    }
                    long headerRecord = PersistentMapImpl.this.myValueStorage.appendBytes(bytes.toByteArraySequence(), previousRecord);
                    if (PersistentMapImpl.this.myDirectlyStoreLongFileOffsetMode) {
                        ((PersistentBTreeEnumerator)PersistentMapImpl.this.myEnumerator).putNonNegativeValue(key, headerRecord);
                    } else {
                        PersistentMapImpl.this.updateValueId(id, headerRecord, previousRecord, key, 0);
                    }
                    if (previousRecord == 0L) {
                        PersistentMapImpl.this.myLiveAndGarbageKeysCounter += 0x100000000L;
                    }
                    if (bytes.getInternalBuffer().length <= 4096) {
                        PersistentMapImpl.this.myStreamPool.recycle(bytes);
                    }
                }
                catch (ClosedStorageException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IOException e) {
                    PersistentMapImpl.this.markCorrupted();
                    throw new RuntimeException(e);
                }
                finally {
                    PersistentMapImpl.this.myEnumerator.unlockStorageWrite();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/io/PersistentMapImpl$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "bytes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/io/PersistentMapImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "onDropFromCache";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    private Lock getWriteLock() {
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        if (writeLock == null) {
            PersistentMapImpl.$$$reportNull$$$0(9);
        }
        return writeLock;
    }

    @NotNull
    private Lock getReadLock() {
        Lock lock = PersistentEnumeratorBase.USE_RW_LOCK ? this.myLock.readLock() : this.myLock.writeLock();
        if (lock == null) {
            PersistentMapImpl.$$$reportNull$$$0(10);
        }
        return lock;
    }

    private static boolean doNewCompact() {
        return System.getProperty("idea.persistent.hash.map.oldcompact") == null;
    }

    private boolean forceNewCompact() {
        return System.getProperty("idea.persistent.hash.map.newcompact") != null && (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFL) > 0;
    }

    public int getSize() {
        return (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L);
    }

    public int getGarbageSize() {
        return (int)this.myLiveAndGarbageKeysCounter;
    }

    public Path getBaseFile() {
        return this.myEnumerator.myFile;
    }

    @Override
    public void closeAndDelete() {
        Path baseFile = this.getBaseFile();
        try {
            this.close(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IOUtil.deleteAllFilesStartingWith(baseFile);
        try {
            if (this.myWal != null) {
                this.myWal.closeAndDelete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int keysCount() {
        return this.getSize();
    }

    @VisibleForTesting
    public boolean makesSenseToCompact() {
        if (!this.isCompactionSupported()) {
            return false;
        }
        long fileSize = this.myValueStorage.getSize();
        int megabyte = 0x100000;
        if (fileSize > 0x500000L) {
            int liveKeys = (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L);
            int deadKeys = (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFL);
            if (fileSize > 0x3200000L && this.forceNewCompact()) {
                return true;
            }
            if (deadKeys < 50) {
                return false;
            }
            long benefitSize = Math.max(0x6400000L, fileSize / 4L);
            long avgValueSize = fileSize / (long)(liveKeys + deadKeys);
            return deadKeys > liveKeys || avgValueSize * (long)deadKeys > benefitSize || (long)this.myReadCompactionGarbageSize > fileSize / 2L;
        }
        return false;
    }

    @NotNull
    private static Path checkDataFiles(@NotNull Path file2) {
        if (file2 == null) {
            PersistentMapImpl.$$$reportNull$$$0(11);
        }
        if (!Files.exists(file2, new LinkOption[0])) {
            IOUtil.deleteAllFilesStartingWith(PersistentMapImpl.getDataFile(file2));
        }
        Path path = file2;
        if (path == null) {
            PersistentMapImpl.$$$reportNull$$$0(12);
        }
        return path;
    }

    @NotNull
    static Path getDataFile(@NotNull Path file2) {
        if (file2 == null) {
            PersistentMapImpl.$$$reportNull$$$0(13);
        }
        Path path = file2.resolveSibling(file2.getFileName() + DATA_FILE_EXTENSION);
        if (path == null) {
            PersistentMapImpl.$$$reportNull$$$0(14);
        }
        return path;
    }

    @Override
    public void put(Key key, Value value) throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        if (this.myWal != null) {
            this.myWal.put(key, value);
        }
        this.getWriteLock().lock();
        try {
            this.doPut(key, value);
        }
        catch (ClosedStorageException ex) {
            throw ex;
        }
        catch (IOException ex) {
            this.markCorrupted();
            throw ex;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPut(Key key, Value value) throws IOException {
        long newValueOffset = -1L;
        if (!this.myIntMapping) {
            BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
            AppendStream appenderStream = ourFlyweightAppenderStream.getValue();
            appenderStream.setOut(bytes);
            this.myValueExternalizer.save(appenderStream, value);
            appenderStream.setOut(null);
            newValueOffset = this.myValueStorage.appendBytes(bytes.toByteArraySequence(), 0L);
        }
        this.myEnumerator.lockStorageWrite();
        try {
            long oldValueOffset;
            this.myEnumerator.markDirty(true);
            this.flushAppendCache(key);
            if (this.myDirectlyStoreLongFileOffsetMode) {
                if (this.myIntMapping) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, ((Integer)value).intValue());
                    return;
                }
                oldValueOffset = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key);
                ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, newValueOffset);
            } else {
                int id = this.enumerate(key);
                if (this.myIntMapping) {
                    this.myEnumerator.myCollisionResolutionStorage.putInt(id + this.myParentValueRefOffset, (Integer)value);
                    return;
                }
                oldValueOffset = this.readValueId(id);
                this.updateValueId(id, newValueOffset, oldValueOffset, key, 0);
            }
            this.myLiveAndGarbageKeysCounter = oldValueOffset != 0L ? ++this.myLiveAndGarbageKeysCounter : (this.myLiveAndGarbageKeysCounter += 0x100000000L);
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    private int enumerate(Key name) throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        this.getWriteLock().lock();
        try {
            this.myIntAddressForNewRecord = this.canUseIntAddressForNewRecord(this.myValueStorage.getSize());
            int n = this.myEnumerator.enumerate(name);
            return n;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    @Override
    public void appendData(Key key, @NotNull AppendablePersistentMap.ValueDataAppender appender) throws IOException {
        if (appender == null) {
            PersistentMapImpl.$$$reportNull$$$0(15);
        }
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        if (this.myWal != null) {
            this.myWal.appendData(key, appender);
        }
        this.getWriteLock().lock();
        try {
            this.doAppendData(key, appender);
        }
        catch (ClosedStorageException e) {
            throw e;
        }
        catch (IOException ex) {
            this.markCorrupted();
            throw ex;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private void doAppendData(Key key, @NotNull AppendablePersistentMap.ValueDataAppender appender) throws IOException {
        if (appender == null) {
            PersistentMapImpl.$$$reportNull$$$0(16);
        }
        assert (!this.myIntMapping);
        this.myEnumerator.markDirty(true);
        AppendStream appenderStream = ourFlyweightAppenderStream.getValue();
        BufferExposingByteArrayOutputStream stream = this.myAppendCache.get(key);
        appenderStream.setOut(stream);
        this.myValueStorage.checkAppendsAllowed(stream.size());
        appender.append(appenderStream);
        appenderStream.setOut(null);
    }

    @Override
    public boolean processKeys(@NotNull Processor<? super Key> processor) throws IOException {
        if (processor == null) {
            PersistentMapImpl.$$$reportNull$$$0(17);
        }
        this.getReadLock().lock();
        try {
            this.flushAppendCache();
            boolean bl = this.myEnumerator.iterateData(processor);
            return bl;
        }
        catch (ClosedStorageException e) {
            throw e;
        }
        catch (IOException e) {
            this.markCorrupted();
            throw e;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public boolean isClosed() {
        return this.myEnumerator.isClosed();
    }

    @Override
    public boolean isDirty() {
        return this.myEnumerator.isDirty();
    }

    @Override
    public void markDirty() throws IOException {
        this.myEnumerator.markDirty(true);
    }

    @Override
    public boolean processExistingKeys(@NotNull Processor<? super Key> processor) throws IOException {
        if (processor == null) {
            PersistentMapImpl.$$$reportNull$$$0(18);
        }
        this.getReadLock().lock();
        try {
            this.flushAppendCache();
            boolean bl = this.myEnumerator.processAllDataObject(processor, new PersistentEnumeratorBase.DataFilter(){

                @Override
                public boolean accept(int id) throws IOException {
                    return PersistentMapImpl.this.readValueId(id) != 0L;
                }
            });
            return bl;
        }
        catch (ClosedStorageException ex) {
            throw ex;
        }
        catch (IOException e) {
            this.markCorrupted();
            throw e;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    @Nullable
    public Value get(Key key) throws IOException {
        this.getReadLock().lock();
        try {
            Value Value2 = this.doGet(key);
            return Value2;
        }
        catch (ClosedStorageException ex) {
            throw ex;
        }
        catch (IOException ex) {
            this.markCorrupted();
            throw ex;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public void markCorrupted() {
        if (!this.myStorageFile.getFileSystem().isReadOnly()) {
            try {
                this.myEnumerator.markCorrupted();
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Value doGet(Key key) throws IOException {
        Value valueRead;
        int id;
        long valueOffset;
        this.flushAppendCache(key);
        this.myEnumerator.lockStorageRead();
        try {
            if (this.myDirectlyStoreLongFileOffsetMode) {
                valueOffset = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key);
                if (this.myIntMapping) {
                    Integer n = (int)valueOffset;
                    return (Value)n;
                }
                id = -1;
            } else {
                id = this.myEnumerator.tryEnumerate(key);
                if (id == 0) {
                    Value Value2 = null;
                    return Value2;
                }
                if (this.myIntMapping) {
                    Integer n = this.myEnumerator.myCollisionResolutionStorage.getInt(id + this.myParentValueRefOffset);
                    return (Value)n;
                }
                valueOffset = this.readValueId(id);
            }
            if (valueOffset == 0L) {
                Value Value3 = null;
                return Value3;
            }
        }
        finally {
            this.myEnumerator.unlockStorageRead();
        }
        PersistentHashMapValueStorage.ReadResult readResult = this.myValueStorage.readBytes(valueOffset);
        try (DataInputStream input = new DataInputStream(new UnsyncByteArrayInputStream(readResult.buffer));){
            valueRead = this.myValueExternalizer.read(input);
        }
        if (this.myValueStorage.performChunksCompaction(readResult.chunksCount)) {
            long newValueOffset = this.myValueStorage.compactChunks(new AppendablePersistentMap.ValueDataAppender(){

                @Override
                public void append(@NotNull DataOutput out) throws IOException {
                    if (out == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    PersistentMapImpl.this.myValueExternalizer.save(out, valueRead);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/io/PersistentMapImpl$5", "append"));
                }
            }, readResult);
            this.myEnumerator.lockStorageWrite();
            try {
                this.myEnumerator.markDirty(true);
                if (this.myDirectlyStoreLongFileOffsetMode) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, newValueOffset);
                } else {
                    this.updateValueId(id, newValueOffset, valueOffset, key, 0);
                }
                ++this.myLiveAndGarbageKeysCounter;
                this.myReadCompactionGarbageSize += readResult.buffer.length;
            }
            finally {
                this.myEnumerator.unlockStorageWrite();
            }
        }
        return valueRead;
    }

    @Override
    public boolean containsKey(Key key) throws IOException {
        this.getReadLock().lock();
        try {
            boolean bl = this.doContainsMapping(key);
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doContainsMapping(Key key) throws IOException {
        this.flushAppendCache(key);
        this.myEnumerator.lockStorageRead();
        try {
            if (this.myDirectlyStoreLongFileOffsetMode) {
                boolean bl = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key) != 0L;
                return bl;
            }
            int id = this.myEnumerator.tryEnumerate(key);
            if (id == 0) {
                boolean bl = false;
                return bl;
            }
            if (this.myIntMapping) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.readValueId(id) != 0L;
            return bl;
        }
        finally {
            this.myEnumerator.unlockStorageRead();
        }
    }

    @Override
    public void remove(Key key) throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        if (this.myWal != null) {
            this.myWal.remove(key);
        }
        this.getWriteLock().lock();
        try {
            this.doRemove(key);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemove(Key key) throws IOException {
        this.myEnumerator.lockStorageWrite();
        try {
            long record;
            this.flushAppendCache(key);
            if (this.myDirectlyStoreLongFileOffsetMode) {
                assert (!this.myIntMapping);
                record = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key);
                if (record != 0L) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, 0L);
                }
            } else {
                int id = this.myEnumerator.tryEnumerate(key);
                if (id == 0) {
                    return;
                }
                assert (!this.myIntMapping);
                this.myEnumerator.markDirty(true);
                record = this.readValueId(id);
                this.updateValueId(id, 0L, record, key, 0);
            }
            if (record != 0L) {
                ++this.myLiveAndGarbageKeysCounter;
                this.myLiveAndGarbageKeysCounter -= 0x100000000L;
            }
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    @Override
    public void force() throws IOException {
        if (this.myIsReadOnly) {
            return;
        }
        if (myDoTrace) {
            LOG.info("Forcing " + this.myStorageFile);
        }
        if (this.myWal != null) {
            this.myWal.flush();
        }
        this.getWriteLock().lock();
        try {
            this.doForce();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private void doForce() {
        this.myEnumerator.lockStorageWrite();
        try {
            try {
                this.clearAppenderCaches();
            }
            finally {
                this.myEnumerator.force();
            }
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    private void clearAppenderCaches() {
        if (this.myIntMapping) {
            return;
        }
        this.flushAppendCache();
        this.myValueStorage.force();
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    private void close(boolean emergency) throws IOException {
        if (myDoTrace) {
            LOG.info("Closed " + this.myStorageFile + "." + (this.myAppendCache == null ? "" : "Append cache stats: " + this.myAppendCache.dumpStats()));
        }
        StorageStatsRegistrar.INSTANCE.unregisterMap(this.myStorageFile);
        this.getWriteLock().lock();
        try {
            if (this.isClosed()) {
                return;
            }
            if (this.myWal != null) {
                this.myWal.close();
            }
            try {
                if (!emergency && this.myCompactOnClose && this.isCompactionSupported()) {
                    this.compact();
                }
            }
            finally {
                this.doClose();
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() throws IOException {
        this.myEnumerator.lockStorageWrite();
        try {
            try {
                try {
                    if (this.myAppendCacheFlusher != null) {
                        this.myAppendCacheFlusher.stop();
                    }
                    this.flushAppendCache();
                }
                catch (RuntimeException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw ex;
                }
            }
            finally {
                PersistentHashMapValueStorage valueStorage = this.myValueStorage;
                try {
                    if (valueStorage != null) {
                        valueStorage.dispose();
                    }
                }
                finally {
                    this.myEnumerator.close();
                }
            }
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void compact() throws IOException {
        if (!this.isCompactionSupported()) {
            throw new IncorrectOperationException();
        }
        this.getWriteLock().lock();
        try {
            this.force();
            LOG.info("Compacting " + this.myEnumerator.myFile);
            LOG.info("Live keys:" + (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L) + ", dead keys:" + (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFL) + ", read compaction size:" + this.myReadCompactionGarbageSize);
            long now = System.currentTimeMillis();
            Path oldDataFile = PersistentMapImpl.getDataFile(this.myEnumerator.myFile);
            File[] oldFiles = PersistentMapImpl.getFilesInDirectoryWithNameStartingWith(oldDataFile);
            Path newPath = oldDataFile.resolveSibling(oldDataFile.getFileName() + ".new");
            PersistentHashMapValueStorage.CreationTimeOptions options = this.myValueStorage.getOptions();
            final PersistentHashMapValueStorage newStorage = new PersistentHashMapValueStorage(newPath, options);
            this.myValueStorage.switchToCompactionMode();
            this.myEnumerator.markDirty(true);
            long sizeBefore = this.myValueStorage.getSize();
            this.myLiveAndGarbageKeysCounter = 0L;
            this.myReadCompactionGarbageSize = 0;
            try {
                if (PersistentMapImpl.doNewCompact()) {
                    this.newCompact(newStorage);
                } else {
                    this.myEnumerator.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

                        @Override
                        public boolean process(int keyId) throws IOException {
                            long record = PersistentMapImpl.this.readValueId(keyId);
                            if (record != 0L) {
                                PersistentHashMapValueStorage.ReadResult readResult = PersistentMapImpl.this.myValueStorage.readBytes(record);
                                long value = newStorage.appendBytes(readResult.buffer, 0, readResult.buffer.length, 0L);
                                PersistentMapImpl.this.updateValueId(keyId, value, record, null, this.getCurrentKey());
                                PersistentMapImpl.this.myLiveAndGarbageKeysCounter += 0x100000000L;
                            }
                            return true;
                        }
                    });
                }
            }
            finally {
                newStorage.dispose();
            }
            this.myValueStorage.dispose();
            for (File f : oldFiles) {
                assert (FileUtil.deleteWithRenaming(f));
            }
            long newSize = newStorage.getSize();
            File[] newFiles = PersistentMapImpl.getFilesInDirectoryWithNameStartingWith(newPath);
            File parentFile = newPath.getParent().toFile();
            String newBaseName = newPath.getFileName().toString();
            String oldDataFileBaseName = oldDataFile.getFileName().toString();
            for (File f : newFiles) {
                String nameAfterRename = StringUtil.replace(f.getName(), newBaseName, oldDataFileBaseName);
                FileUtil.rename(f, new File(parentFile, nameAfterRename));
            }
            this.myValueStorage = new PersistentHashMapValueStorage(oldDataFile, options);
            LOG.info("Compacted " + this.myEnumerator.myFile + ":" + sizeBefore + " bytes into " + newSize + " bytes in " + (System.currentTimeMillis() - now) + "ms.");
            this.myEnumerator.putMetaData(this.myLiveAndGarbageKeysCounter);
            this.myEnumerator.putMetaData2(this.myLargeIndexWatermarkId);
            if (myDoTrace) {
                LOG.assertTrue(this.myEnumerator.isDirty());
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    @ApiStatus.Internal
    public boolean isCompactionSupported() {
        return !this.myIsReadOnly && !this.myIntMapping;
    }

    private void flushAppendCache(Key key) {
        if (this.myAppendCache != null) {
            this.myAppendCache.remove(key);
        }
    }

    private void flushAppendCache() {
        if (this.myAppendCache != null) {
            this.myAppendCache.clear();
        }
    }

    private static File[] getFilesInDirectoryWithNameStartingWith(@NotNull Path fileFromDirectory) throws IOException {
        Path parentFile;
        if (fileFromDirectory == null) {
            PersistentMapImpl.$$$reportNull$$$0(19);
        }
        if ((parentFile = fileFromDirectory.getParent()) == null) {
            return ArrayUtil.EMPTY_FILE_ARRAY;
        }
        Path fileName = fileFromDirectory.getFileName();
        try (Stream<Path> children2 = Files.list(parentFile);){
            File[] fileArray = (File[])children2.filter(p -> p.getFileName().toString().startsWith(fileName.toString())).map(p -> p.toFile()).toArray(File[]::new);
            return fileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newCompact(@NotNull PersistentHashMapValueStorage newStorage) throws IOException {
        if (newStorage == null) {
            PersistentMapImpl.$$$reportNull$$$0(20);
        }
        long started = System.currentTimeMillis();
        final ArrayList<CompactionRecordInfo> infos = new ArrayList<CompactionRecordInfo>(10000);
        this.myEnumerator.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

            @Override
            public boolean process(int keyId) throws IOException {
                long record = PersistentMapImpl.this.readValueId(keyId);
                if (record != 0L) {
                    infos.add(new CompactionRecordInfo(this.getCurrentKey(), record, keyId));
                }
                return true;
            }
        });
        LOG.info("Loaded mappings:" + (System.currentTimeMillis() - started) + "ms, keys:" + infos.size());
        started = System.currentTimeMillis();
        long fragments2 = 0L;
        if (!infos.isEmpty()) {
            try {
                fragments2 = this.myValueStorage.compactValues(infos, newStorage);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new IOException("Compaction failed", t);
            }
        }
        LOG.info("Compacted values for:" + (System.currentTimeMillis() - started) + "ms fragments:" + (int)fragments2 + ", new fragments:" + (fragments2 >> 32));
        started = System.currentTimeMillis();
        this.myEnumerator.lockStorageWrite();
        try {
            for (CompactionRecordInfo info : infos) {
                this.updateValueId(info.address, info.newValueAddress, info.valueAddress, null, info.key);
                this.myLiveAndGarbageKeysCounter += 0x100000000L;
            }
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
        LOG.info("Updated mappings:" + (System.currentTimeMillis() - started) + " ms");
    }

    private long readValueId(int keyId) throws IOException {
        if (this.myDirectlyStoreLongFileOffsetMode) {
            return ((PersistentBTreeEnumerator)this.myEnumerator).keyIdToNonNegativeOffset(keyId);
        }
        long address = this.myEnumerator.myCollisionResolutionStorage.getInt(keyId + this.myParentValueRefOffset);
        if (address == 0L || address == -1L) {
            return 0L;
        }
        if (address < 0L) {
            address = -address - 1L;
        } else {
            long value = (long)this.myEnumerator.myCollisionResolutionStorage.getInt(keyId + this.myParentValueRefOffset + 4) & 0xFFFFFFFFL;
            address = (address << 32) + value & 0xBFFFFFFFFFFFFFFFL;
        }
        return address;
    }

    private void updateValueId(int keyId, long value, long oldValue, @Nullable Key key, int processingKey) throws IOException {
        boolean newKey;
        if (this.myDirectlyStoreLongFileOffsetMode) {
            ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(((InlineKeyDescriptor)this.myKeyDescriptor).fromInt(processingKey), value);
            return;
        }
        boolean bl = newKey = oldValue == 0L;
        if (newKey) {
            ++this.requests;
        }
        boolean defaultSizeInfo = true;
        if (this.myCanReEnumerate) {
            if (this.canUseIntAddressForNewRecord(value)) {
                defaultSizeInfo = false;
                this.myEnumerator.myCollisionResolutionStorage.putInt(keyId + this.myParentValueRefOffset, -((int)(value + 1L)));
                if (newKey) {
                    ++this.smallKeys;
                }
            } else if ((keyId < this.myLargeIndexWatermarkId || this.myLargeIndexWatermarkId == 0) && (newKey || this.canUseIntAddressForNewRecord(oldValue))) {
                this.myIntAddressForNewRecord = false;
                keyId = this.myEnumerator.reEnumerate(key == null ? this.myEnumerator.getValue(keyId, processingKey) : key);
                ++this.transformedKeys;
                if (this.myLargeIndexWatermarkId == 0) {
                    this.myLargeIndexWatermarkId = keyId;
                }
            }
        }
        if (defaultSizeInfo) {
            this.myEnumerator.myCollisionResolutionStorage.putInt(keyId + this.myParentValueRefOffset, (int)((value |= 0x4000000000000000L) >>> 32));
            this.myEnumerator.myCollisionResolutionStorage.putInt(keyId + this.myParentValueRefOffset + 4, (int)value);
            if (newKey) {
                ++this.largeKeys;
            }
        }
        if (newKey && IOStatistics.DEBUG && (this.requests & 0xFFFF) == 0) {
            IOStatistics.dump("small:" + this.smallKeys + ", large:" + this.largeKeys + ", transformed:" + this.transformedKeys + ",@" + this.getBaseFile());
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": " + this.myStorageFile;
    }

    @TestOnly
    public PersistentHashMapValueStorage getValueStorage() {
        return this.myValueStorage;
    }

    @TestOnly
    public boolean getReadOnly() {
        return this.myIsReadOnly;
    }

    @TestOnly
    @NotNull
    public static <Key, Value> PersistentMapImpl<Key, Value> unwrap(@NotNull PersistentHashMap<Key, Value> map2) {
        PersistentMapImpl persistentMapImpl;
        if (map2 == null) {
            PersistentMapImpl.$$$reportNull$$$0(21);
        }
        try {
            Field field = PersistentHashMap.class.getDeclaredField("myImpl");
            field.setAccessible(true);
            persistentMapImpl = (PersistentMapImpl)field.get(map2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (persistentMapImpl == null) {
            PersistentMapImpl.$$$reportNull$$$0(22);
        }
        return persistentMapImpl;
    }

    @NotNull
    public PersistentHashMapStatistics getStatistics() throws IOException {
        long valueStorageSizeInBytes = this.myValueStorage == null ? -1L : this.myValueStorage.getSize();
        return new PersistentHashMapStatistics(((PersistentBTreeEnumerator)this.myEnumerator).getStatistics(), valueStorageSizeInBytes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/PersistentMapImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFromDirectory";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStorage";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/PersistentMapImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuesExternalizer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWriteLock";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadLock";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDataFiles";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deriveEmptyMap";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 22: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "modifyVersionDependingOnOptions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAppendCache";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkDataFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDataFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doAppendData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processExistingKeys";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFilesInDirectoryWithNameStartingWith";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "newCompact";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyEnumeratorRecordHandler
    extends PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase<?>> {
        private final ThreadLocal<byte @NotNull []> myRecordBuffer;
        private final ThreadLocal<byte @NotNull []> mySmallRecordBuffer;
        private final @NotNull PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase<?>> myRecordHandler;

        MyEnumeratorRecordHandler(PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase<?>> recordHandler) {
            if (recordHandler == null) {
                MyEnumeratorRecordHandler.$$$reportNull$$$0(0);
            }
            this.myRecordHandler = recordHandler;
            this.myRecordBuffer = ThreadLocal.withInitial(() -> PersistentMapImpl.this.myDirectlyStoreLongFileOffsetMode ? ArrayUtilRt.EMPTY_BYTE_ARRAY : new byte[PersistentMapImpl.this.myParentValueRefOffset + 8]);
            this.mySmallRecordBuffer = ThreadLocal.withInitial(() -> PersistentMapImpl.this.myDirectlyStoreLongFileOffsetMode ? ArrayUtilRt.EMPTY_BYTE_ARRAY : new byte[PersistentMapImpl.this.myParentValueRefOffset + 4]);
        }

        @Override
        int recordWriteOffset(PersistentEnumeratorBase<?> enumerator, byte[] buf) throws IOException {
            return this.myRecordHandler.recordWriteOffset(enumerator, buf);
        }

        @Override
        byte @NotNull [] getRecordBuffer(PersistentEnumeratorBase<?> enumerator) {
            byte[] byArray = PersistentMapImpl.this.myIntAddressForNewRecord ? this.mySmallRecordBuffer.get() : this.myRecordBuffer.get();
            if (byArray == null) {
                MyEnumeratorRecordHandler.$$$reportNull$$$0(1);
            }
            return byArray;
        }

        @Override
        void setupRecord(PersistentEnumeratorBase enumerator, int hashCode2, int dataOffset, byte @NotNull [] buf) {
            if (buf == null) {
                MyEnumeratorRecordHandler.$$$reportNull$$$0(2);
            }
            this.myRecordHandler.setupRecord(enumerator, hashCode2, dataOffset, buf);
            for (int i = PersistentMapImpl.this.myParentValueRefOffset; i < buf.length; ++i) {
                buf[i] = 0;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recordHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/PersistentMapImpl$MyEnumeratorRecordHandler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/PersistentMapImpl$MyEnumeratorRecordHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecordBuffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setupRecord";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class AppendStream
    extends DataOutputStream {
        private AppendStream() {
            super(null);
        }

        private void setOut(BufferExposingByteArrayOutputStream stream) {
            this.out = stream;
        }
    }

    static final class CompactionRecordInfo {
        final int key;
        final int address;
        long valueAddress;
        long newValueAddress;
        byte[] value;

        CompactionRecordInfo(int _key, long _valueAddress, int _address) {
            this.key = _key;
            this.address = _address;
            this.valueAddress = _valueAddress;
        }
    }
}

