/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogView;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.settings.VersionCatalogModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0002J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0016J\u0019\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/gradle/dsl/model/GradleVersionCatalogViewImpl;", "Lcom/android/tools/idea/gradle/dsl/api/GradleVersionCatalogView;", "parsedModel", "Lcom/android/tools/idea/gradle/dsl/api/GradleSettingsModel;", "(Lcom/android/tools/idea/gradle/dsl/api/GradleSettingsModel;)V", "catalogToFile", "", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "lastModificationStamp", "", "Ljava/lang/Long;", "catalogToFileMap", "settings", "getCatalogToFileMap", "getTimeStamp", "(Lcom/android/tools/idea/gradle/dsl/api/GradleSettingsModel;)Ljava/lang/Long;", "normalisePath", "path", "updateViewIfRequired", "", "intellij.android.gradle.dsl"})
@SourceDebugExtension(value={"SMAP\nGradleVersionCatalogViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleVersionCatalogViewImpl.kt\ncom/android/tools/idea/gradle/dsl/model/GradleVersionCatalogViewImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class GradleVersionCatalogViewImpl
implements GradleVersionCatalogView {
    @Nullable
    private final GradleSettingsModel parsedModel;
    @NotNull
    private Map<String, ? extends VirtualFile> catalogToFile;
    @Nullable
    private Long lastModificationStamp;

    public GradleVersionCatalogViewImpl(@Nullable GradleSettingsModel parsedModel) {
        this.parsedModel = parsedModel;
        this.catalogToFile = this.catalogToFileMap(this.parsedModel);
        this.lastModificationStamp = this.getTimeStamp(this.parsedModel);
    }

    private final Map<String, VirtualFile> catalogToFileMap(GradleSettingsModel settings) {
        Map result = new HashMap();
        if (settings == null) {
            return result;
        }
        for (VersionCatalogModel versionCatalogModel : settings.dependencyResolutionManagement().versionCatalogs()) {
            VirtualFile it;
            String name2;
            Intrinsics.checkNotNullExpressionValue((Object)versionCatalogModel.getName(), (String)"getName(...)");
            String path = versionCatalogModel.from().getValue(GradlePropertyModel.STRING_TYPE);
            if (path == null) continue;
            if (this.normalisePath(path) == null) continue;
            boolean bl = false;
            result.put(name2, it);
        }
        return result;
    }

    private final Long getTimeStamp(GradleSettingsModel parsedModel) {
        GradleSettingsModel gradleSettingsModel = parsedModel;
        return gradleSettingsModel != null && (gradleSettingsModel = gradleSettingsModel.getPsiFile()) != null ? Long.valueOf(gradleSettingsModel.getModificationStamp()) : null;
    }

    private final VirtualFile normalisePath(String path) {
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String fromPath = string;
        GradleSettingsModel gradleSettingsModel = this.parsedModel;
        Object project = gradleSettingsModel != null ? gradleSettingsModel.getProject() : null;
        Object object = project;
        if (object == null || (object = ProjectUtil.guessProjectDir((Project)object)) == null || (object = object.getPath()) == null) {
            return null;
        }
        Object rootPath = object;
        String normalizedPath = (String)rootPath + "/" + fromPath;
        return VfsUtil.findFileByIoFile((File)new File(FileUtilRt.toSystemDependentName((String)normalizedPath)), (boolean)false);
    }

    private final void updateViewIfRequired() {
        block3: {
            Long newModificationStamp;
            block2: {
                newModificationStamp = this.getTimeStamp(this.parsedModel);
                if (this.lastModificationStamp == null || newModificationStamp == null) break block2;
                long l = newModificationStamp;
                Long l2 = this.lastModificationStamp;
                Intrinsics.checkNotNull((Object)l2);
                if (l <= l2) break block3;
            }
            this.catalogToFile = this.catalogToFileMap(this.parsedModel);
            this.lastModificationStamp = newModificationStamp;
        }
    }

    @Override
    @NotNull
    public Map<String, VirtualFile> getCatalogToFileMap() {
        this.updateViewIfRequired();
        return MapsKt.toMap(this.catalogToFile);
    }
}

