/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.intellij.internal.statistic.devkit.StatisticsDevKitUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/EventsSchemeConfigurationModel;", "", "()V", "currentSettings", "Lcom/intellij/internal/statistic/devkit/actions/EventsSchemeConfigurationModel$EventsSchemePathSettings;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "getPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "pathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "recorderComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "", "recorderToSettings", "", "getRecorderToSettings", "()Ljava/util/Map;", "useCustomPathCheckBox", "Ljavax/swing/JCheckBox;", "reset", "recorderId", "updatePanel", "", "updatePathField", "validate", "Lcom/intellij/openapi/ui/ValidationInfo;", "validatePath", "settings", "EventsSchemePathSettings", "intellij.platform.statistics.devkit"})
public final class EventsSchemeConfigurationModel {
    @NotNull
    private final DialogPanel panel;
    @NotNull
    private final Map<String, EventsSchemePathSettings> recorderToSettings = new LinkedHashMap();
    private ComboBox<String> recorderComboBox;
    @NotNull
    private final TextFieldWithBrowseButton pathField = new TextFieldWithBrowseButton();
    private JCheckBox useCustomPathCheckBox;
    @Nullable
    private EventsSchemePathSettings currentSettings;

    public EventsSchemeConfigurationModel() {
        this.panel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(){

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                $this$panel.row("Recorder:", (Function1)new Function1<Row, Unit>(){

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Row $this$row) {
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Iterable iterable = StatisticsDevKitUtil.INSTANCE.getLogProvidersInTestMode();
                        Row row = $this$row;
                        EventsSchemeConfigurationModel eventsSchemeConfigurationModel = this;
                        boolean $i$f$map = false;
                        void var4_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            StatisticsEventLoggerProvider statisticsEventLoggerProvider = (StatisticsEventLoggerProvider)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getRecorderId());
                        }
                        collection = (List)destination$iv$iv;
                        eventsSchemeConfigurationModel.recorderComboBox = (ComboBox)Row.comboBox$default((Row)row, (Collection)collection, null, (int)2, null).align((Align)AlignX.FILL.INSTANCE).onChanged((Function1)new Function1<ComboBox<String>, Unit>(){

                            public final void invoke(@NotNull ComboBox<String> it) {
                                Intrinsics.checkNotNullParameter(it, (String)"it");
                                this.updatePanel();
                            }
                        }).getComponent();
                    }
                });
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        useCustomPathCheckBox = (JCheckBox)$this$row.checkBox("Use custom path:").onChanged((Function1)new Function1<JBCheckBox, Unit>(){

                            public final void invoke(@NotNull JBCheckBox it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                EventsSchemePathSettings eventsSchemePathSettings = currentSettings;
                                if (eventsSchemePathSettings != null) {
                                    eventsSchemePathSettings.setUseCustomPath(it.isSelected());
                                }
                                this.updatePathField();
                            }
                        }).getComponent();
                        $this$row.cell((JComponent)pathField).align((Align)AlignX.FILL.INSTANCE).onChanged((Function1)new Function1<TextFieldWithBrowseButton, Unit>(){

                            public final void invoke(@NotNull TextFieldWithBrowseButton it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                JCheckBox jCheckBox = useCustomPathCheckBox;
                                if (jCheckBox == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomPathCheckBox");
                                    jCheckBox = null;
                                }
                                if (jCheckBox.isSelected()) {
                                    EventsSchemePathSettings eventsSchemePathSettings = currentSettings;
                                    if (eventsSchemePathSettings != null) {
                                        eventsSchemePathSettings.setCustomPath(pathField.getText());
                                    }
                                }
                            }
                        });
                    }
                }), (int)1, null).layout(RowLayout.LABEL_ALIGNED);
            }
        }));
        this.pathField.addBrowseFolderListener("Select Events Scheme Location ", null, null, FileChooserDescriptorFactory.createSingleFileDescriptor());
        this.updatePanel();
    }

    @NotNull
    public final DialogPanel getPanel() {
        return this.panel;
    }

    @NotNull
    public final Map<String, EventsSchemePathSettings> getRecorderToSettings() {
        return this.recorderToSettings;
    }

    private final void updatePathField() {
        JCheckBox jCheckBox = this.useCustomPathCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomPathCheckBox");
            jCheckBox = null;
        }
        boolean useCustomPath = jCheckBox.isSelected();
        EventsSchemePathSettings settings2 = this.currentSettings;
        if (settings2 == null) {
            return;
        }
        this.pathField.setEditable(useCustomPath);
        this.pathField.setEnabled(useCustomPath);
        this.pathField.setText(settings2.getCurrentPath());
    }

    private final void updatePanel() {
        EventsSchemePathSettings settings2;
        ComboBox<String> comboBox = this.recorderComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recorderComboBox");
            comboBox = null;
        }
        Object object = comboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String recorderId = (String)object;
        EventsSchemePathSettings eventsSchemePathSettings = this.recorderToSettings.computeIfAbsent(recorderId, arg_0 -> EventsSchemeConfigurationModel.updatePanel$lambda$0((Function1)new Function1<String, EventsSchemePathSettings>(recorderId){
            final /* synthetic */ String $recorderId;
            {
                this.$recorderId = $recorderId;
                super(1);
            }

            @NotNull
            public final EventsSchemePathSettings invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new EventsSchemePathSettings(this.$recorderId);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)eventsSchemePathSettings, (String)"computeIfAbsent(...)");
        this.currentSettings = settings2 = eventsSchemePathSettings;
        JCheckBox jCheckBox = this.useCustomPathCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomPathCheckBox");
            jCheckBox = null;
        }
        jCheckBox.setSelected(settings2.getUseCustomPath());
        this.updatePathField();
    }

    @NotNull
    public final EventsSchemeConfigurationModel reset(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        ComboBox<String> comboBox = this.recorderComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recorderComboBox");
            comboBox = null;
        }
        comboBox.setSelectedItem((Object)recorderId);
        return this;
    }

    @Nullable
    public final ValidationInfo validate() {
        EventsSchemePathSettings eventsSchemePathSettings = this.currentSettings;
        if (eventsSchemePathSettings == null) {
            return null;
        }
        EventsSchemePathSettings currentPathSettings = eventsSchemePathSettings;
        ValidationInfo currentValidationInfo = this.validatePath(currentPathSettings);
        if (currentValidationInfo != null) {
            return currentValidationInfo;
        }
        for (Map.Entry<String, EventsSchemePathSettings> entry : this.recorderToSettings.entrySet()) {
            ValidationInfo validationInfo;
            String recorder = entry.getKey();
            EventsSchemePathSettings settings2 = entry.getValue();
            if (Intrinsics.areEqual((Object)settings2, (Object)this.currentSettings) || (validationInfo = this.validatePath(settings2)) == null) continue;
            ComboBox<String> comboBox = this.recorderComboBox;
            if (comboBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recorderComboBox");
                comboBox = null;
            }
            comboBox.setSelectedItem((Object)recorder);
            this.updatePanel();
            return validationInfo;
        }
        return null;
    }

    private final ValidationInfo validatePath(EventsSchemePathSettings settings2) {
        if (!settings2.getUseCustomPath()) {
            return null;
        }
        String customPath = settings2.getCustomPath();
        CharSequence charSequence = customPath;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return new ValidationInfo("Specify events scheme path.", (JComponent)this.pathField.getTextField());
        }
        if (!FileUtil.exists((String)customPath)) {
            return new ValidationInfo("File doesn't exist.", (JComponent)this.pathField.getTextField());
        }
        return null;
    }

    private static final EventsSchemePathSettings updatePanel$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (EventsSchemePathSettings)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0004R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/EventsSchemeConfigurationModel$EventsSchemePathSettings;", "", "recorderId", "", "(Ljava/lang/String;)V", "currentPath", "getCurrentPath", "()Ljava/lang/String;", "customPath", "getCustomPath", "setCustomPath", "defaultPath", "useCustomPath", "", "getUseCustomPath", "()Z", "setUseCustomPath", "(Z)V", "intellij.platform.statistics.devkit"})
    public static final class EventsSchemePathSettings {
        @NotNull
        private final String defaultPath;
        @Nullable
        private String customPath;
        private boolean useCustomPath;

        public EventsSchemePathSettings(@NotNull String recorderId) {
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            this.defaultPath = ((Object)BaseEventLogMetadataPersistence.getDefaultMetadataFile((String)recorderId, (String)"events-scheme.json", null)).toString();
            com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings pathSettings = EventLogMetadataSettingsPersistence.getInstance().getPathSettings(recorderId);
            if (pathSettings != null) {
                this.customPath = pathSettings.getCustomPath();
                this.useCustomPath = pathSettings.isUseCustomPath();
            }
        }

        @Nullable
        public final String getCustomPath() {
            return this.customPath;
        }

        public final void setCustomPath(@Nullable String string) {
            this.customPath = string;
        }

        public final boolean getUseCustomPath() {
            return this.useCustomPath;
        }

        public final void setUseCustomPath(boolean bl) {
            this.useCustomPath = bl;
        }

        @NotNull
        public final String getCurrentPath() {
            String customEventsSchemePath = this.customPath;
            return this.useCustomPath && customEventsSchemePath != null ? customEventsSchemePath : this.defaultPath;
        }
    }
}

