/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.components;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileSaverDialogImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.VisualizationBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\t2\b\b\u0001\u0010\u0014\u001a\u00020\u00042\b\b\u0001\u0010\u0015\u001a\u00020\u0004J,\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u001aH\u0002J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u001d\u001a\u00020\r2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0002J.\u0010!\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0016\b\u0002\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r\u0018\u00010\u001aJY\u0010#\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\t2\b\b\u0001\u0010\u0014\u001a\u00020\u00042\b\b\u0001\u0010\u0015\u001a\u00020\u00042\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u001a\u00a2\u0006\u0002\u0010'J\u0014\u0010(\u001a\u00020\u0011*\u00020)2\u0006\u0010*\u001a\u00020\u0004H\u0002J\u0019\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0%*\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010,R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutputUtil;", "", "()V", "EXPORT_FAILURE_DESCRIPTION", "", "EXPORT_FAILURE_DETAILS", "EXPORT_FAILURE_TITLE", "virtualBaseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/project/Project;", "getVirtualBaseDir", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/openapi/vfs/VirtualFile;", "checkOrCreateDestinationFile", "", "file", "Ljava/io/File;", "createIfMissing", "", "chooseDirectory", "project", "title", "description", "chooseImageSaveLocation", "image", "Ljava/awt/image/BufferedImage;", "onChoose", "Lkotlin/Function1;", "getAvailableFormats", "", "notifyExportError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "saveImageWithFileChooser", "onSave", "saveWithFileChooser", "extensions", "", "defaultName", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;ZLkotlin/jvm/functions/Function1;)V", "hasWritersFor", "Ljavax/imageio/ImageTypeSpecifier;", "format", "wrapInArray", "(Lcom/intellij/openapi/vfs/VirtualFile;)[Lcom/intellij/openapi/vfs/VirtualFile;", "WritableDirectoryChooserDescriptor", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nInlayOutputUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayOutputUtil.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutputUtil\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n37#2,2:128\n766#3:130\n857#3,2:131\n26#4:133\n1#5:134\n*S KotlinDebug\n*F\n+ 1 InlayOutputUtil.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutputUtil\n*L\n41#1:128,2\n47#1:130\n47#1:131,2\n69#1:133\n*E\n"})
public final class InlayOutputUtil {
    @NotNull
    public static final InlayOutputUtil INSTANCE = new InlayOutputUtil();
    @Nls
    @NotNull
    private static final String EXPORT_FAILURE_TITLE = VisualizationBundle.INSTANCE.message("inlay.output.export.failure", new Object[0]);
    @Nls
    @NotNull
    private static final String EXPORT_FAILURE_DETAILS = VisualizationBundle.INSTANCE.message("inlay.output.export.failure.details", new Object[0]);
    @Nls
    @NotNull
    private static final String EXPORT_FAILURE_DESCRIPTION = VisualizationBundle.INSTANCE.message("inlay.output.export.failure.description", new Object[0]);

    private InlayOutputUtil() {
    }

    public final void saveImageWithFileChooser(@NotNull Project project, @NotNull BufferedImage image, @Nullable Function1<? super File, Unit> onSave) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.chooseImageSaveLocation(project, image, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(image, onSave){
            final /* synthetic */ BufferedImage $image;
            final /* synthetic */ Function1<File, Unit> $onSave;
            {
                this.$image = $image;
                this.$onSave = $onSave;
                super(1);
            }

            public final void invoke(@NotNull File location) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                    ImageIO.write((RenderedImage)this.$image, FilesKt.getExtension((File)location), location);
                    Function1<File, Unit> function1 = this.$onSave;
                    if (function1 == null) break block0;
                    function1.invoke((Object)location);
                }
            }
        }));
    }

    public static /* synthetic */ void saveImageWithFileChooser$default(InlayOutputUtil inlayOutputUtil, Project project, BufferedImage bufferedImage, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        inlayOutputUtil.saveImageWithFileChooser(project, bufferedImage, (Function1<? super File, Unit>)function1);
    }

    private final void chooseImageSaveLocation(Project project, BufferedImage image, Function1<? super File, Unit> onChoose) {
        Collection $this$toTypedArray$iv = this.getAvailableFormats(image);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] extensions = thisCollection$iv.toArray(new String[0]);
        this.saveWithFileChooser(project, VisualizationBundle.INSTANCE.message("inlay.output.image.export.title", new Object[0]), VisualizationBundle.INSTANCE.message("inlay.output.image.export.description", new Object[0]), extensions, "image", false, onChoose);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAvailableFormats(BufferedImage image) {
        void $this$filterTo$iv$iv;
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(image);
        Iterable $this$filter$iv = this.getAvailableFormats();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String format = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)imageTypeSpecifier);
            if (!INSTANCE.hasWritersFor(imageTypeSpecifier, format)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<String> getAvailableFormats() {
        Object[] objectArray = new String[]{"png", "jpeg", "bmp", "gif", "tiff"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final boolean hasWritersFor(ImageTypeSpecifier $this$hasWritersFor, String format) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWriters($this$hasWritersFor, format);
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"getImageWriters(...)");
        return SequencesKt.any((Sequence)SequencesKt.asSequence(iterator));
    }

    @Nullable
    public final VirtualFile chooseDirectory(@NotNull Project project, @Nls @NotNull String title, @Nls @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        WritableDirectoryChooserDescriptor descriptor = new WritableDirectoryChooserDescriptor(title, description);
        FileChooserDialogImpl chooser = new FileChooserDialogImpl((FileChooserDescriptor)descriptor, project);
        VirtualFile[] toSelect = this.wrapInArray(this.getVirtualBaseDir(project));
        Object[] objectArray = chooser.choose(project, Arrays.copyOf(toSelect, toSelect.length));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"choose(...)");
        Object[] choice = objectArray;
        return (VirtualFile)ArraysKt.firstOrNull((Object[])choice);
    }

    private final VirtualFile[] wrapInArray(VirtualFile $this$wrapInArray) {
        VirtualFile[] virtualFileArray;
        if ($this$wrapInArray != null) {
            VirtualFile[] virtualFileArray2 = new VirtualFile[]{$this$wrapInArray};
            virtualFileArray = virtualFileArray2;
        } else {
            boolean $i$f$emptyArray = false;
            virtualFileArray = new VirtualFile[]{};
        }
        return virtualFileArray;
    }

    public final void saveWithFileChooser(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Label @NotNull String description, @NotNull String[] extensions, @NotNull String defaultName, boolean createIfMissing, @NotNull Function1<? super File, Unit> onChoose) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
            Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
            Intrinsics.checkNotNullParameter(onChoose, (String)"onChoose");
            FileSaverDescriptor descriptor = new FileSaverDescriptor(title, description, Arrays.copyOf(extensions, extensions.length));
            FileSaverDialogImpl chooser = new FileSaverDialogImpl(descriptor, project);
            VirtualFileWrapper virtualFileWrapper = chooser.save(this.getVirtualBaseDir(project), defaultName);
            if (virtualFileWrapper == null) break block2;
            VirtualFileWrapper fileWrapper = virtualFileWrapper;
            boolean bl = false;
            File file = fileWrapper.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            File destination = file;
            try {
                INSTANCE.checkOrCreateDestinationFile(destination, createIfMissing);
                onChoose.invoke((Object)destination);
            }
            catch (Exception e) {
                INSTANCE.notifyExportError(e);
            }
        }
    }

    private final VirtualFile getVirtualBaseDir(Project $this$virtualBaseDir) {
        String string = $this$virtualBaseDir.getBasePath();
        Intrinsics.checkNotNull((Object)string);
        return VfsUtil.findFile((Path)Paths.get(string, new String[0]), (boolean)true);
    }

    private final void checkOrCreateDestinationFile(File file, boolean createIfMissing) {
        if (!file.exists()) {
            if (!file.createNewFile()) {
                throw new RuntimeException(EXPORT_FAILURE_DETAILS);
            }
            if (!createIfMissing && !file.delete()) {
                throw new RuntimeException(EXPORT_FAILURE_DETAILS);
            }
        }
    }

    private final void notifyExportError(Exception e) {
        String string;
        String string2 = e.getMessage();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = ":\n" + it;
        } else {
            string = null;
        }
        String details = string;
        String content2 = EXPORT_FAILURE_DESCRIPTION + details;
        Messages.showErrorDialog((String)content2, (String)EXPORT_FAILURE_TITLE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutputUtil$WritableDirectoryChooserDescriptor;", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "title", "", "description", "(Ljava/lang/String;Ljava/lang/String;)V", "isFileSelectable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.notebooks.visualization"})
    private static final class WritableDirectoryChooserDescriptor
    extends FileChooserDescriptor {
        public WritableDirectoryChooserDescriptor(@Nls @NotNull String title, @Nls @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            super(false, true, false, false, false, false);
            this.withDescription(description);
            this.withTitle(title);
        }

        public boolean isFileSelectable(@Nullable VirtualFile file) {
            VirtualFile virtualFile = file;
            return (virtualFile != null ? virtualFile.isWritable() : false) && super.isFileSelectable(file);
        }
    }
}

