/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.plaf.ProgressBarUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.ui.editor.ui.JupyterProgressBarUI;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookBelowCellDelimiterPanel;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookBelowCellDelimiterPanelKt;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005*\u0001\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000e\u001a\u00020\u000f2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000bJ\b\u0010\u0015\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "progress", "org/jetbrains/plugins/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel$progress$1", "Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel$progress$1;", "shouldUseCustomBackground", "", "steadyUI", "Lorg/jetbrains/plugins/notebooks/ui/editor/ui/JupyterProgressBarUI;", "initialize", "", "executionTimeDetails", "", "hasProgressBar", "setProgressVisibility", "showProgressBar", "updateUI", "intellij.notebooks.ui"})
public final class NotebookBelowCellDelimiterPanel
extends JPanel {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final JupyterProgressBarUI steadyUI;
    private boolean shouldUseCustomBackground;
    @NotNull
    private final progress.1 progress;

    public NotebookBelowCellDelimiterPanel(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(new GridLayout(1, 1));
        this.editor = editor;
        this.steadyUI = new JupyterProgressBarUI();
        this.progress = new JProgressBar(this){
            final /* synthetic */ NotebookBelowCellDelimiterPanel this$0;
            {
                this.this$0 = $receiver;
                super(0, 100);
                NotebookBelowCellDelimiterPanelKt.access$setStopped(this);
                this.setUI((ProgressBarUI)((Object)NotebookBelowCellDelimiterPanel.access$getSteadyUI$p($receiver)));
            }

            public void updateUI() {
                this.setUI((ProgressBarUI)((Object)NotebookBelowCellDelimiterPanel.access$getSteadyUI$p(this.this$0)));
            }
        };
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    /*
     * WARNING - void declaration
     */
    public final void initialize(@Nls @Nullable String executionTimeDetails, boolean hasProgressBar) {
        NotebookEditorAppearance notebookAppearance = NotebookUtilKt.getNotebookAppearance((Editor)this.editor);
        int customHeight = executionTimeDetails != null ? notebookAppearance.getEXECUTION_TIME_HEIGHT() : notebookAppearance.getSPACER_HEIGHT();
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, customHeight));
        this.setBackground(this.editor.getColorsScheme().getDefaultBackground());
        if (executionTimeDetails != null) {
            JLabel label = new JLabel(executionTimeDetails);
            float labelSize = Math.min(JBFont.small().getSize(), this.editor.getFontSize() - 2);
            label.setFont((Font)JBFont.label().deriveFont(Math.max(1.0f, labelSize)));
            label.setForeground(UIUtil.getLabelInfoForeground());
            EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            this.setBackground(notebookAppearance.getCodeCellBackground(editorColorsScheme));
            this.add((Component)label, "West");
            this.shouldUseCustomBackground = true;
        } else if (hasProgressBar) {
            void $this$initialize_u24lambda_u240;
            progress.1 var5_6;
            EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            this.setBackground(notebookAppearance.getCodeCellBackground(editorColorsScheme));
            this.setBorder(BorderFactory.createEmptyBorder(notebookAppearance.getSPACER_HEIGHT() - notebookAppearance.getPROGRESS_STATUS_HEIGHT(), 0, 0, 7));
            progress.1 labelSize = var5_6 = this.progress;
            NotebookBelowCellDelimiterPanel notebookBelowCellDelimiterPanel = this;
            boolean bl = false;
            $this$initialize_u24lambda_u240.setUI((ProgressBarUI)((Object)this.steadyUI));
            notebookBelowCellDelimiterPanel.add(var5_6);
            this.setProgressVisibility(false);
            this.shouldUseCustomBackground = true;
        }
    }

    @Override
    public void updateUI() {
        if (this.editor != null) {
            Color color;
            if (this.shouldUseCustomBackground) {
                NotebookEditorAppearance notebookEditorAppearance = NotebookUtilKt.getNotebookAppearance((Editor)this.editor);
                EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
                Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
                color = notebookEditorAppearance.getCodeCellBackground(editorColorsScheme);
            } else {
                color = this.editor.getColorsScheme().getDefaultBackground();
            }
            this.setBackground(color);
        }
        super.updateUI();
    }

    public final void setProgressVisibility(boolean showProgressBar) {
        boolean bl;
        EDT.assertIsEdt();
        if (showProgressBar) {
            NotebookBelowCellDelimiterPanelKt.access$setRunning(this.progress);
            bl = true;
        } else {
            NotebookBelowCellDelimiterPanelKt.access$setStopped(this.progress);
            bl = false;
        }
        this.progress.setVisible(bl);
    }

    public static final /* synthetic */ JupyterProgressBarUI access$getSteadyUI$p(NotebookBelowCellDelimiterPanel $this) {
        return $this.steadyUI;
    }
}

