/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookLineMarkerRenderer;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookAboveCodeCellGutterLineMarkerRenderer;", "Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookLineMarkerRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "inlayId", "", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;J)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nNotebookLineMarkerRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookLineMarkerRenderer.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookAboveCodeCellGutterLineMarkerRenderer\n+ 2 NotebookUtil.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookUtilKt\n+ 3 NotebookUtil.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookUtilKt$paintNotebookCellBackgroundGutter$1\n*L\n1#1,145:1\n20#2,22:146\n42#2,9:169\n27#3:168\n*S KotlinDebug\n*F\n+ 1 NotebookLineMarkerRenderer.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookAboveCodeCellGutterLineMarkerRenderer\n*L\n43#1:146,22\n43#1:169,9\n43#1:168\n*E\n"})
public final class NotebookAboveCodeCellGutterLineMarkerRenderer
extends NotebookLineMarkerRenderer {
    @NotNull
    private final RangeHighlighter highlighter;

    public NotebookAboveCodeCellGutterLineMarkerRenderer(@NotNull RangeHighlighter highlighter, long inlayId) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        super(inlayId);
        this.highlighter = highlighter;
    }

    /*
     * WARNING - void declaration
     */
    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        void editor$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        EditorImpl cfr_ignored_0 = (EditorImpl)editor;
        IntRange lines = new IntRange(((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getStartOffset()), ((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getEndOffset()));
        Rectangle rectangle = this.getInlayBounds((EditorEx)editor, lines);
        if (rectangle == null) {
            return;
        }
        Rectangle inlayBounds = rectangle;
        int bottomRectHeight = NotebookUtilKt.getNotebookAppearance(editor).getCELL_BORDER_HEIGHT() / 2;
        EditorImpl editorImpl = (EditorImpl)editor;
        int top$iv = inlayBounds.y + inlayBounds.height - bottomRectHeight;
        boolean $i$f$paintNotebookCellBackgroundGutter = false;
        NotebookEditorAppearance appearance$iv = NotebookUtilKt.getNotebookAppearance((Editor)editor$iv);
        Color stripe$iv = appearance$iv.getCellStripeColor((EditorImpl)editor$iv, lines);
        Color stripeHover$iv = appearance$iv.getCellStripeHoverColor((EditorImpl)editor$iv, lines);
        int borderWidth$iv = appearance$iv.getLeftBorderWidth();
        int rectBorderCellX$iv = r.width - borderWidth$iv;
        EditorColorsScheme editorColorsScheme = editor$iv.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        g.setColor(appearance$iv.getCodeCellBackground(editorColorsScheme));
        if (editor$iv.getEditorKind() == EditorKind.DIFF) {
            g.fillRect(rectBorderCellX$iv + 3, top$iv, borderWidth$iv - 3, bottomRectHeight);
        } else {
            g.fillRect(rectBorderCellX$iv, top$iv, borderWidth$iv, bottomRectHeight);
        }
        boolean bl = false;
        if (editor$iv.getEditorKind() != EditorKind.DIFF) {
            if (stripe$iv != null) {
                NotebookUtilKt.paintCellStripe(appearance$iv, g, r, stripe$iv, top$iv, bottomRectHeight);
            }
            if (stripeHover$iv != null) {
                g.setColor(stripeHover$iv);
                g.fillRect(r.width - appearance$iv.getLeftBorderWidth(), top$iv, appearance$iv.getCellLeftLineHoverWidth(), bottomRectHeight);
            }
        }
    }
}

