/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.core.operators.layer.normalization;

import io.kinference.attribute.Attribute;
import io.kinference.core.data.tensor.KITensor;
import io.kinference.core.data.tensor.TensorExtensionsKt;
import io.kinference.core.operators.layer.normalization.EmbedLayerNormalizationVer1;
import io.kinference.core.operators.layer.normalization.QEmbedLayerNormalization;
import io.kinference.data.ONNXData;
import io.kinference.graph.Contexts;
import io.kinference.ndarray.arrays.ByteNDArray;
import io.kinference.ndarray.arrays.FloatNDArray;
import io.kinference.ndarray.arrays.IntNDArray;
import io.kinference.ndarray.arrays.MutableFloatNDArray;
import io.kinference.ndarray.arrays.NDArrayCore;
import io.kinference.ndarray.arrays.UByteNDArray;
import io.kinference.ndarray.arrays.pointers.BytePointer;
import io.kinference.ndarray.arrays.pointers.FloatPointer;
import io.kinference.ndarray.arrays.pointers.FloatPointerKt;
import io.kinference.ndarray.arrays.pointers.IntPointer;
import io.kinference.ndarray.arrays.pointers.UBytePointer;
import io.kinference.ndarray.arrays.tiled.ByteTiledArray;
import io.kinference.ndarray.arrays.tiled.IntTiledArray;
import io.kinference.ndarray.arrays.tiled.UByteTiledArray;
import io.kinference.operator.AttributeInfo;
import io.kinference.operator.IOInfo;
import io.kinference.operator.Operator;
import io.kinference.operator.OperatorInfo;
import io.kinference.operator.VersionInfo;
import io.kinference.primitives.types.DataType;
import io.kinference.protobuf.message.AttributeProto;
import io.kinference.protobuf.message.TensorProto;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UByteArray;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\u000bJI\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\t\"\u0010\b\u0000\u0010\u0014*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00172\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lio/kinference/core/operators/layer/normalization/QEmbedLayerNormalizationVer1;", "Lio/kinference/core/operators/layer/normalization/QEmbedLayerNormalization;", "name", "", "attributes", "", "Lio/kinference/attribute/Attribute;", "", "inputs", "", "outputs", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "epsilon", "", "getEpsilon", "()F", "epsilon$delegate", "Lio/kinference/operator/Operator$AttributeValueDelegate;", "apply", "Lio/kinference/core/data/tensor/KITensor;", "D", "Lio/kinference/data/ONNXData;", "contexts", "Lio/kinference/graph/Contexts;", "(Lio/kinference/graph/Contexts;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "inference-core"})
@SourceDebugExtension(value={"SMAP\nQEmbedLayerNormalization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QEmbedLayerNormalization.kt\nio/kinference/core/operators/layer/normalization/QEmbedLayerNormalizationVer1\n+ 2 FloatPointer.kt\nio/kinference/ndarray/arrays/pointers/FloatPointerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1829#2:229\n1830#2,36:231\n953#2:267\n955#2,30:269\n1985#2:299\n1986#2,36:301\n1085#2:337\n1087#2,30:339\n175#2,18:369\n1829#2:387\n1830#2,36:389\n1985#2:425\n1986#2,36:427\n1#3:230\n1#3:268\n1#3:300\n1#3:338\n1#3:388\n1#3:426\n*S KotlinDebug\n*F\n+ 1 QEmbedLayerNormalization.kt\nio/kinference/core/operators/layer/normalization/QEmbedLayerNormalizationVer1\n*L\n150#1:229\n150#1:231,36\n158#1:267\n158#1:269,30\n171#1:299\n171#1:301,36\n179#1:337\n179#1:339,30\n192#1:369,18\n206#1:387\n206#1:389,36\n215#1:425\n215#1:427,36\n150#1:230\n158#1:268\n171#1:300\n179#1:338\n206#1:388\n215#1:426\n*E\n"})
public final class QEmbedLayerNormalizationVer1
extends QEmbedLayerNormalization {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Operator.AttributeValueDelegate epsilon$delegate;
    @NotNull
    private static final Set<TensorProto.DataType> INT_TYPE;
    @NotNull
    private static final Set<TensorProto.DataType> BYTE_TYPES;
    @NotNull
    private static final Set<TensorProto.DataType> FLOAT_TYPE;
    @NotNull
    private static final List<AttributeInfo> ATTRIBUTES_INFO;
    @NotNull
    private static final List<IOInfo> INPUTS_INFO;
    @NotNull
    private static final List<IOInfo> OUTPUTS_INFO;
    @NotNull
    private static final VersionInfo VERSION;
    @NotNull
    private static final OperatorInfo INFO;

    public QEmbedLayerNormalizationVer1(@NotNull String name, @NotNull Map<String, Attribute<Object>> attributes, @NotNull List<String> inputs, @NotNull List<String> outputs) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        super(name, INFO, attributes, inputs, outputs, null);
        this.epsilon$delegate = Operator.attribute$default(this, null, 1, null);
    }

    private final float getEpsilon() {
        return ((Number)this.epsilon$delegate.getValue(this, $$delegatedProperties[0])).floatValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public <D extends ONNXData<?, ?>> Object apply(@NotNull Contexts<D> contexts, @NotNull List<KITensor> inputs, @NotNull Continuation<? super List<KITensor>> $completion) {
        int n;
        int n2;
        Integer n3;
        Object it;
        int n4;
        int n5;
        KITensor kITensor = inputs.get(0);
        Intrinsics.checkNotNull((Object)kITensor);
        NDArrayCore nDArrayCore = kITensor.getData();
        Intrinsics.checkNotNull((Object)nDArrayCore, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.IntNDArray");
        IntNDArray inputIds = (IntNDArray)nDArrayCore;
        KITensor kITensor2 = (KITensor)CollectionsKt.getOrNull(inputs, (int)1);
        IntNDArray segmentIds = (IntNDArray)(kITensor2 != null ? kITensor2.getData() : null);
        KITensor kITensor3 = inputs.get(2);
        Intrinsics.checkNotNull((Object)kITensor3);
        NDArrayCore wordEmbedding = kITensor3.getData();
        KITensor kITensor4 = inputs.get(3);
        Intrinsics.checkNotNull((Object)kITensor4);
        NDArrayCore positionEmbedding = kITensor4.getData();
        KITensor kITensor5 = (KITensor)CollectionsKt.getOrNull(inputs, (int)4);
        NDArrayCore segmentEmbedding = kITensor5 != null ? kITensor5.getData() : null;
        KITensor kITensor6 = inputs.get(5);
        Intrinsics.checkNotNull((Object)kITensor6);
        NDArrayCore gamma = kITensor6.getData();
        KITensor kITensor7 = inputs.get(6);
        Intrinsics.checkNotNull((Object)kITensor7);
        NDArrayCore beta2 = kITensor7.getData();
        KITensor kITensor8 = inputs.get(7);
        IntNDArray mask2 = (IntNDArray)(kITensor8 != null ? kITensor8.getData() : null);
        KITensor kITensor9 = inputs.get(8);
        Intrinsics.checkNotNull((Object)kITensor9);
        NDArrayCore nDArrayCore2 = kITensor9.getData();
        Intrinsics.checkNotNull((Object)nDArrayCore2, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
        float wordEmbeddingScale = ((FloatNDArray)nDArrayCore2).singleValue().floatValue();
        KITensor kITensor10 = inputs.get(9);
        Intrinsics.checkNotNull((Object)kITensor10);
        NDArrayCore nDArrayCore3 = kITensor10.getData();
        Intrinsics.checkNotNull((Object)nDArrayCore3, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
        float positionEmbeddingScale = ((FloatNDArray)nDArrayCore3).singleValue().floatValue();
        KITensor kITensor11 = (KITensor)CollectionsKt.getOrNull(inputs, (int)10);
        FloatNDArray floatNDArray = (FloatNDArray)(kITensor11 != null ? kITensor11.getData() : null);
        Float segmentEmbeddingScale = floatNDArray != null ? floatNDArray.singleValue() : null;
        KITensor kITensor12 = inputs.get(11);
        Intrinsics.checkNotNull((Object)kITensor12);
        NDArrayCore nDArrayCore4 = kITensor12.getData();
        Intrinsics.checkNotNull((Object)nDArrayCore4, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
        float gammaScale = ((FloatNDArray)nDArrayCore4).singleValue().floatValue();
        KITensor kITensor13 = inputs.get(12);
        Intrinsics.checkNotNull((Object)kITensor13);
        NDArrayCore nDArrayCore5 = kITensor13.getData();
        Intrinsics.checkNotNull((Object)nDArrayCore5, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
        float betaScale = ((FloatNDArray)nDArrayCore5).singleValue().floatValue();
        KITensor kITensor14 = inputs.get(13);
        Intrinsics.checkNotNull((Object)kITensor14);
        Object it2 = kITensor14.getData().singleValue();
        boolean bl = false;
        Object object = it2;
        if (object instanceof Byte) {
            n5 = ((Number)it2).byteValue();
        } else if (object instanceof UByte) {
            n5 = ((UByte)it2).unbox-impl() & 0xFF;
        } else {
            throw new IllegalStateException("Byte or UByte only".toString());
        }
        int wordEmbeddingZeroPoint = n5;
        KITensor kITensor15 = inputs.get(14);
        Intrinsics.checkNotNull((Object)kITensor15);
        Object it3 = kITensor15.getData().singleValue();
        boolean bl2 = false;
        Object object2 = it3;
        if (object2 instanceof Byte) {
            n4 = ((Number)it3).byteValue();
        } else if (object2 instanceof UByte) {
            n4 = ((UByte)it3).unbox-impl() & 0xFF;
        } else {
            throw new IllegalStateException("Byte or UByte only".toString());
        }
        int positionEmbeddingZeroPoint = n4;
        Object object3 = (KITensor)CollectionsKt.getOrNull(inputs, (int)15);
        if (object3 != null && (object3 = ((KITensor)object3).getData()) != null && (object3 = object3.singleValue()) != null) {
            int n6;
            it = object3;
            boolean bl3 = false;
            Object object4 = it;
            if (object4 instanceof Byte) {
                n6 = ((Number)it).byteValue();
            } else if (object4 instanceof UByte) {
                n6 = ((UByte)it).unbox-impl() & 0xFF;
            } else {
                throw new IllegalStateException("Byte or UByte only".toString());
            }
            n3 = Boxing.boxInt((int)n6);
        } else {
            n3 = null;
        }
        Integer segmentEmbeddingZeroPoint = n3;
        KITensor kITensor16 = inputs.get(16);
        Intrinsics.checkNotNull((Object)kITensor16);
        Object it4 = kITensor16.getData().singleValue();
        boolean bl4 = false;
        it = it4;
        if (it instanceof Byte) {
            n2 = ((Number)it4).byteValue();
        } else if (it instanceof UByte) {
            n2 = ((UByte)it4).unbox-impl() & 0xFF;
        } else {
            throw new IllegalStateException("Byte or UByte only".toString());
        }
        int gammaZeroPoint = n2;
        KITensor kITensor17 = inputs.get(17);
        Intrinsics.checkNotNull((Object)kITensor17);
        Object it5 = kITensor17.getData().singleValue();
        boolean bl5 = false;
        Object object5 = it5;
        if (object5 instanceof Byte) {
            n = ((Number)it5).byteValue();
        } else if (object5 instanceof UByte) {
            n = ((UByte)it5).unbox-impl() & 0xFF;
        } else {
            throw new IllegalStateException("Byte or UByte only".toString());
        }
        int betaZeroPoint = n;
        object2 = inputIds.getShape();
        Object batchSize = object2[0];
        Object seqLen = object2[1];
        int hiddenSize2 = wordEmbedding.getShape()[1];
        int[] nArray = new int[]{(int)batchSize, (int)seqLen, hiddenSize2};
        MutableFloatNDArray output = new MutableFloatNDArray(nArray);
        DataType inputType = wordEmbedding.getType();
        IntPointer inputIdsPointer = IntTiledArray.pointer$default(inputIds.getArray(), 0, 1, null);
        Object object6 = segmentIds;
        IntPointer segmentIdsPointer = object6 != null && (object6 = ((IntNDArray)object6).getArray()) != null ? IntTiledArray.pointer$default((IntTiledArray)object6, 0, 1, null) : null;
        for (int i = 0; i < batchSize; ++i) {
            int batch = i;
            boolean bl6 = false;
            block9: for (int j = 0; j < seqLen; ++j) {
                int offset$iv;
                float[] block$iv;
                byte by;
                float f;
                Object object7;
                int n7;
                int posIdx = j;
                boolean bl7 = false;
                int inputIdx = inputIdsPointer.getAndIncrement();
                IntPointer intPointer = segmentIdsPointer;
                int segmentIdx = intPointer != null ? intPointer.getAndIncrement() : 0;
                int wordEmbedOffset = inputIdx * hiddenSize2;
                int segmentEmbedOffset = segmentIdx * hiddenSize2;
                int posEmbedOffset = posIdx * hiddenSize2;
                int outputOffset = (posIdx + batch * seqLen) * hiddenSize2;
                FloatPointer outputPointer = output.getArray().pointer(outputOffset);
                float sum2 = 0.0f;
                switch (WhenMappings.$EnumSwitchMapping$0[inputType.ordinal()]) {
                    case 1: {
                        int seg;
                        byte by2;
                        byte word;
                        int n8;
                        int index$iv;
                        byte[] sndBlock$iv;
                        int end$iv;
                        int dstOffset$iv;
                        Intrinsics.checkNotNull((Object)wordEmbedding, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.ByteNDArray");
                        Object wordEmbedPointer = ((ByteNDArray)wordEmbedding).getArray().pointer(wordEmbedOffset);
                        Object object8 = (ByteNDArray)segmentEmbedding;
                        BytePointer segmentEmbedPointer = object8 != null && (object8 = ((ByteNDArray)object8).getArray()) != null ? ((ByteTiledArray)object8).pointer(segmentEmbedOffset) : null;
                        Intrinsics.checkNotNull((Object)positionEmbedding, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.ByteNDArray");
                        Object posEmbedPointer = ((ByteNDArray)positionEmbedding).getArray().pointer(posEmbedOffset);
                        FloatPointer $this$acceptDouble$iv = outputPointer;
                        boolean $i$f$acceptDouble = false;
                        if (!FloatPointerKt.isCompatibleBySize($this$acceptDouble$iv, (BytePointer)wordEmbedPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$acceptDouble$1$iv22 = false;
                            String $i$a$-require-FloatPointerKt$acceptDouble$1$iv22 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptDouble$1$iv22.toString());
                        }
                        if (!FloatPointerKt.isCompatibleBySize($this$acceptDouble$iv, (BytePointer)posEmbedPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$acceptDouble$2$iv22 = false;
                            String $i$a$-require-FloatPointerKt$acceptDouble$2$iv22 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptDouble$2$iv22.toString());
                        }
                        if (FloatPointerKt.isCompatibleWith($this$acceptDouble$iv, (BytePointer)wordEmbedPointer) && FloatPointerKt.isCompatibleWith($this$acceptDouble$iv, (BytePointer)posEmbedPointer)) {
                            float[] dstBlock$iv;
                            for (end$iv = hiddenSize2; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                                dstBlock$iv = $this$acceptDouble$iv.getCurrentBlock();
                                dstOffset$iv = $this$acceptDouble$iv.getIndexInBlock();
                                byte[] fstBlock$iv = ((BytePointer)wordEmbedPointer).getCurrentBlock();
                                sndBlock$iv = ((BytePointer)posEmbedPointer).getCurrentBlock();
                                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                                    $this$acceptDouble$iv.blockIncrement();
                                    ((BytePointer)wordEmbedPointer).blockIncrement();
                                    ((BytePointer)posEmbedPointer).blockIncrement();
                                } else {
                                    $this$acceptDouble$iv.setIndexInBlock($this$acceptDouble$iv.getIndexInBlock() + end$iv);
                                    ((BytePointer)wordEmbedPointer).setIndexInBlock(((BytePointer)wordEmbedPointer).getIndexInBlock() + end$iv);
                                    ((BytePointer)posEmbedPointer).setIndexInBlock(((BytePointer)posEmbedPointer).getIndexInBlock() + end$iv);
                                }
                                index$iv = dstOffset$iv;
                                n8 = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                                while (index$iv < n8) {
                                    void pos;
                                    float cfr_ignored_0 = dstBlock$iv[index$iv];
                                    byte by3 = sndBlock$iv[index$iv];
                                    byte by4 = fstBlock$iv[index$iv];
                                    n7 = index$iv++;
                                    object7 = dstBlock$iv;
                                    boolean bl8 = false;
                                    float subtotal = (float)(word - wordEmbeddingZeroPoint) * wordEmbeddingScale + (float)(pos - positionEmbeddingZeroPoint) * positionEmbeddingScale;
                                    sum2 += subtotal;
                                    f = subtotal;
                                    object7[n7] = f;
                                }
                            }
                        } else {
                            while (end$iv > 0) {
                                $this$acceptDouble$iv.get();
                                byte pos = ((BytePointer)posEmbedPointer).getAndIncrement();
                                word = ((BytePointer)wordEmbedPointer).getAndIncrement();
                                object7 = $this$acceptDouble$iv;
                                boolean bl9 = false;
                                float subtotal = (float)(word - wordEmbeddingZeroPoint) * wordEmbeddingScale + (float)(pos - positionEmbeddingZeroPoint) * positionEmbeddingScale;
                                sum2 += subtotal;
                                ((FloatPointer)object7).set(((Number)Boxing.boxFloat((float)subtotal)).floatValue());
                                $this$acceptDouble$iv.increment();
                                --end$iv;
                            }
                        }
                        if (segmentEmbedPointer == null) break;
                        outputPointer.setLinearIndex(outputOffset);
                        FloatPointer $this$accept$iv = outputPointer;
                        boolean $i$f$accept = false;
                        if (!FloatPointerKt.isCompatibleBySize($this$accept$iv, segmentEmbedPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$accept$1$iv22 = false;
                            String $i$a$-require-FloatPointerKt$accept$1$iv22 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$accept$1$iv22.toString());
                        }
                        if (FloatPointerKt.isCompatibleWith($this$accept$iv, segmentEmbedPointer)) {
                            float[] dstBlock$iv;
                            for (end$iv = hiddenSize2; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                                byte[] srcBlock$iv = segmentEmbedPointer.getCurrentBlock();
                                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                                    $this$accept$iv.blockIncrement();
                                    segmentEmbedPointer.blockIncrement();
                                } else {
                                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                                    segmentEmbedPointer.setIndexInBlock(segmentEmbedPointer.getIndexInBlock() + end$iv);
                                }
                                int index$iv2 = dstOffset$iv;
                                index$iv = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                                while (index$iv2 < index$iv) {
                                    void dst;
                                    n8 = srcBlock$iv[index$iv2];
                                    float pos = dstBlock$iv[index$iv2];
                                    n7 = index$iv2++;
                                    object7 = dstBlock$iv;
                                    by2 = 0;
                                    Integer n9 = segmentEmbeddingZeroPoint;
                                    Intrinsics.checkNotNull((Object)n9);
                                    float f2 = seg - n9;
                                    Float f3 = segmentEmbeddingScale;
                                    Intrinsics.checkNotNull((Object)f3);
                                    float subtotal = f2 * f3.floatValue();
                                    sum2 += subtotal;
                                    f = dst + subtotal;
                                    object7[n7] = f;
                                }
                            }
                        } else {
                            while (end$iv > 0) {
                                seg = segmentEmbedPointer.getAndIncrement();
                                float dst = $this$accept$iv.get();
                                object7 = $this$accept$iv;
                                by2 = 0;
                                Integer n10 = segmentEmbeddingZeroPoint;
                                Intrinsics.checkNotNull((Object)n10);
                                float f4 = seg - n10;
                                Float f5 = segmentEmbeddingScale;
                                Intrinsics.checkNotNull((Object)f5);
                                float subtotal = f4 * f5.floatValue();
                                sum2 += subtotal;
                                ((FloatPointer)object7).set(((Number)Boxing.boxFloat((float)(dst + subtotal))).floatValue());
                                $this$accept$iv.increment();
                                --end$iv;
                            }
                        }
                        break;
                    }
                    case 2: {
                        int seg;
                        byte by2;
                        byte word;
                        byte[] sndBlock$iv;
                        int end$iv;
                        int dstOffset$iv;
                        Intrinsics.checkNotNull((Object)wordEmbedding, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.UByteNDArray");
                        Object wordEmbedPointer = ((UByteNDArray)wordEmbedding).getArray().pointer(wordEmbedOffset);
                        Object object9 = (UByteNDArray)segmentEmbedding;
                        BytePointer segmentEmbedPointer = object9 != null && (object9 = ((UByteNDArray)object9).getArray()) != null ? ((UByteTiledArray)object9).pointer(segmentEmbedOffset) : null;
                        Intrinsics.checkNotNull((Object)positionEmbedding, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.UByteNDArray");
                        Object posEmbedPointer = ((UByteNDArray)positionEmbedding).getArray().pointer(posEmbedOffset);
                        FloatPointer $this$acceptDouble$iv = outputPointer;
                        boolean $i$f$acceptDouble = false;
                        if (!FloatPointerKt.isCompatibleBySize($this$acceptDouble$iv, (UBytePointer)wordEmbedPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$acceptDouble$9$iv22 = false;
                            String $i$a$-require-FloatPointerKt$acceptDouble$9$iv22 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptDouble$9$iv22.toString());
                        }
                        if (!FloatPointerKt.isCompatibleBySize($this$acceptDouble$iv, (UBytePointer)posEmbedPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$acceptDouble$10$iv22 = false;
                            String $i$a$-require-FloatPointerKt$acceptDouble$10$iv22 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptDouble$10$iv22.toString());
                        }
                        if (FloatPointerKt.isCompatibleWith($this$acceptDouble$iv, (UBytePointer)wordEmbedPointer) && FloatPointerKt.isCompatibleWith($this$acceptDouble$iv, (UBytePointer)posEmbedPointer)) {
                            float[] dstBlock$iv;
                            for (end$iv = hiddenSize2; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                                dstBlock$iv = $this$acceptDouble$iv.getCurrentBlock();
                                dstOffset$iv = $this$acceptDouble$iv.getIndexInBlock();
                                byte[] fstBlock$iv = ((UBytePointer)wordEmbedPointer).getCurrentBlock-TcUX1vc();
                                sndBlock$iv = ((UBytePointer)posEmbedPointer).getCurrentBlock-TcUX1vc();
                                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                                    $this$acceptDouble$iv.blockIncrement();
                                    ((UBytePointer)wordEmbedPointer).blockIncrement();
                                    ((UBytePointer)posEmbedPointer).blockIncrement();
                                } else {
                                    $this$acceptDouble$iv.setIndexInBlock($this$acceptDouble$iv.getIndexInBlock() + end$iv);
                                    ((UBytePointer)wordEmbedPointer).setIndexInBlock(((UBytePointer)wordEmbedPointer).getIndexInBlock() + end$iv);
                                    ((UBytePointer)posEmbedPointer).setIndexInBlock(((UBytePointer)posEmbedPointer).getIndexInBlock() + end$iv);
                                }
                                int index$iv3 = dstOffset$iv;
                                seg = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                                while (index$iv3 < seg) {
                                    void pos;
                                    float cfr_ignored_1 = dstBlock$iv[index$iv3];
                                    byte dst = UByteArray.get-w2LRezQ((byte[])sndBlock$iv, (int)index$iv3);
                                    by2 = UByteArray.get-w2LRezQ((byte[])fstBlock$iv, (int)index$iv3);
                                    n7 = index$iv3++;
                                    object7 = dstBlock$iv;
                                    boolean bl10 = false;
                                    float subtotal = (float)((word & 0xFF) - wordEmbeddingZeroPoint) * wordEmbeddingScale + (float)((pos & 0xFF) - positionEmbeddingZeroPoint) * positionEmbeddingScale;
                                    sum2 += subtotal;
                                    f = subtotal;
                                    object7[n7] = f;
                                }
                            }
                        } else {
                            while (end$iv > 0) {
                                $this$acceptDouble$iv.get();
                                byte pos = ((UBytePointer)posEmbedPointer).getAndIncrement-w2LRezQ();
                                word = ((UBytePointer)wordEmbedPointer).getAndIncrement-w2LRezQ();
                                object7 = $this$acceptDouble$iv;
                                boolean bl11 = false;
                                float subtotal = (float)((word & 0xFF) - wordEmbeddingZeroPoint) * wordEmbeddingScale + (float)((pos & 0xFF) - positionEmbeddingZeroPoint) * positionEmbeddingScale;
                                sum2 += subtotal;
                                ((FloatPointer)object7).set(((Number)Boxing.boxFloat((float)subtotal)).floatValue());
                                $this$acceptDouble$iv.increment();
                                --end$iv;
                            }
                        }
                        if (segmentEmbedPointer == null) break;
                        outputPointer.setLinearIndex(outputOffset);
                        FloatPointer $this$accept$iv = outputPointer;
                        boolean $i$f$accept = false;
                        if (!FloatPointerKt.isCompatibleBySize($this$accept$iv, (UBytePointer)((Object)segmentEmbedPointer), hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$accept$5$iv22 = false;
                            String $i$a$-require-FloatPointerKt$accept$5$iv22 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$accept$5$iv22.toString());
                        }
                        if (FloatPointerKt.isCompatibleWith($this$accept$iv, (UBytePointer)((Object)segmentEmbedPointer))) {
                            float[] dstBlock$iv;
                            for (end$iv = hiddenSize2; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                                byte[] srcBlock$iv = ((UBytePointer)((Object)segmentEmbedPointer)).getCurrentBlock-TcUX1vc();
                                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                                    $this$accept$iv.blockIncrement();
                                    ((UBytePointer)((Object)segmentEmbedPointer)).blockIncrement();
                                } else {
                                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                                    ((UBytePointer)((Object)segmentEmbedPointer)).setIndexInBlock(((UBytePointer)((Object)segmentEmbedPointer)).getIndexInBlock() + end$iv);
                                }
                                int index$iv = dstOffset$iv;
                                int index$iv3 = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                                while (index$iv < index$iv3) {
                                    void dst;
                                    seg = UByteArray.get-w2LRezQ((byte[])srcBlock$iv, (int)index$iv);
                                    float pos = dstBlock$iv[index$iv];
                                    n7 = index$iv++;
                                    object7 = dstBlock$iv;
                                    by = 0;
                                    Integer n11 = segmentEmbeddingZeroPoint;
                                    Intrinsics.checkNotNull((Object)n11);
                                    float f6 = (seg & 0xFF) - n11;
                                    Float f7 = segmentEmbeddingScale;
                                    Intrinsics.checkNotNull((Object)f7);
                                    float subtotal = f6 * f7.floatValue();
                                    sum2 += subtotal;
                                    f = dst + subtotal;
                                    object7[n7] = f;
                                }
                            }
                        } else {
                            while (end$iv > 0) {
                                seg = ((UBytePointer)((Object)segmentEmbedPointer)).getAndIncrement-w2LRezQ();
                                float dst = $this$accept$iv.get();
                                object7 = $this$accept$iv;
                                by = 0;
                                Integer n12 = segmentEmbeddingZeroPoint;
                                Intrinsics.checkNotNull((Object)n12);
                                float f8 = (seg & 0xFF) - n12;
                                Float f9 = segmentEmbeddingScale;
                                Intrinsics.checkNotNull((Object)f9);
                                float subtotal = f8 * f9.floatValue();
                                sum2 += subtotal;
                                ((FloatPointer)object7).set(((Number)Boxing.boxFloat((float)(dst + subtotal))).floatValue());
                                $this$accept$iv.increment();
                                --end$iv;
                            }
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Only Byte or UByte".toString());
                    }
                }
                float mean2 = sum2 / (float)hiddenSize2;
                sum2 = 0.0f;
                outputPointer.setLinearIndex(outputOffset);
                FloatPointer $this$map$iv = outputPointer;
                boolean $i$f$map = false;
                for (int end$iv = hiddenSize2; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                    block$iv = $this$map$iv.getCurrentBlock();
                    if (block$iv.length <= (offset$iv = $this$map$iv.getIndexInBlock()) + end$iv) {
                        $this$map$iv.blockIncrement();
                    } else {
                        $this$map$iv.setIndexInBlock($this$map$iv.getIndexInBlock() + end$iv);
                    }
                    int index$iv = offset$iv;
                    int dstBlock$iv = Math.min(block$iv.length, offset$iv + end$iv);
                    while (index$iv < dstBlock$iv) {
                        void value;
                        float end$iv2 = block$iv[index$iv];
                        n7 = index$iv++;
                        object7 = block$iv;
                        boolean bl12 = false;
                        void temp = value - mean2;
                        sum2 += temp * temp;
                        f = temp;
                        object7[n7] = f;
                    }
                }
                float eps = (float)Math.sqrt(sum2 / (float)hiddenSize2 + this.getEpsilon());
                outputPointer.setLinearIndex(outputOffset);
                switch (WhenMappings.$EnumSwitchMapping$0[inputType.ordinal()]) {
                    case 1: {
                        byte beta3;
                        int index$iv;
                        byte[] fstBlock$iv;
                        int end$iv;
                        Intrinsics.checkNotNull((Object)gamma, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.ByteNDArray");
                        Object gammaPointer = ByteTiledArray.pointer$default(((ByteNDArray)gamma).getArray(), 0, 1, null);
                        Intrinsics.checkNotNull((Object)beta2, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.ByteNDArray");
                        Object betaPointer = ByteTiledArray.pointer$default(((ByteNDArray)beta2).getArray(), 0, 1, null);
                        FloatPointer $this$acceptDouble$iv = outputPointer;
                        boolean $i$f$acceptDouble = false;
                        if (!FloatPointerKt.isCompatibleBySize($this$acceptDouble$iv, (BytePointer)gammaPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$acceptDouble$1$iv32 = false;
                            String $i$a$-require-FloatPointerKt$acceptDouble$1$iv32 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptDouble$1$iv32.toString());
                        }
                        if (!FloatPointerKt.isCompatibleBySize($this$acceptDouble$iv, (BytePointer)betaPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$acceptDouble$2$iv32 = false;
                            String $i$a$-require-FloatPointerKt$acceptDouble$2$iv32 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptDouble$2$iv32.toString());
                        }
                        if (FloatPointerKt.isCompatibleWith($this$acceptDouble$iv, (BytePointer)gammaPointer) && FloatPointerKt.isCompatibleWith($this$acceptDouble$iv, (BytePointer)betaPointer)) {
                            int dstOffset$iv;
                            float[] dstBlock$iv;
                            for (end$iv = hiddenSize2; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                                dstBlock$iv = $this$acceptDouble$iv.getCurrentBlock();
                                dstOffset$iv = $this$acceptDouble$iv.getIndexInBlock();
                                fstBlock$iv = ((BytePointer)gammaPointer).getCurrentBlock();
                                byte[] sndBlock$iv = ((BytePointer)betaPointer).getCurrentBlock();
                                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                                    $this$acceptDouble$iv.blockIncrement();
                                    ((BytePointer)gammaPointer).blockIncrement();
                                    ((BytePointer)betaPointer).blockIncrement();
                                } else {
                                    $this$acceptDouble$iv.setIndexInBlock($this$acceptDouble$iv.getIndexInBlock() + end$iv);
                                    ((BytePointer)gammaPointer).setIndexInBlock(((BytePointer)gammaPointer).getIndexInBlock() + end$iv);
                                    ((BytePointer)betaPointer).setIndexInBlock(((BytePointer)betaPointer).getIndexInBlock() + end$iv);
                                }
                                index$iv = dstOffset$iv;
                                int n13 = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                                while (index$iv < n13) {
                                    void gamma2;
                                    void out;
                                    by = sndBlock$iv[index$iv];
                                    byte subtotal = fstBlock$iv[index$iv];
                                    float bl11 = dstBlock$iv[index$iv];
                                    n7 = index$iv++;
                                    object7 = dstBlock$iv;
                                    boolean bl13 = false;
                                    f = out / eps * ((float)(gamma2 - gammaZeroPoint) * gammaScale) + (float)(beta3 - betaZeroPoint) * betaScale;
                                    object7[n7] = f;
                                }
                            }
                            continue block9;
                        }
                        while (end$iv > 0) {
                            beta3 = ((BytePointer)betaPointer).getAndIncrement();
                            byte gamma2 = ((BytePointer)gammaPointer).getAndIncrement();
                            float out = $this$acceptDouble$iv.get();
                            object7 = $this$acceptDouble$iv;
                            boolean bl14 = false;
                            ((FloatPointer)object7).set(((Number)Boxing.boxFloat((float)(out / eps * ((float)(gamma2 - gammaZeroPoint) * gammaScale) + (float)(beta3 - betaZeroPoint) * betaScale))).floatValue());
                            $this$acceptDouble$iv.increment();
                            --end$iv;
                        }
                        continue block9;
                    }
                    case 2: {
                        byte beta3;
                        int index$iv;
                        byte[] fstBlock$iv;
                        int end$iv;
                        Intrinsics.checkNotNull((Object)gamma, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.UByteNDArray");
                        Object gammaPointer = UByteTiledArray.pointer$default(((UByteNDArray)gamma).getArray(), 0, 1, null);
                        Intrinsics.checkNotNull((Object)beta2, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.UByteNDArray");
                        Object betaPointer = UByteTiledArray.pointer$default(((UByteNDArray)beta2).getArray(), 0, 1, null);
                        FloatPointer $this$acceptDouble$iv = outputPointer;
                        boolean $i$f$acceptDouble = false;
                        if (!FloatPointerKt.isCompatibleBySize($this$acceptDouble$iv, (UBytePointer)gammaPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$acceptDouble$9$iv32 = false;
                            String $i$a$-require-FloatPointerKt$acceptDouble$9$iv32 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptDouble$9$iv32.toString());
                        }
                        if (!FloatPointerKt.isCompatibleBySize($this$acceptDouble$iv, (UBytePointer)betaPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$acceptDouble$10$iv32 = false;
                            String $i$a$-require-FloatPointerKt$acceptDouble$10$iv32 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptDouble$10$iv32.toString());
                        }
                        if (FloatPointerKt.isCompatibleWith($this$acceptDouble$iv, (UBytePointer)gammaPointer) && FloatPointerKt.isCompatibleWith($this$acceptDouble$iv, (UBytePointer)betaPointer)) {
                            int dstOffset$iv;
                            float[] dstBlock$iv;
                            for (end$iv = hiddenSize2; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                                dstBlock$iv = $this$acceptDouble$iv.getCurrentBlock();
                                dstOffset$iv = $this$acceptDouble$iv.getIndexInBlock();
                                fstBlock$iv = ((UBytePointer)gammaPointer).getCurrentBlock-TcUX1vc();
                                byte[] sndBlock$iv = ((UBytePointer)betaPointer).getCurrentBlock-TcUX1vc();
                                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                                    $this$acceptDouble$iv.blockIncrement();
                                    ((UBytePointer)gammaPointer).blockIncrement();
                                    ((UBytePointer)betaPointer).blockIncrement();
                                } else {
                                    $this$acceptDouble$iv.setIndexInBlock($this$acceptDouble$iv.getIndexInBlock() + end$iv);
                                    ((UBytePointer)gammaPointer).setIndexInBlock(((UBytePointer)gammaPointer).getIndexInBlock() + end$iv);
                                    ((UBytePointer)betaPointer).setIndexInBlock(((UBytePointer)betaPointer).getIndexInBlock() + end$iv);
                                }
                                index$iv = dstOffset$iv;
                                int n14 = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                                while (index$iv < n14) {
                                    beta3 = UByteArray.get-w2LRezQ((byte[])sndBlock$iv, (int)index$iv);
                                    byte gamma3 = UByteArray.get-w2LRezQ((byte[])fstBlock$iv, (int)index$iv);
                                    float out = dstBlock$iv[index$iv];
                                    n7 = index$iv++;
                                    object7 = dstBlock$iv;
                                    boolean bl15 = false;
                                    f = out / eps * ((float)((gamma3 & 0xFF) - gammaZeroPoint) * gammaScale) + (float)((beta3 & 0xFF) - betaZeroPoint) * betaScale;
                                    object7[n7] = f;
                                }
                            }
                            continue block9;
                        }
                        while (end$iv > 0) {
                            beta3 = ((UBytePointer)betaPointer).getAndIncrement-w2LRezQ();
                            byte gamma4 = ((UBytePointer)gammaPointer).getAndIncrement-w2LRezQ();
                            float out = $this$acceptDouble$iv.get();
                            object7 = $this$acceptDouble$iv;
                            boolean bl16 = false;
                            ((FloatPointer)object7).set(((Number)Boxing.boxFloat((float)(out / eps * ((float)((gamma4 & 0xFF) - gammaZeroPoint) * gammaScale) + (float)((beta3 & 0xFF) - betaZeroPoint) * betaScale))).floatValue());
                            $this$acceptDouble$iv.increment();
                            --end$iv;
                        }
                        continue block9;
                    }
                    default: {
                        throw new IllegalStateException("Only Byte or UByte".toString());
                    }
                }
            }
        }
        Object[] objectArray = new KITensor[]{TensorExtensionsKt.asTensor$default(output, null, 1, null), TensorExtensionsKt.asTensor$default(EmbedLayerNormalizationVer1.Companion.createMaskIndices$inference_core(mask2, (int)batchSize, (int)seqLen), null, 1, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(QEmbedLayerNormalizationVer1.class, "epsilon", "getEpsilon()F", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        INT_TYPE = SetsKt.setOf((Object)TensorProto.DataType.INT32);
        objectArray = new TensorProto.DataType[]{TensorProto.DataType.INT8, TensorProto.DataType.UINT8};
        BYTE_TYPES = SetsKt.setOf((Object[])objectArray);
        FLOAT_TYPE = SetsKt.setOf((Object)TensorProto.DataType.FLOAT);
        ATTRIBUTES_INFO = CollectionsKt.listOf((Object)new AttributeInfo("epsilon", SetsKt.setOf((Object)AttributeProto.AttributeType.FLOAT), true, null, 8, null));
        objectArray = new IOInfo[]{new IOInfo(0, INT_TYPE, "input_ids", false, null, false, null, 120, null), new IOInfo(1, INT_TYPE, "segment_ids", true, null, false, null, 112, null), new IOInfo(2, BYTE_TYPES, "word_embedding_quant", false, null, false, null, 120, null), new IOInfo(3, BYTE_TYPES, "position_embedding_quant", false, null, false, null, 120, null), new IOInfo(4, BYTE_TYPES, "segment_embedding", true, null, false, null, 112, null), new IOInfo(5, BYTE_TYPES, "gamma_quant", false, null, false, null, 120, null), new IOInfo(6, BYTE_TYPES, "beta_quant", false, null, false, null, 120, null), new IOInfo(7, INT_TYPE, "mask", true, null, false, null, 112, null), new IOInfo(8, FLOAT_TYPE, "word_embedding_scale", false, null, false, null, 120, null), new IOInfo(9, FLOAT_TYPE, "position_embedding_scale", false, null, false, null, 120, null), new IOInfo(10, FLOAT_TYPE, "segment_embedding_scale", true, null, false, null, 112, null), new IOInfo(11, FLOAT_TYPE, "gamma_scale", false, null, false, null, 120, null), new IOInfo(12, FLOAT_TYPE, "beta_scale", false, null, false, null, 120, null), new IOInfo(13, BYTE_TYPES, "word_embedding_zero_point", false, null, false, null, 120, null), new IOInfo(14, BYTE_TYPES, "position_embedding_zero_point", false, null, false, null, 120, null), new IOInfo(15, BYTE_TYPES, "segment_embedding_zero_point", true, null, false, null, 112, null), new IOInfo(16, BYTE_TYPES, "gamma_zero_point", false, null, false, null, 120, null), new IOInfo(17, BYTE_TYPES, "beta_zero_point", false, null, false, null, 120, null)};
        INPUTS_INFO = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new IOInfo[]{new IOInfo(0, FLOAT_TYPE, "layernorm_out", false, null, false, null, 112, null), new IOInfo(1, INT_TYPE, "mask_index_out", false, null, false, null, 112, null)};
        OUTPUTS_INFO = CollectionsKt.listOf((Object[])objectArray);
        VERSION = new VersionInfo(1, 0, 2, null);
        INFO = new OperatorInfo("QEmbedLayerNormalization", (Collection<AttributeInfo>)ATTRIBUTES_INFO, INPUTS_INFO, OUTPUTS_INFO, VERSION, "com.microsoft");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lio/kinference/core/operators/layer/normalization/QEmbedLayerNormalizationVer1$Companion;", "", "()V", "ATTRIBUTES_INFO", "", "Lio/kinference/operator/AttributeInfo;", "BYTE_TYPES", "", "Lio/kinference/protobuf/message/TensorProto$DataType;", "FLOAT_TYPE", "INFO", "Lio/kinference/operator/OperatorInfo;", "INPUTS_INFO", "Lio/kinference/operator/IOInfo;", "INT_TYPE", "OUTPUTS_INFO", "VERSION", "Lio/kinference/operator/VersionInfo;", "getVERSION$inference_core", "()Lio/kinference/operator/VersionInfo;", "inference-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VersionInfo getVERSION$inference_core() {
            return VERSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataType.values().length];
            try {
                nArray[DataType.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.UBYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

