/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.embeddings.search.services;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.platform.ml.embeddings.search.indices.IndexableEntity;
import com.intellij.platform.ml.embeddings.search.services.FileContentBasedEmbeddingsStorage;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aJ\u0015\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00070\t\u00a2\u0006\u0002\b\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H&J%\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0000\u00a2\u0006\u0002\b$R,\u0010\u0007\u001a \u0012\u0004\u0012\u00020\t\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/intellij/platform/ml/embeddings/search/services/SemanticSearchFileContentChangeListener;", "E", "Lcom/intellij/platform/ml/embeddings/search/indices/IndexableEntity;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fileIdToEntityCounts", "", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "", "Lkotlin/Pair;", "", "", "isEnabled", "", "()Z", "mutex", "Ljava/util/concurrent/locks/ReentrantLock;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addEntityCountsForFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "symbols", "", "getEntity", "id", "(Ljava/lang/String;)Lcom/intellij/platform/ml/embeddings/search/indices/IndexableEntity;", "getFileId", "Lorg/jetbrains/annotations/NotNull;", "getStorage", "Lcom/intellij/platform/ml/embeddings/search/services/FileContentBasedEmbeddingsStorage;", "inferEntityDiff", "entities", "inferEntityDiff$intellij_platform_ml_embeddings", "intellij.platform.ml.embeddings"})
@SourceDebugExtension(value={"SMAP\nSemanticSearchFileContentChangeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticSearchFileContentChangeListener.kt\ncom/intellij/platform/ml/embeddings/search/services/SemanticSearchFileContentChangeListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1536#2:51\n1536#2:54\n37#3,2:52\n37#3,2:57\n26#4:55\n1#5:56\n*S KotlinDebug\n*F\n+ 1 SemanticSearchFileContentChangeListener.kt\ncom/intellij/platform/ml/embeddings/search/services/SemanticSearchFileContentChangeListener\n*L\n22#1:51\n28#1:54\n22#1:52,2\n47#1:57,2\n30#1:55\n*E\n"})
public abstract class SemanticSearchFileContentChangeListener<E extends IndexableEntity> {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFilePointer, Pair<String, Integer>[]> fileIdToEntityCounts;
    @NotNull
    private final ReentrantLock mutex;

    public SemanticSearchFileContentChangeListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Map map = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createSmallMemoryFootprintMap(...)");
        this.fileIdToEntityCounts = map;
        this.mutex = new ReentrantLock();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public abstract boolean isEnabled();

    @NotNull
    public abstract FileContentBasedEmbeddingsStorage<E> getStorage();

    @NotNull
    public abstract E getEntity(@NotNull String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEntityCountsForFile(@NotNull VirtualFile file, @NotNull List<? extends E> symbols) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
        Lock lock = this.mutex;
        lock.lock();
        try {
            boolean bl = false;
            Map<VirtualFilePointer, Pair<String, Integer>[]> map = this.fileIdToEntityCounts;
            VirtualFilePointer virtualFilePointer = this.getFileId(file);
            Iterable $this$groupingBy$iv = symbols;
            boolean $i$f$groupingBy = false;
            Collection $this$toTypedArray$iv = MapsKt.toList((Map)GroupingKt.eachCount((Grouping)new Grouping<E, String>($this$groupingBy$iv){
                final /* synthetic */ Iterable $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                @NotNull
                public Iterator<E> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                public String keyOf(E element) {
                    IndexableEntity it = (IndexableEntity)element;
                    boolean bl = false;
                    String string = it.getId().intern();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intern(...)");
                    return string;
                }
            }));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
            map.put(virtualFilePointer, pairArray);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final VirtualFilePointer getFileId(VirtualFile file) {
        VirtualFilePointer virtualFilePointer = VirtualFilePointerManager.getInstance().create(file, (Disposable)this.getStorage(), null);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFilePointer, (String)"create(...)");
        return virtualFilePointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object inferEntityDiff$intellij_platform_ml_embeddings(@NotNull VirtualFile file, @NotNull List<? extends IndexableEntity> entities2) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(entities2, (String)"entities");
        Lock lock = this.mutex;
        lock.lock();
        try {
            Unit unit2;
            int oldCount;
            int n;
            boolean bl = false;
            Iterable $this$groupingBy$iv = entities2;
            boolean $i$f$groupingBy = false;
            Map entityCounts = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<IndexableEntity, String>($this$groupingBy$iv){
                final /* synthetic */ Iterable $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                @NotNull
                public Iterator<IndexableEntity> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public Object keyOf(Object element) {
                    IndexableEntity it = (IndexableEntity)element;
                    boolean bl = false;
                    String string = it.getId().intern();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intern(...)");
                    return string;
                }
            }));
            VirtualFilePointer fileId = this.getFileId(file);
            Pair<String, Integer>[] pairArray = this.fileIdToEntityCounts.get(fileId);
            if (pairArray == null) {
                int $i$f$emptyArray = 0;
                pairArray = new Pair[]{};
            }
            Pair<String, Integer>[] oldEntityCounts = pairArray;
            for (Map.Entry $i$f$emptyArray : entityCounts.entrySet()) {
                Pair<String, Integer> pair;
                int n2;
                int count;
                Pair<String, Integer> entityId;
                block11: {
                    entityId = (Pair<String, Integer>)$i$f$emptyArray.getKey();
                    count = ((Number)$i$f$emptyArray.getValue()).intValue();
                    Pair<String, Integer>[] pairArray2 = oldEntityCounts;
                    n = pairArray2.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        Pair<String, Integer> pair2;
                        Pair<String, Integer> it = pair2 = pairArray2[n2];
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getFirst(), entityId)) continue;
                        pair = pair2;
                        break block11;
                    }
                    pair = null;
                }
                if (count <= (oldCount = pair != null ? ((Number)pair.getSecond()).intValue() : 0)) continue;
                FileContentBasedEmbeddingsStorage<E> $this$inferEntityDiff_u24lambda_u248_u24lambda_u245 = this.getStorage();
                boolean bl3 = false;
                n2 = count - oldCount;
                n = 0;
                while (n < n2) {
                    int it = n++;
                    boolean bl4 = false;
                    $this$inferEntityDiff_u24lambda_u248_u24lambda_u245.addEntity(this.getEntity((String)entityId));
                }
            }
            for (Pair<String, Integer> entityId : oldEntityCounts) {
                int count;
                String entityId2 = (String)entityId.component1();
                oldCount = ((Number)entityId.component2()).intValue();
                if (oldCount <= (count = ((Number)entityCounts.getOrDefault(entityId2, 0)).intValue())) continue;
                FileContentBasedEmbeddingsStorage<E> $this$inferEntityDiff_u24lambda_u248_u24lambda_u247 = this.getStorage();
                boolean bl5 = false;
                n = oldCount - count;
                int n3 = 0;
                while (n3 < n) {
                    int it = n3++;
                    boolean bl6 = false;
                    $this$inferEntityDiff_u24lambda_u248_u24lambda_u247.deleteEntity(this.getEntity(entityId2));
                }
            }
            if (entityCounts.isEmpty()) {
                unit2 = this.fileIdToEntityCounts.remove(fileId);
            } else {
                Map<VirtualFilePointer, Pair<String, Integer>[]> map = this.fileIdToEntityCounts;
                Collection $this$toTypedArray$iv = MapsKt.toList((Map)entityCounts);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Pair[] pairArray3 = thisCollection$iv.toArray(new Pair[0]);
                map.put(fileId, pairArray3);
                unit2 = Unit.INSTANCE;
            }
            unit = unit2;
        }
        finally {
            lock.unlock();
        }
        return unit;
    }
}

