/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl;

import com.intellij.debugger.streams.lib.InterpreterFactory;
import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.TraceResultInterpreter;
import com.intellij.debugger.streams.trace.TracingResult;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.TracingResultImpl;
import com.intellij.debugger.streams.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.LongValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class TraceResultInterpreterImpl
implements TraceResultInterpreter {
    private static final Logger LOG = Logger.getInstance(TraceResultInterpreterImpl.class);
    private final InterpreterFactory myInterpreterFactory;

    public TraceResultInterpreterImpl(@NotNull InterpreterFactory interpreterFactory2) {
        if (interpreterFactory2 == null) {
            TraceResultInterpreterImpl.$$$reportNull$$$0(0);
        }
        this.myInterpreterFactory = interpreterFactory2;
    }

    @Override
    @NotNull
    public TracingResult interpret(@NotNull StreamChain chain, @NotNull ArrayReference resultArray) {
        if (chain == null) {
            TraceResultInterpreterImpl.$$$reportNull$$$0(1);
        }
        if (resultArray == null) {
            TraceResultInterpreterImpl.$$$reportNull$$$0(2);
        }
        ArrayReference info = (ArrayReference)resultArray.getValue(0);
        ArrayReference result = (ArrayReference)resultArray.getValue(1);
        Value streamResult2 = result.getValue(0);
        Value time = resultArray.getValue(2);
        TraceResultInterpreterImpl.logTime(time);
        List<TraceInfo> trace = this.getTrace(chain, info);
        return new TracingResultImpl(chain, TraceElementImpl.ofResultValue(streamResult2), trace, TraceResultInterpreterImpl.isException(result));
    }

    @NotNull
    private List<TraceInfo> getTrace(@NotNull StreamChain chain, @NotNull ArrayReference info) {
        if (chain == null) {
            TraceResultInterpreterImpl.$$$reportNull$$$0(3);
        }
        if (info == null) {
            TraceResultInterpreterImpl.$$$reportNull$$$0(4);
        }
        int callCount = chain.length();
        ArrayList<TraceInfo> result = new ArrayList<TraceInfo>(callCount);
        for (int i = 0; i < callCount; ++i) {
            StreamCall call2 = chain.getCall(i);
            Value trace = info.getValue(i);
            CallTraceInterpreter interpreter = this.myInterpreterFactory.getInterpreter(call2.getName());
            TraceInfo traceInfo = trace == null ? ValuesOrderInfo.empty(call2) : interpreter.resolve(call2, trace);
            result.add(traceInfo);
        }
        ArrayList<TraceInfo> arrayList = result;
        if (arrayList == null) {
            TraceResultInterpreterImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static void logTime(@NotNull Value elapsedTimeArray) {
        if (elapsedTimeArray == null) {
            TraceResultInterpreterImpl.$$$reportNull$$$0(6);
        }
        Value elapsedTime = ((ArrayReference)elapsedTimeArray).getValue(0);
        long elapsedNanoseconds = ((LongValue)elapsedTime).value();
        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(elapsedNanoseconds);
        LOG.info("evaluation completed in " + elapsedMillis + "ms");
    }

    private static boolean isException(@NotNull ArrayReference result) {
        ReferenceType type;
        if (result == null) {
            TraceResultInterpreterImpl.$$$reportNull$$$0(7);
        }
        return (type = result.referenceType()) instanceof ArrayType && ((ArrayType)type).componentTypeName().contains("Throwable");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterFactory";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultArray";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/trace/impl/TraceResultInterpreterImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elapsedTimeArray";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/trace/impl/TraceResultInterpreterImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "interpret";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTrace";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "logTime";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isException";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

