/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;

public final class AppMainV2 {
    public static final String LAUNCHER_PORT_NUMBER = "idea.launcher.port";
    public static final String LAUNCHER_BIN_PATH = "idea.launcher.bin.path";

    private static native void triggerControlBreak();

    private static boolean loadHelper(String binPath) {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (osName.startsWith("windows")) {
            File libFile;
            String libName;
            String arch = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
            String string = "x86_64".equals(arch) || "amd64".equals(arch) ? "breakgen64.dll" : ("aarch64".equals(arch) || "arm64".equals(arch) ? "breakgen64a.dll" : (libName = "i386".equals(arch) || "x86".equals(arch) ? "breakgen.dll" : null));
            if (libName != null && (libFile = new File(binPath, libName)).isFile()) {
                System.load(libFile.getAbsolutePath());
                return true;
            }
        }
        return false;
    }

    private static void startMonitor(final int portNumber, final boolean helperLibLoaded) {
        Thread t = new Thread("Monitor Ctrl-Break"){

            @Override
            public void run() {
                try (Socket client = new Socket("127.0.0.1", portNumber);
                     BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream(), "US-ASCII"));){
                    while (true) {
                        String msg;
                        if ((msg = reader.readLine()) == null || "TERM".equals(msg)) {
                            return;
                        }
                        if ("BREAK".equals(msg)) {
                            if (!helperLibLoaded) continue;
                            AppMainV2.triggerControlBreak();
                            continue;
                        }
                        if (!"STOP".equals(msg)) continue;
                        System.exit(1);
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public static void main(String[] args) throws Throwable {
        try {
            boolean helperLibLoaded = AppMainV2.loadHelper(System.getProperty(LAUNCHER_BIN_PATH));
            int portNumber = Integer.parseInt(System.getProperty(LAUNCHER_PORT_NUMBER));
            AppMainV2.startMonitor(portNumber, helperLibLoaded);
        }
        catch (Throwable t) {
            System.err.println("Launcher failed - \"Dump Threads\" and \"Exit\" actions are unavailable (" + t.getMessage() + ')');
        }
        String mainClass = args[0];
        String[] params = Arrays.copyOfRange(args, 1, args.length);
        Class<?> appClass = Class.forName(mainClass);
        Method m = AppMainV2.findMethodToRun(appClass);
        if (m == null) {
            try {
                m = appClass.getMethod("main", String[].class);
            }
            catch (NoSuchMethodException e) {
                if (!AppMainV2.startJavaFXApplication(params, appClass)) {
                    throw new IllegalArgumentException("Main method is not found");
                }
                return;
            }
        }
        if (!Void.TYPE.isAssignableFrom(m.getReturnType())) {
            System.err.println("main method must return a value of type void");
            return;
        }
        try {
            m.setAccessible(true);
            int parameterCount = m.getParameterTypes().length;
            Object objInstance = null;
            if (!Modifier.isStatic(m.getModifiers())) {
                Constructor<?> declaredConstructor;
                try {
                    declaredConstructor = appClass.getDeclaredConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    System.err.println("Non-static main() method was invoked: class must have constructor with no parameters");
                    return;
                }
                declaredConstructor.setAccessible(true);
                objInstance = declaredConstructor.newInstance(new Object[0]);
            }
            if (parameterCount == 0) {
                m.invoke(objInstance, new Object[0]);
            } else {
                m.invoke(objInstance, new Object[]{params});
            }
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private static MainMethodStatus getMainMethodStatus(Method method, boolean staticMode) {
        if ("main".equals(method.getName()) && !Modifier.isPrivate(method.getModifiers()) && staticMode == Modifier.isStatic(method.getModifiers())) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 1 && parameterTypes[0] == String[].class) {
                return MainMethodStatus.WithArgs;
            }
            if (parameterTypes.length == 0) {
                return MainMethodStatus.WithoutArgs;
            }
        }
        return MainMethodStatus.NotMain;
    }

    private static Method findMethodToRun(Class<?> aClass) {
        Method methodWithoutArgsCandidate = null;
        for (Method declaredMethod : aClass.getDeclaredMethods()) {
            Method[] status = AppMainV2.getMainMethodStatus(declaredMethod, true);
            if (status == MainMethodStatus.WithArgs) {
                return declaredMethod;
            }
            if (status != MainMethodStatus.WithoutArgs) continue;
            methodWithoutArgsCandidate = declaredMethod;
        }
        if (methodWithoutArgsCandidate != null) {
            return methodWithoutArgsCandidate;
        }
        ArrayDeque classesToVisit = new ArrayDeque();
        classesToVisit.add(aClass);
        HashSet visited = new HashSet();
        while (!classesToVisit.isEmpty()) {
            Method[] declaredMethods;
            Class last = (Class)classesToVisit.removeLast();
            for (Method method : declaredMethods = last.getDeclaredMethods()) {
                MainMethodStatus status = AppMainV2.getMainMethodStatus(method, false);
                if (status == MainMethodStatus.WithArgs) {
                    return method;
                }
                if (status != MainMethodStatus.WithoutArgs) continue;
                methodWithoutArgsCandidate = method;
            }
            visited.add(aClass);
            Class superclass = last.getSuperclass();
            if (superclass != null) {
                classesToVisit.add(superclass);
            }
            for (Class<?> anInterface : last.getInterfaces()) {
                if (visited.contains(anInterface)) continue;
                classesToVisit.add(anInterface);
            }
        }
        return methodWithoutArgsCandidate;
    }

    private static boolean startJavaFXApplication(String[] params, Class<?> appClass) {
        try {
            Method launchApplication = Class.forName("com.sun.javafx.application.LauncherImpl").getMethod("launchApplication", Class.class, String[].class);
            launchApplication.invoke(null, appClass, params);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void premain(String args) {
        try {
            int p = args.indexOf(58);
            if (p < 0) {
                throw new IllegalArgumentException("incorrect parameter: " + args);
            }
            boolean helperLibLoaded = AppMainV2.loadHelper(args.substring(p + 1));
            int portNumber = Integer.parseInt(args.substring(0, p));
            AppMainV2.startMonitor(portNumber, helperLibLoaded);
        }
        catch (Throwable t) {
            System.err.println("Launcher failed - \"Dump Threads\" and \"Exit\" actions are unavailable (" + t.getMessage() + ')');
        }
    }

    static enum MainMethodStatus {
        NotMain,
        WithArgs,
        WithoutArgs;

    }

    public static final class Agent {
        public static void premain(String args, Instrumentation i) {
            AppMainV2.premain(args);
        }
    }
}

