/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.foldings;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.SmartList;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingInfo;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingInfoKt;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u0000 =2\u00020\u0001:\u0001=B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \u0010\u0004\u001a\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t0\u0005j\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0014J\"\u0010(\u001a\u0004\u0018\u00010\u000f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u0007H\u0014J\u0016\u0010-\u001a\u00020$2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\u0010\u00101\u001a\u00020$2\u0006\u00102\u001a\u000200H\u0016J\u0016\u00103\u001a\u00020$2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\u0018\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u0007H\u0014J\"\u00107\u001a\u0004\u0018\u00010\u000f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u0007H\u0014J\u0016\u00108\u001a\u00020$2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020'0/H\u0014J\u0018\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\bH\u0014J\u0014\u0010<\u001a\u00020$2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020'0/R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR+\u0010\u0004\u001a\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t0\u0005j\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isExpandedCallbackFactory", "Lkotlin/Function0;", "Lkotlin/Function1;", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingInfo;", "", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingExpandedCallback;", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingExpandedCallbackFactory;", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;)V", "_initialized", "allFoldRegions", "", "Lcom/intellij/openapi/editor/FoldRegion;", "getAllFoldRegions", "()[Lcom/intellij/openapi/editor/FoldRegion;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "foldingModel", "Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "getFoldingModel", "()Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "groups", "", "", "Lcom/intellij/openapi/editor/FoldingGroup;", "getGroups", "()Ljava/util/Map;", "()Lkotlin/jvm/functions/Function0;", "isInitialized", "()Z", "lock", "", "addFoldings", "", "newHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "addOrReuseFoldRegion", "start", "", "end", "info", "afterBulkAdd", "highlighters", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterUpdated", "highlighter", "beforeBulkRemove", "canBeReused", "oldRegion", "foldingInfo", "createFoldRegion", "initFoldings", "setExpanded", "region", "expand", "updateCollapsedStates", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendEditorFoldingModelAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendEditorFoldingModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,221:1\n2624#2,3:222\n2624#2,3:225\n766#2:243\n857#2,2:244\n223#2,2:246\n288#2,2:248\n1#3:228\n372#4,7:229\n372#4,7:236\n10#5:250\n*S KotlinDebug\n*F\n+ 1 FrontendEditorFoldingModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter\n*L\n44#1:222,3\n144#1:225,3\n50#1:243\n50#1:244,2\n74#1:246,2\n149#1:248,2\n206#1:229,7\n213#1:236,7\n22#1:250\n*E\n"})
public class FrontendEditorFoldingModelAdapter
implements FrontendMarkupAdapterListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Function0<Function1<FoldingInfo, Boolean>> isExpandedCallbackFactory;
    @NotNull
    private final Map<Long, FoldingGroup> groups;
    @NotNull
    private final FoldingModelImpl foldingModel;
    private boolean _initialized;
    @NotNull
    private final Object lock;
    @NotNull
    private static final Logger logger;

    public FrontendEditorFoldingModelAdapter(@NotNull Editor editor2, @NotNull Function0<? extends Function1<? super FoldingInfo, Boolean>> isExpandedCallbackFactory) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(isExpandedCallbackFactory, (String)"isExpandedCallbackFactory");
        this.editor = editor2;
        this.isExpandedCallbackFactory = isExpandedCallbackFactory;
        this.groups = new LinkedHashMap();
        FoldingModel foldingModel = this.editor.getFoldingModel();
        Intrinsics.checkNotNull((Object)foldingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.FoldingModelImpl");
        this.foldingModel = (FoldingModelImpl)foldingModel;
        this.lock = new Object();
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final Function0<Function1<FoldingInfo, Boolean>> isExpandedCallbackFactory() {
        return this.isExpandedCallbackFactory;
    }

    @NotNull
    protected final Map<Long, FoldingGroup> getGroups() {
        return this.groups;
    }

    @NotNull
    protected final FoldingModelImpl getFoldingModel() {
        return this.foldingModel;
    }

    @NotNull
    public final FoldRegion[] getAllFoldRegions() {
        FoldRegion[] foldRegionArray = this.foldingModel.getAllFoldRegions();
        Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
        return foldRegionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isInitialized() {
        if (this._initialized) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this._initialized;
            return bl2;
        }
    }

    @Override
    public void afterBulkAdd(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
            Iterable $this$none$iv = highlighters;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    RangeHighlighterEx it = (RangeHighlighterEx)element$iv;
                    boolean bl2 = false;
                    if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.afterBulkAdd$lambda$4(this, highlighters));
    }

    protected void addFoldings(@NotNull Collection<? extends RangeHighlighter> newHighlighters) {
        Intrinsics.checkNotNullParameter(newHighlighters, (String)"newHighlighters");
        for (RangeHighlighter rangeHighlighter : newHighlighters) {
            FoldRegion region;
            FoldingInfo info;
            if (FoldingInfoKt.getFoldingInfo(rangeHighlighter) == null || this.addOrReuseFoldRegion(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), info) == null) continue;
            info.getRegions().add((Object)region);
        }
    }

    public final void updateCollapsedStates(@NotNull List<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Function1 isExpandedCallback = (Function1)this.isExpandedCallbackFactory.invoke();
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.updateCollapsedStates$lambda$6(highlighters, isExpandedCallback, this));
    }

    protected void initFoldings(@NotNull List<? extends RangeHighlighter> highlighters) {
        FoldingInfo info;
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        EditorFoldingInfo editorFoldingInfo = EditorFoldingInfo.get((Editor)this.editor);
        Intrinsics.checkNotNullExpressionValue((Object)editorFoldingInfo, (String)"get(...)");
        EditorFoldingInfo regionToPsiMap = editorFoldingInfo;
        Function1 isExpandedCallback = (Function1)this.isExpandedCallbackFactory.invoke();
        FoldRegion[] foldRegionArray = this.foldingModel.getAllFoldRegions();
        Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
        List oldRegions = ArraysKt.toMutableList((Object[])foldRegionArray);
        List newRegions = new ArrayList();
        for (RangeHighlighter rangeHighlighter : highlighters) {
            Intrinsics.checkNotNull((Object)FoldingInfoKt.getFoldingInfo(rangeHighlighter));
            FoldRegion reuseCandidate = this.foldingModel.getFoldRegion(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset());
            if (reuseCandidate != null) {
                if (FoldingInfoKt.isDocComment(info)) {
                    FoldingInfoKt.markAsDocComment(reuseCandidate);
                }
                if (FoldingInfoKt.isDefinition(info)) {
                    FoldingInfoKt.markAsDefinition(reuseCandidate);
                }
                FoldRegion reused = reuseCandidate;
                boolean isExpanded = reused.isExpanded();
                oldRegions.remove(reused);
                if (regionToPsiMap.getPsiElement(reused) != null) {
                    regionToPsiMap.removeRegion(reused);
                    this.foldingModel.removeFoldRegion(reused);
                    FoldRegion foldRegion = this.createFoldRegion(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), info);
                    Intrinsics.checkNotNull((Object)foldRegion);
                    reused = foldRegion;
                }
                if (!this.canBeReused(reused, info)) {
                    this.foldingModel.removeFoldRegion(reused);
                    FoldRegion foldRegion = this.createFoldRegion(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), info);
                    Intrinsics.checkNotNull((Object)foldRegion);
                    reused = foldRegion;
                }
                this.setExpanded(reused, isExpanded);
                info.getRegions().add((Object)reused);
                continue;
            }
            newRegions.add(rangeHighlighter);
        }
        for (FoldRegion foldRegion : oldRegions) {
            if (regionToPsiMap.getPsiElement(foldRegion) != null) continue;
            this.foldingModel.removeFoldRegion(foldRegion);
        }
        for (RangeHighlighter rangeHighlighter : newRegions) {
            FoldRegion newRegion;
            Intrinsics.checkNotNull((Object)FoldingInfoKt.getFoldingInfo(rangeHighlighter));
            if (this.createFoldRegion(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), info) == null) continue;
            info.getRegions().add((Object)newRegion);
            this.setExpanded(newRegion, (Boolean)isExpandedCallback.invoke((Object)info));
        }
    }

    protected void setExpanded(@NotNull FoldRegion region, boolean expand) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        if (region.isExpanded() && !expand) {
            for (Caret caret : this.editor.getCaretModel().getAllCarets()) {
                int offset = caret.getOffset();
                if (offset == 0 || region.getStartOffset() > offset || offset > region.getEndOffset()) continue;
                return;
            }
        }
        region.setExpanded(expand);
    }

    @Override
    public void beforeBulkRemove(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
            Iterable $this$none$iv = highlighters;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    RangeHighlighterEx it = (RangeHighlighterEx)element$iv;
                    boolean bl2 = false;
                    if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.beforeBulkRemove$lambda$9(highlighters, this));
    }

    @Override
    public void afterUpdated(@NotNull RangeHighlighterEx highlighter2) {
        Object v1;
        SmartList<FoldRegion> foldRegions;
        FoldingInfo foldingInfo;
        block4: {
            Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
            FoldingInfo foldingInfo2 = FoldingInfoKt.getFoldingInfo((RangeHighlighter)highlighter2);
            if (foldingInfo2 == null) {
                return;
            }
            foldingInfo = foldingInfo2;
            foldRegions = foldingInfo.getRegions();
            Iterable iterable = (Iterable)foldRegions;
            for (Object t : iterable) {
                FoldRegion it = (FoldRegion)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEditor(), (Object)this.editor)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        FoldRegion foldRegion = v1;
        if (foldRegion == null) {
            return;
        }
        FoldRegion oldRegion = foldRegion;
        if (this.canBeReused(oldRegion, foldingInfo)) {
            return;
        }
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.afterUpdated$lambda$11(oldRegion, foldRegions, this, highlighter2, foldingInfo));
    }

    @Nullable
    protected FoldRegion addOrReuseFoldRegion(int start, int end, @NotNull FoldingInfo info) {
        FoldRegion newRegion;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        FoldRegion existingRegion = this.foldingModel.getFoldRegion(start, end);
        Boolean wasExpanded = null;
        if (existingRegion != null) {
            if (this.canBeReused(existingRegion, info)) {
                if (FoldingInfoKt.isDocComment(info)) {
                    FoldingInfoKt.markAsDocComment(existingRegion);
                }
                if (FoldingInfoKt.isDefinition(info)) {
                    FoldingInfoKt.markAsDefinition(existingRegion);
                }
                return existingRegion;
            }
            wasExpanded = existingRegion.isExpanded();
            this.foldingModel.removeFoldRegion(existingRegion);
        }
        if ((newRegion = this.createFoldRegion(start, end, info)) == null) {
            logger.warn("Unable to insert (" + start + ", " + end + ") in the folding tree");
            return null;
        }
        Boolean bl = wasExpanded;
        newRegion.setExpanded(bl != null ? bl : !info.getCollapsedByDefault());
        return newRegion;
    }

    protected boolean canBeReused(@NotNull FoldRegion oldRegion, @NotNull FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)oldRegion, (String)"oldRegion");
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        if (!Intrinsics.areEqual((Object)oldRegion.getPlaceholderText(), (Object)foldingInfo.getPlaceholderText())) {
            return false;
        }
        FoldingGroup group = oldRegion.getGroup();
        Long groupId = foldingInfo.getGroupId();
        if (group != null && groupId != null) {
            FoldingGroup foldingGroup;
            FoldingGroup foldingGroup2 = group;
            Map<Long, FoldingGroup> $this$getOrPut$iv = this.groups;
            boolean $i$f$getOrPut = false;
            FoldingGroup value$iv = $this$getOrPut$iv.get(groupId);
            if (value$iv == null) {
                FoldingGroup foldingGroup3 = foldingGroup2;
                boolean bl = false;
                foldingGroup2 = foldingGroup3;
                FoldingGroup answer$iv = group;
                $this$getOrPut$iv.put(groupId, answer$iv);
                foldingGroup = answer$iv;
            } else {
                foldingGroup = value$iv;
            }
            return Intrinsics.areEqual((Object)foldingGroup2, (Object)foldingGroup);
        }
        if (oldRegion.shouldNeverExpand() != foldingInfo.getNeverExpands()) {
            return false;
        }
        return group == null && groupId == null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected FoldRegion createFoldRegion(int start, int end, @NotNull FoldingInfo info) {
        FoldRegion region;
        block9: {
            FoldingGroup foldingGroup;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Long l = info.getGroupId();
            if (l != null) {
                Object object;
                void $this$getOrPut$iv;
                long it = ((Number)l).longValue();
                boolean bl = false;
                Map<Long, FoldingGroup> map = this.groups;
                Long key$iv = it;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    FoldingGroup foldingGroup2 = FoldingGroup.newGroup((String)String.valueOf(it));
                    Intrinsics.checkNotNullExpressionValue((Object)foldingGroup2, (String)"newGroup(...)");
                    FoldingGroup answer$iv = foldingGroup2;
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                foldingGroup = (FoldingGroup)object;
            } else {
                foldingGroup = null;
            }
            FoldingGroup group = foldingGroup;
            region = this.foldingModel.createFoldRegion(start, end, info.getPlaceholderText(), group, info.getNeverExpands());
            if (FoldingInfoKt.isDocComment(info)) {
                FoldRegion foldRegion = region;
                if (foldRegion != null) {
                    FoldingInfoKt.markAsDocComment(foldRegion);
                }
            }
            if (FoldingInfoKt.isDefinition(info)) {
                FoldRegion foldRegion = region;
                if (foldRegion != null) {
                    FoldingInfoKt.markAsDefinition(foldRegion);
                }
            }
            if (!FoldingInfoKt.isCodeBlock(info)) break block9;
            FoldRegion foldRegion = region;
            if (foldRegion != null) {
                FoldingInfoKt.markAsCodeBlock(foldRegion);
            }
        }
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void afterBulkAdd$lambda$4(FrontendEditorFoldingModelAdapter this$0, List $highlighters) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$highlighters, (String)"$highlighters");
        if (this$0._initialized) {
            this$0.addFoldings($highlighters);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $highlighters;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RangeHighlighterEx it = (RangeHighlighterEx)element$iv$iv;
                boolean bl = false;
                if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List newHighlighters = (List)destination$iv$iv;
            if (!((Collection)newHighlighters).isEmpty()) {
                Object object = this$0.lock;
                synchronized (object) {
                    boolean bl = false;
                    this$0.initFoldings(newHighlighters);
                    this$0._initialized = true;
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }

    private static final void updateCollapsedStates$lambda$6(List $highlighters, Function1 $isExpandedCallback, FrontendEditorFoldingModelAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)$highlighters, (String)"$highlighters");
        Intrinsics.checkNotNullParameter((Object)$isExpandedCallback, (String)"$isExpandedCallback");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (RangeHighlighter h : $highlighters) {
            Object element$iv2;
            FoldingInfo info;
            block2: {
                Intrinsics.checkNotNull((Object)FoldingInfoKt.getFoldingInfo(h));
                Iterable $this$first$iv = (Iterable)info.getRegions();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    FoldRegion it = (FoldRegion)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getEditor(), (Object)this$0.editor)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            FoldRegion region = (FoldRegion)element$iv2;
            region.setExpanded(((Boolean)$isExpandedCallback.invoke((Object)info)).booleanValue());
        }
    }

    private static final void beforeBulkRemove$lambda$9(List $highlighters, FrontendEditorFoldingModelAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)$highlighters, (String)"$highlighters");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (RangeHighlighterEx h : $highlighters) {
            FoldRegion region;
            Object v0;
            SmartList<FoldRegion> foldRegions;
            FoldingInfo foldingInfo;
            block3: {
                if (FoldingInfoKt.getFoldingInfo((RangeHighlighter)h) == null) continue;
                foldRegions = foldingInfo.getRegions();
                Iterable $this$firstOrNull$iv = (Iterable)foldRegions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FoldRegion it = (FoldRegion)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getEditor(), (Object)this$0.editor)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((FoldRegion)v0 == null) continue;
            foldRegions.remove((Object)region);
            if (!region.isValid()) continue;
            FoldingGroup group = region.getGroup();
            if (group != null && this$0.foldingModel.getGroupedRegions(group).size() == 1) {
                Map<Long, FoldingGroup> map = this$0.groups;
                Long l = foldingInfo.getGroupId();
                TypeIntrinsics.asMutableMap(map).remove(l);
            }
            this$0.foldingModel.removeFoldRegion(region);
        }
    }

    private static final void afterUpdated$lambda$11(FoldRegion $oldRegion, SmartList $foldRegions, FrontendEditorFoldingModelAdapter this$0, RangeHighlighterEx $highlighter, FoldingInfo $foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)$oldRegion, (String)"$oldRegion");
        Intrinsics.checkNotNullParameter((Object)$foldRegions, (String)"$foldRegions");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$highlighter, (String)"$highlighter");
        Intrinsics.checkNotNullParameter((Object)$foldingInfo, (String)"$foldingInfo");
        boolean isExpanded = $oldRegion.isExpanded();
        $foldRegions.remove((Object)$oldRegion);
        this$0.foldingModel.removeFoldRegion($oldRegion);
        FoldRegion foldRegion = this$0.createFoldRegion($highlighter.getStartOffset(), $highlighter.getEndOffset(), $foldingInfo);
        Intrinsics.checkNotNull((Object)foldRegion);
        FoldRegion newRegion = foldRegion;
        newRegion.setExpanded(isExpanded);
        $foldRegions.add((Object)newRegion);
    }

    @NotNull
    protected static final Logger getLogger() {
        return Companion.getLogger();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendEditorFoldingModelAdapter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendEditorFoldingModelAdapter.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        protected static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

