/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorChooserService;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.intellij.images.editor.actionSystem.ImageEditorActionUtil;
import org.intellij.images.ui.ImageComponentDecorator;
import org.jetbrains.annotations.NotNull;

public class ChangeBackgroundAction
extends DumbAwareAction {
    private final MyBackgroundIcon myIcon = new MyBackgroundIcon();

    public ChangeBackgroundAction() {
        this.getTemplatePresentation().setIcon((Icon)this.myIcon);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeBackgroundAction.$$$reportNull$$$0(0);
        }
        final Component component = e.getInputEvent().getComponent();
        final ImageComponentDecorator decorator = ImageEditorActionUtil.getImageComponentDecorator(e);
        if (component != null && decorator != null) {
            ColorChooserService.getInstance().showPopup(e.getProject(), null, null, new ColorListener(){

                public void colorChanged(Color color, Object source) {
                    ChangeBackgroundAction.this.myIcon.color = color;
                    component.repaint();
                    decorator.setEditorBackground(color);
                }
            });
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeBackgroundAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(Registry.is((String)"ide.images.change.background.action.enabled", (boolean)false));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChangeBackgroundAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/images/editor/actions/ChangeBackgroundAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/images/editor/actions/ChangeBackgroundAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class MyBackgroundIcon
    implements Icon {
        Color color = JBColor.background();

        private MyBackgroundIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(this.color);
            g.fillOval(x + 1, y + 1, 14, 14);
            g.setColor(ColorUtil.isDark((Color)this.color) ? Gray.xFF.withAlpha(80) : Gray.x00.withAlpha(80));
            g.drawOval(x + 1, y + 1, 14, 14);
            config.restore();
        }

        @Override
        public int getIconWidth() {
            return JBUI.scale((int)16);
        }

        @Override
        public int getIconHeight() {
            return JBUI.scale((int)16);
        }
    }
}

