/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.markdown;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.run.ShConfigurationType;
import com.intellij.sh.run.ShRunner;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.io.BaseOutputReader;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.MarkdownRunner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShMarkdownRunner
implements MarkdownRunner {
    public boolean isApplicable(Language language) {
        return language != null && language.is(ShLanguage.INSTANCE);
    }

    public boolean run(@NotNull String command, @NotNull Project project, @Nullable String workingDirectory, @NotNull Executor executor) {
        ShRunner shRunner;
        if (command == null) {
            ShMarkdownRunner.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ShMarkdownRunner.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            ShMarkdownRunner.$$$reportNull$$$0(2);
        }
        if ((shRunner = (ShRunner)ApplicationManager.getApplication().getService(ShRunner.class)) != null && shRunner.isAvailable(project)) {
            shRunner.run(project, command, workingDirectory, "RunMarkdown", true);
        }
        return true;
    }

    @NotNull
    public String title() {
        String string = ShBundle.message("sh.markdown.runner.title", new Object[0]);
        if (string == null) {
            ShMarkdownRunner.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static DefaultExecutionResult runInTerminal(String command, String workingDirectory, Project project) throws ExecutionException {
        GeneralCommandLine commandLine = ShMarkdownRunner.createCommandLineForScript(project, workingDirectory, command);
        ProcessHandler processHandler = ShMarkdownRunner.createProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        TerminalExecutionConsole console = new TerminalExecutionConsole(project, processHandler);
        console.attachToProcess(processHandler);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler);
    }

    @NotNull
    private static GeneralCommandLine createCommandLineForScript(Project project, String workingDirectory, String command) {
        PtyCommandLine commandLine = new PtyCommandLine();
        commandLine.withConsoleMode(false);
        commandLine.withInitialColumns(120);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.setWorkDirectory(workingDirectory);
        commandLine.withExePath(ShConfigurationType.getDefaultShell(project));
        commandLine.withParameters(new String[]{"-c"});
        commandLine.withParameters(new String[]{command});
        PtyCommandLine ptyCommandLine = commandLine;
        if (ptyCommandLine == null) {
            ShMarkdownRunner.$$$reportNull$$$0(4);
        }
        return ptyCommandLine;
    }

    @NotNull
    private static ProcessHandler createProcessHandler(GeneralCommandLine commandLine) throws ExecutionException {
        return new KillableProcessHandler(commandLine){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.forTerminalPtyProcess();
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sh/markdown/ShMarkdownRunner$1", "readerOptions"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/markdown/ShMarkdownRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/markdown/ShMarkdownRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "title";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLineForScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

