/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyDependentReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrOperatorExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrNumericBinaryExpressionTypeCalculator;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyIndexPropertyUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReferenceBase;
import org.jetbrains.plugins.groovy.lang.resolve.api.JustTypeArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.LazyTypeArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.UnknownArgument;
import org.jetbrains.plugins.groovy.lang.resolve.impl.CallReferenceImplKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001cB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u001e\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrOperatorReference;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyMethodCallReferenceBase;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrOperatorExpression;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyDependentReference;", "element", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrOperatorExpression;)V", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "getArguments", "()Ljava/util/List;", "methodName", "", "getMethodName", "()Ljava/lang/String;", "receiverArgument", "getReceiverArgument", "()Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "collectDependencies", "", "Lcom/intellij/psi/PsiPolyVariantReference;", "computePutAtArguments", "lValue", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrIndexProperty;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrAssignmentExpression;", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "Companion", "intellij.groovy.psi"})
public final class GrOperatorReference
extends GroovyMethodCallReferenceBase<GrOperatorExpression>
implements GroovyDependentReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<IElementType, String> binaryOperatorMethodNames;

    public GrOperatorReference(@NotNull GrOperatorExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = ((GrOperatorExpression)this.getElement()).getOperationToken().getTextRangeInParent();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRangeInParent(...)");
        return textRange;
    }

    @Override
    @Nullable
    public Argument getReceiverArgument() {
        GrExpression grExpression;
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        GrOperatorExpression element = (GrOperatorExpression)psiElement;
        if (element instanceof GrBinaryExpression) {
            grExpression = ((GrBinaryExpression)element).getLeftOperand();
        } else if (element instanceof GrAssignmentExpression) {
            GrExpression grExpression2 = ((GrAssignmentExpression)element).getLValue();
            Intrinsics.checkNotNullExpressionValue((Object)grExpression2, (String)"getLValue(...)");
            GrExpression lValue = grExpression2;
            grExpression = lValue instanceof GrIndexProperty ? ((GrIndexProperty)lValue).getInvokedExpression() : lValue;
        } else {
            return null;
        }
        GrExpression grExpression3 = grExpression;
        Intrinsics.checkNotNull((Object)grExpression3);
        GrExpression operand = grExpression3;
        return new ExpressionArgument(operand);
    }

    @Override
    @NotNull
    public String getMethodName() {
        String string;
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        GrOperatorExpression element = (GrOperatorExpression)psiElement;
        if (element instanceof GrAssignmentExpression && ((GrAssignmentExpression)element).getLValue() instanceof GrIndexProperty) {
            string = "putAt";
        } else {
            string = binaryOperatorMethodNames.get(element.getOperator());
            if (string == null) {
                String string2 = element.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                String string3 = string2;
                throw new IllegalStateException(string3.toString());
            }
        }
        return string;
    }

    @Override
    @NotNull
    public List<Argument> getArguments() {
        GrExpression grExpression;
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        GrOperatorExpression element = (GrOperatorExpression)psiElement;
        if (element instanceof GrBinaryExpression) {
            grExpression = ((GrBinaryExpression)element).getRightOperand();
        } else if (element instanceof GrAssignmentExpression) {
            GrExpression grExpression2 = ((GrAssignmentExpression)element).getLValue();
            Intrinsics.checkNotNullExpressionValue((Object)grExpression2, (String)"getLValue(...)");
            GrExpression lValue = grExpression2;
            if (lValue instanceof GrIndexProperty) {
                return this.computePutAtArguments((GrIndexProperty)lValue, (GrAssignmentExpression)element);
            }
            grExpression = ((GrAssignmentExpression)element).getRValue();
        } else {
            grExpression = null;
        }
        GrExpression operand = grExpression;
        Argument argument = operand == null ? (Argument)UnknownArgument.INSTANCE : (Argument)new ExpressionArgument(operand);
        return CollectionsKt.listOf((Object)argument);
    }

    private final List<Argument> computePutAtArguments(GrIndexProperty lValue, GrAssignmentExpression element) {
        Argument key = GroovyIndexPropertyUtil.getArgumentListArgument(lValue);
        LazyTypeArgument value2 = new LazyTypeArgument((Function0<? extends PsiType>)((Function0)new Function0<PsiType>(element, lValue){
            final /* synthetic */ GrAssignmentExpression $element;
            final /* synthetic */ GrIndexProperty $lValue;
            {
                this.$element = $element;
                this.$lValue = $lValue;
                super(0);
            }

            @Nullable
            public final PsiType invoke() {
                Argument argument;
                GrExpression grExpression;
                Argument leftOperand;
                String string = (String)GrOperatorReference.access$getBinaryOperatorMethodNames$cp().get(this.$element.getOperator());
                if (string == null) {
                    return null;
                }
                String actualMethodName = string;
                PsiType psiType = this.$lValue.getType();
                if (psiType != null) {
                    PsiType p0 = psiType;
                    boolean bl = false;
                    v2 = new JustTypeArgument(p0);
                } else {
                    v2 = leftOperand = (Argument)UnknownArgument.INSTANCE;
                }
                if ((grExpression = this.$element.getRValue()) != null && (grExpression = grExpression.getType()) != null) {
                    GrExpression p0 = grExpression;
                    boolean bl = false;
                    argument = new JustTypeArgument((PsiType)p0);
                } else {
                    argument = UnknownArgument.INSTANCE;
                }
                Argument rightOperand = argument;
                GroovyResolveResult groovyResolveResult = (GroovyResolveResult)CollectionsKt.singleOrNull(CallReferenceImplKt.resolveWithArguments(leftOperand, actualMethodName, CollectionsKt.listOf((Object)rightOperand), this.$element));
                if (groovyResolveResult == null) {
                    return null;
                }
                GroovyResolveResult resolveResult2 = groovyResolveResult;
                GrExpression grExpression2 = this.$element.getRValue();
                PsiType rt = GrNumericBinaryExpressionTypeCalculator.INSTANCE.getTypeByResult(this.$lValue.getType(), (PsiType)(grExpression2 != null ? grExpression2.getType() : null), CollectionsKt.listOf((Object)rightOperand), resolveResult2, this.$element);
                return rt;
            }
        }));
        Object[] objectArray = new Argument[]{key, value2};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Collection<? extends PsiPolyVariantReference> collectDependencies() {
        SmartList result2 = new SmartList();
        ((GrOperatorExpression)this.getElement()).accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((SmartList<PsiPolyVariantReference>)result2){
            final /* synthetic */ SmartList<PsiPolyVariantReference> $result;
            {
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element) {
                GrExpression operand;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof GrOperatorExpression) {
                    super.visitElement(element);
                } else if (element instanceof GrParenthesizedExpression && (operand = ((GrParenthesizedExpression)element).getOperand()) != null) {
                    super.visitElement((PsiElement)operand);
                }
            }

            protected void elementFinished(@NotNull PsiElement element) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Object object = element instanceof GrOperatorExpression ? (GrOperatorExpression)element : null;
                    if (object == null || (object = object.getReference()) == null) break block0;
                    Object object2 = object;
                    SmartList<PsiPolyVariantReference> smartList = this.$result;
                    Object it = object2;
                    boolean bl = false;
                    smartList.add(it);
                }
            }
        });
        return (Collection)result2;
    }

    @JvmStatic
    public static final boolean hasOperatorReference(@NotNull GrOperatorExpression expression) {
        return Companion.hasOperatorReference(expression);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)GroovyElementTypes.T_PLUS, (Object)"plus"), TuplesKt.to((Object)GroovyElementTypes.T_MINUS, (Object)"minus"), TuplesKt.to((Object)GroovyElementTypes.T_DIV, (Object)"div"), TuplesKt.to((Object)GroovyElementTypes.T_STAR, (Object)"multiply"), TuplesKt.to((Object)GroovyElementTypes.T_REM, (Object)"mod"), TuplesKt.to((Object)GroovyElementTypes.T_POW, (Object)"power"), TuplesKt.to((Object)GroovyElementTypes.T_BAND, (Object)"and"), TuplesKt.to((Object)GroovyElementTypes.T_BOR, (Object)"or"), TuplesKt.to((Object)GroovyElementTypes.T_XOR, (Object)"xor"), TuplesKt.to((Object)((Object)GroovyElementTypes.LEFT_SHIFT_SIGN), (Object)"leftShift"), TuplesKt.to((Object)((Object)GroovyElementTypes.RIGHT_SHIFT_SIGN), (Object)"rightShift"), TuplesKt.to((Object)((Object)GroovyElementTypes.RIGHT_SHIFT_UNSIGNED_SIGN), (Object)"rightShiftUnsigned"), TuplesKt.to((Object)GroovyElementTypes.T_EQ, (Object)"equals"), TuplesKt.to((Object)GroovyElementTypes.T_NEQ, (Object)"equals"), TuplesKt.to((Object)GroovyElementTypes.T_LT, (Object)"compareTo"), TuplesKt.to((Object)GroovyElementTypes.T_LE, (Object)"compareTo"), TuplesKt.to((Object)GroovyElementTypes.T_GT, (Object)"compareTo"), TuplesKt.to((Object)GroovyElementTypes.T_GE, (Object)"compareTo"), TuplesKt.to((Object)GroovyElementTypes.T_COMPARE, (Object)"compareTo")};
        binaryOperatorMethodNames = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\"\u0010\u0003\u001a\u0016\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrOperatorReference$Companion;", "", "()V", "binaryOperatorMethodNames", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "", "hasOperatorReference", "", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrOperatorExpression;", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean hasOperatorReference(@NotNull GrOperatorExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            return binaryOperatorMethodNames.containsKey(expression.getOperator());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

