/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.MissingMethodAndPropertyUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(@NotNull PsiElement element) {
        GrParameter parameter;
        PsiElement scope;
        if (element == null) {
            GrImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof GrMethod) {
            GrMethod method = (GrMethod)element;
            if (PsiUtil.OPERATOR_METHOD_NAMES.contains(method.getName())) {
                return true;
            }
            if (MissingMethodAndPropertyUtil.isPropertyMissing(method)) {
                return true;
            }
            if (MissingMethodAndPropertyUtil.isMethodMissing(method)) {
                return true;
            }
            if (GrImplicitUsageProvider.isDelegateAnnotated(method)) {
                return true;
            }
        } else if (element instanceof GrParameter && (scope = (parameter = (GrParameter)element).getDeclarationScope()) instanceof GrMethod && (MissingMethodAndPropertyUtil.isMethodMissing((GrMethod)scope) || MissingMethodAndPropertyUtil.isPropertyMissing((GrMethod)scope))) {
            return true;
        }
        return false;
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            GrImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return element instanceof GrField && GrImplicitUsageProvider.isDelegateAnnotated((PsiModifierListOwner)((GrField)element));
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            GrImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return false;
    }

    private static boolean isDelegateAnnotated(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            GrImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        return PsiImplUtil.getAnnotation(owner, "groovy.lang.Delegate") != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/findUsages/GrImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isDelegateAnnotated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

