/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.GdslMethod;
import org.jetbrains.plugins.groovy.dsl.GdslType;
import org.jetbrains.plugins.groovy.dsl.GdslUtil;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.toplevel.ClassContextFilter;

public abstract class DslPointcut<T, V> {
    public static final DslPointcut UNKNOWN = new DslPointcut(){

        List matches(Object src, ProcessingContext context) {
            return Collections.emptyList();
        }

        @Override
        boolean operatesOn(Class c) {
            return true;
        }
    };
    public static Key<Map<String, List>> BOUND = Key.create((String)"gdsl.bound");

    @Nullable
    abstract List<V> matches(T var1, ProcessingContext var2);

    abstract boolean operatesOn(Class var1);

    public DslPointcut<T, V> and(final DslPointcut<T, V> next) {
        final DslPointcut first = this;
        return new DslPointcut<T, V>(){

            @Override
            List<V> matches(T src, ProcessingContext context) {
                List vs1 = first.matches(src, context);
                if (vs1 == null) {
                    return null;
                }
                List vs2 = next.matches(src, context);
                if (vs2 == null) {
                    return null;
                }
                ArrayList result2 = new ArrayList(vs1);
                result2.retainAll(new HashSet(vs2));
                return result2;
            }

            @Override
            boolean operatesOn(Class c) {
                return first.operatesOn(c) && next.operatesOn(c);
            }
        };
    }

    public DslPointcut<T, V> or(final DslPointcut<T, V> next) {
        final DslPointcut first = this;
        return new DslPointcut<T, V>(){

            @Override
            List<V> matches(T src, ProcessingContext context) {
                List vs1 = first.matches(src, context);
                List vs2 = next.matches(src, context);
                if (vs1 == null && vs2 == null) {
                    return null;
                }
                LinkedHashSet result2 = new LinkedHashSet();
                if (vs1 != null) {
                    result2.addAll(vs1);
                }
                if (vs2 != null) {
                    result2.addAll(vs2);
                }
                return new ArrayList(result2);
            }

            @Override
            boolean operatesOn(Class c) {
                return first.operatesOn(c) && next.operatesOn(c);
            }
        };
    }

    public DslPointcut<T, V> bitwiseNegate() {
        final DslPointcut base = this;
        return new DslPointcut<T, V>(){

            @Override
            List<V> matches(T src, ProcessingContext context) {
                return base.matches(src, context) == null ? Collections.emptyList() : null;
            }

            @Override
            boolean operatesOn(Class c) {
                return base.operatesOn(c);
            }
        };
    }

    public static DslPointcut<GdslType, GdslType> subType(final Object arg) {
        return new DslPointcut<GdslType, GdslType>(){

            @Override
            List<GdslType> matches(GdslType src, ProcessingContext context) {
                PsiFile placeFile = ((GroovyClassDescriptor)context.get(GdslUtil.INITIAL_CONTEXT)).justGetPlaceFile();
                if (ClassContextFilter.isSubtype(src.psiType, placeFile, (String)arg)) {
                    return Collections.singletonList(src);
                }
                return null;
            }

            @Override
            boolean operatesOn(Class c) {
                return GdslType.class == c;
            }
        };
    }

    public static DslPointcut<GroovyClassDescriptor, GdslType> currentType(Object arg) {
        DslPointcut inner;
        if (arg instanceof String) {
            inner = DslPointcut.subType(arg);
        } else {
            inner = (DslPointcut)arg;
            assert (inner.operatesOn(GdslType.class)) : "The argument to currentType should be a pointcut working with types, e.g. subType";
        }
        return new DslPointcut<GroovyClassDescriptor, GdslType>(){

            @Override
            List<GdslType> matches(GroovyClassDescriptor src, ProcessingContext context) {
                GdslType currentType = new GdslType(src.getPsiType());
                if (inner.matches(currentType, context) != null) {
                    return Collections.singletonList(currentType);
                }
                return null;
            }

            @Override
            boolean operatesOn(Class c) {
                return GroovyClassDescriptor.class == c;
            }
        };
    }

    public static DslPointcut<GroovyClassDescriptor, GdslType> enclosingType(final Object arg) {
        return new DslPointcut<GroovyClassDescriptor, GdslType>(){

            @Override
            List<GdslType> matches(GroovyClassDescriptor src, ProcessingContext context) {
                PsiClass cls;
                ArrayList<GdslType> result2 = new ArrayList<GdslType>();
                PsiElement place = src.getPlace();
                while ((cls = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{PsiClass.class})) != null) {
                    if (arg.equals(cls.getQualifiedName())) {
                        result2.add(new GdslType((PsiType)JavaPsiFacade.getElementFactory((Project)cls.getProject()).createType(cls)));
                    }
                    place = cls;
                }
                return result2.isEmpty() ? null : result2;
            }

            @Override
            boolean operatesOn(Class c) {
                return GroovyClassDescriptor.class == c;
            }
        };
    }

    public static DslPointcut<Object, String> name(final Object arg) {
        return new DslPointcut<Object, String>(){

            @Override
            List<String> matches(Object src, ProcessingContext context) {
                if (src instanceof GdslType) {
                    return arg.equals(((GdslType)src).getName()) ? Collections.singletonList((String)arg) : null;
                }
                if (src instanceof GdslMethod) {
                    return arg.equals(((GdslMethod)src).getName()) ? Collections.singletonList((String)arg) : null;
                }
                return Collections.emptyList();
            }

            @Override
            boolean operatesOn(Class c) {
                return c == GdslType.class || c == GdslMethod.class;
            }
        };
    }

    public static DslPointcut<GroovyClassDescriptor, GdslMethod> enclosingMethod(Object arg) {
        DslPointcut inner;
        if (arg instanceof String) {
            inner = DslPointcut.name(arg);
        } else {
            inner = (DslPointcut)arg;
            assert (inner.operatesOn(GdslMethod.class)) : "The argument to enclosingMethod should be a pointcut working with methods, e.g. name";
        }
        return new DslPointcut<GroovyClassDescriptor, GdslMethod>(){

            @Override
            List<GdslMethod> matches(GroovyClassDescriptor src, ProcessingContext context) {
                PsiMethod method;
                ArrayList<GdslMethod> result2 = new ArrayList<GdslMethod>();
                PsiElement place = src.getPlace();
                while ((method = (PsiMethod)PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{PsiMethod.class})) != null) {
                    GdslMethod wrapper = new GdslMethod(method);
                    if (inner.matches(wrapper, context) != null) {
                        result2.add(wrapper);
                    }
                    place = method;
                }
                return result2.isEmpty() ? null : result2;
            }

            @Override
            boolean operatesOn(Class c) {
                return GroovyClassDescriptor.class == c;
            }
        };
    }

    public static DslPointcut bind(Object arg) {
        assert (arg instanceof Map);
        assert (((Map)arg).size() == 1);
        final String name = (String)((Map)arg).keySet().iterator().next();
        final DslPointcut pct = (DslPointcut)((Map)arg).values().iterator().next();
        return new DslPointcut(){

            List matches(Object src, ProcessingContext context) {
                List result2 = pct.matches(src, context);
                if (result2 != null) {
                    HashMap map2 = (HashMap)context.get(BOUND);
                    if (map2 == null) {
                        map2 = new HashMap();
                        context.put(BOUND, map2);
                    }
                    map2.put(name, result2);
                }
                return result2;
            }

            @Override
            boolean operatesOn(Class c) {
                return pct.operatesOn(c);
            }
        };
    }
}

