/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config.wizard;

import com.intellij.CommonBundle;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.projectWizard.NewProjectWizardCollector;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.wizard.NewProjectWizardStep;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.distribution.DistributionComboBox;
import com.intellij.openapi.roots.ui.distribution.DistributionInfo;
import com.intellij.openapi.roots.ui.distribution.FileChooserInfo;
import com.intellij.openapi.roots.ui.distribution.LocalDistributionInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.validation.RequestorsKt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.download.DownloadableFileSetVersions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyDownloadableLibraryTypeKt;
import org.jetbrains.plugins.groovy.config.GroovyLibraryDescription;
import org.jetbrains.plugins.groovy.config.wizard.BuildSystemGroovyNewProjectWizardData;
import org.jetbrains.plugins.groovy.config.wizard.FrameworkLibraryDistributionInfo;
import org.jetbrains.plugins.groovy.config.wizard.GroovyProjectWizardUtils;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0012\u0010\u000b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u001a\u001a\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0014\u0010\u0018\u001a\u00020\u0012*\u00020\u00192\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u0014\u0010\u001a\u001a\u00020\u0012*\u00020\u00192\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a%\u0010\u001b\u001a\u00020\u0012\"\f\b\u0000\u0010\u001c*\u00020\u0019*\u00020\u001d*\u0002H\u001c2\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 \u001a\u0018\u0010!\u001a\u0004\u0018\u00010\"*\u00020#2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0018\u0010$\u001a\u0004\u0018\u00010\"*\u00020#2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"GROOVY_SDK_FALLBACK_VERSION", "", "MAIN_FILE", "MAIN_GROOVY_TEMPLATE", "getGroovySdkType", "sdk", "Lcom/intellij/openapi/roots/ui/distribution/DistributionInfo;", "getGroovySdkVersion", "isBlankDistribution", "", "distribution", "isInvalidSdk", "moveUnstableVersionToTheEnd", "", "left", "Lcom/intellij/framework/library/FrameworkLibraryVersion;", "right", "createSampleGroovyCodeFile", "", "Lcom/intellij/ide/util/projectWizard/ModuleBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "sourceDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "logGroovySdkChanged", "Lcom/intellij/ide/wizard/NewProjectWizardStep;", "logGroovySdkFinished", "setupGroovySdkUI", "S", "Lorg/jetbrains/plugins/groovy/config/wizard/BuildSystemGroovyNewProjectWizardData;", "builder", "Lcom/intellij/ui/dsl/builder/Panel;", "(Lcom/intellij/ide/wizard/NewProjectWizardStep;Lcom/intellij/ui/dsl/builder/Panel;)V", "validateGroovySdk", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "validateGroovySdkWithDialog", "intellij.groovy"})
@JvmName(name="GroovyProjectWizardUtils")
public final class GroovyProjectWizardUtils {
    @NotNull
    public static final String GROOVY_SDK_FALLBACK_VERSION = "3.0.9";
    @NotNull
    private static final String MAIN_FILE = "Main.groovy";
    @NotNull
    private static final String MAIN_GROOVY_TEMPLATE = "template.groovy";

    public static final <S extends NewProjectWizardStep & BuildSystemGroovyNewProjectWizardData> void setupGroovySdkUI(@NotNull S $this$setupGroovySdkUI, @NotNull Panel builder) {
        Intrinsics.checkNotNullParameter($this$setupGroovySdkUI, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        GroovyLibraryDescription groovyLibraryDescription = new GroovyLibraryDescription();
        DistributionComboBox comboBox2 = new DistributionComboBox($this$setupGroovySdkUI.getContext().getProject(), new FileChooserInfo(groovyLibraryDescription){
            @NotNull
            private final String fileChooserTitle;
            @Nullable
            private final String fileChooserDescription;
            @NotNull
            private final FileChooserDescriptor fileChooserDescriptor;
            @NotNull
            private final Function1<Macro, Boolean> fileChooserMacroFilter;
            {
                String string = GroovyBundle.message("dialog.title.select.groovy.sdk", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.fileChooserTitle = string;
                FileChooserDescriptor fileChooserDescriptor = $groovyLibraryDescription.createFileChooserDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"createFileChooserDescriptor(...)");
                this.fileChooserDescriptor = fileChooserDescriptor;
                this.fileChooserMacroFilter = FileChooserInfo.Companion.getDIRECTORY_PATH();
            }

            @NotNull
            public String getFileChooserTitle() {
                return this.fileChooserTitle;
            }

            @Nullable
            public String getFileChooserDescription() {
                return this.fileChooserDescription;
            }

            @NotNull
            public FileChooserDescriptor getFileChooserDescriptor() {
                return this.fileChooserDescriptor;
            }

            @NotNull
            public Function1<Macro, Boolean> getFileChooserMacroFilter() {
                return this.fileChooserMacroFilter;
            }
        });
        String string = GroovyBundle.message("dialog.title.specify.groovy.sdk", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        comboBox2.setSpecifyLocationActionName(string);
        comboBox2.addLoadingItem();
        VirtualFile pathToGroovyHome = groovyLibraryDescription.findPathToGroovyHome();
        if (pathToGroovyHome != null) {
            String string2 = pathToGroovyHome.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            comboBox2.addDistributionIfNotExists((DistributionInfo)new LocalDistributionInfo(string2));
        }
        GroovyDownloadableLibraryTypeKt.loadLatestGroovyVersions((DownloadableFileSetVersions.FileSetVersionsCallback<FrameworkLibraryVersion>)((DownloadableFileSetVersions.FileSetVersionsCallback)new DownloadableFileSetVersions.FileSetVersionsCallback<FrameworkLibraryVersion>(comboBox2){
            final /* synthetic */ DistributionComboBox $comboBox;
            {
                this.$comboBox = $comboBox;
            }

            public void onSuccess(@NotNull List<? extends FrameworkLibraryVersion> versions) {
                Intrinsics.checkNotNullParameter(versions, (String)"versions");
                SwingUtilities.invokeLater(() -> setupGroovySdkUI.1.onSuccess$lambda$1(versions, this.$comboBox));
            }

            public void onError(@NotNull String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                this.$comboBox.removeLoadingItem();
            }

            private static final int onSuccess$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return ((Number)$tmp0.invoke(p0, p1)).intValue();
            }

            /*
             * WARNING - void declaration
             */
            private static final void onSuccess$lambda$1(List $versions, DistributionComboBox $comboBox) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$versions, (String)"$versions");
                Intrinsics.checkNotNullParameter((Object)$comboBox, (String)"$comboBox");
                Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$versions, (arg_0, arg_1) -> setupGroovySdkUI.1.onSuccess$lambda$1$lambda$0(setupGroovySdkUI.onSuccess.1.1.INSTANCE, arg_0, arg_1));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    FrameworkLibraryVersion frameworkLibraryVersion = (FrameworkLibraryVersion)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new FrameworkLibraryDistributionInfo((FrameworkLibraryVersion)p0));
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    DistributionInfo p0 = (DistributionInfo)element$iv;
                    boolean bl = false;
                    $comboBox.addDistributionIfNotExists(p0);
                }
                $comboBox.removeLoadingItem();
            }
        }));
        String string3 = GroovyBundle.message("label.groovy.sdk", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        builder.row(string3, (Function1)new Function1<Row, Unit>(comboBox2, $this$setupGroovySdkUI){
            final /* synthetic */ DistributionComboBox $comboBox;
            final /* synthetic */ S $this_setupGroovySdkUI;
            {
                this.$comboBox = $comboBox;
                this.$this_setupGroovySdkUI = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                ComboBoxKt.whenItemSelectedFromUi$default((Cell)ComboBoxKt.columns((Cell)$this$row.cell((JComponent)this.$comboBox).applyToComponent((Function1)new Function1<DistributionComboBox, Unit>(this.$this_setupGroovySdkUI){
                    final /* synthetic */ S $this_setupGroovySdkUI;
                    {
                        this.$this_setupGroovySdkUI = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull DistributionComboBox $this$applyToComponent) {
                        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                        $this$applyToComponent.bindSelectedDistribution((ObservableMutableProperty)((BuildSystemGroovyNewProjectWizardData)this.$this_setupGroovySdkUI).getGroovySdkProperty());
                    }
                }).validationRequestor(RequestorsKt.getWHEN_PROPERTY_CHANGED().invoke(((BuildSystemGroovyNewProjectWizardData)this.$this_setupGroovySdkUI).getGroovySdkProperty())).validationOnInput((Function2)new Function2<ValidationInfoBuilder, DistributionComboBox, ValidationInfo>(this.$this_setupGroovySdkUI){
                    final /* synthetic */ S $this_setupGroovySdkUI;
                    {
                        this.$this_setupGroovySdkUI = $receiver;
                        super(2);
                    }

                    @Nullable
                    public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnInput, @NotNull DistributionComboBox it) {
                        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return GroovyProjectWizardUtils.access$validateGroovySdk($this$validationOnInput, ((BuildSystemGroovyNewProjectWizardData)this.$this_setupGroovySdkUI).getGroovySdk());
                    }
                }).validationOnApply((Function2)new Function2<ValidationInfoBuilder, DistributionComboBox, ValidationInfo>(this.$this_setupGroovySdkUI){
                    final /* synthetic */ S $this_setupGroovySdkUI;
                    {
                        this.$this_setupGroovySdkUI = $receiver;
                        super(2);
                    }

                    @Nullable
                    public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull DistributionComboBox it) {
                        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return GroovyProjectWizardUtils.access$validateGroovySdkWithDialog($this$validationOnApply, ((BuildSystemGroovyNewProjectWizardData)this.$this_setupGroovySdkUI).getGroovySdk());
                    }
                }), (int)25), null, (Function1)((Function1)new Function1<DistributionComboBox.Item, Unit>(this.$this_setupGroovySdkUI){
                    final /* synthetic */ S $this_setupGroovySdkUI;
                    {
                        this.$this_setupGroovySdkUI = $receiver;
                        super(1);
                    }

                    public final void invoke(DistributionComboBox.Item it) {
                        GroovyProjectWizardUtils.logGroovySdkChanged(this.$this_setupGroovySdkUI, ((BuildSystemGroovyNewProjectWizardData)this.$this_setupGroovySdkUI).getGroovySdk());
                    }
                }), (int)1, null);
            }
        }).bottomGap(BottomGap.SMALL);
    }

    private static final ValidationInfo validateGroovySdk(ValidationInfoBuilder $this$validateGroovySdk, DistributionInfo distribution) {
        if (GroovyProjectWizardUtils.isBlankDistribution(distribution)) {
            String string = GroovyBundle.message("dialog.title.validation.path.should.not.be.empty", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return $this$validateGroovySdk.error(string);
        }
        if (GroovyProjectWizardUtils.isInvalidSdk(distribution)) {
            String string = GroovyBundle.message("dialog.title.validation.path.does.not.contain.groovy.sdk", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return $this$validateGroovySdk.error(string);
        }
        return null;
    }

    private static final ValidationInfo validateGroovySdkWithDialog(ValidationInfoBuilder $this$validateGroovySdkWithDialog, DistributionInfo distribution) {
        String[] stringArray;
        if (GroovyProjectWizardUtils.isBlankDistribution(distribution)) {
            stringArray = new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()};
            if (Messages.showDialog((String)GroovyBundle.message("dialog.title.no.jdk.specified.prompt", new Object[0]), (String)GroovyBundle.message("dialog.title.no.jdk.specified.title", new Object[0]), (String[])stringArray, (int)1, (Icon)Messages.getWarningIcon()) != 0) {
                String string = GroovyBundle.message("dialog.title.no.jdk.specified.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return $this$validateGroovySdkWithDialog.error(string);
            }
        }
        if (GroovyProjectWizardUtils.isInvalidSdk(distribution)) {
            stringArray = new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()};
            if (Messages.showDialog((String)GroovyBundle.message("dialog.title.validation.directory.you.specified.does.not.contain.groovy.sdk.do.you.want.to.create.project.with.this.configuration", new Object[0]), (String)GroovyBundle.message("dialog.title.validation.invalid.sdk.specified.title", new Object[0]), (String[])stringArray, (int)1, (Icon)Messages.getWarningIcon()) != 0) {
                String string = GroovyBundle.message("dialog.title.validation.invalid.sdk.specified.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return $this$validateGroovySdkWithDialog.error(string);
            }
        }
        return null;
    }

    private static final boolean isBlankDistribution(DistributionInfo distribution) {
        return distribution == null || distribution instanceof LocalDistributionInfo && Intrinsics.areEqual((Object)((LocalDistributionInfo)distribution).getPath(), (Object)"");
    }

    private static final boolean isInvalidSdk(DistributionInfo distribution) {
        return distribution == null || distribution instanceof LocalDistributionInfo && GroovyConfigUtils.getInstance().getSDKVersionOrNull(((LocalDistributionInfo)distribution).getPath()) == null;
    }

    public static final void createSampleGroovyCodeFile(@NotNull ModuleBuilder $this$createSampleGroovyCodeFile, @NotNull Project project, @NotNull VirtualFile sourceDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$createSampleGroovyCodeFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceDirectory, (String)"sourceDirectory");
        WriteCommandAction.runWriteCommandAction((Project)project, (String)GroovyBundle.message("new.project.wizard.groovy.creating.main.file", new Object[0]), null, () -> GroovyProjectWizardUtils.createSampleGroovyCodeFile$lambda$0(project, sourceDirectory, $this$createSampleGroovyCodeFile), (PsiFile[])new PsiFile[0]);
    }

    public static final int moveUnstableVersionToTheEnd(@NotNull FrameworkLibraryVersion left, @NotNull FrameworkLibraryVersion right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        String string = left.getVersionString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersionString(...)");
        String leftVersion = string;
        String string2 = right.getVersionString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVersionString(...)");
        String rightVersion = string2;
        boolean leftUnstable = GroovyConfigUtils.isUnstable(leftVersion);
        boolean rightUnstable = GroovyConfigUtils.isUnstable(rightVersion);
        return leftUnstable == rightUnstable ? -GroovyConfigUtils.compareSdkVersions(leftVersion, rightVersion) : (leftUnstable ? 1 : -1);
    }

    public static final void logGroovySdkChanged(@NotNull NewProjectWizardStep $this$logGroovySdkChanged, @Nullable DistributionInfo sdk) {
        Intrinsics.checkNotNullParameter((Object)$this$logGroovySdkChanged, (String)"<this>");
        String type2 = GroovyProjectWizardUtils.getGroovySdkType(sdk);
        String version = GroovyProjectWizardUtils.getGroovySdkVersion(sdk);
        NewProjectWizardCollector.Groovy.INSTANCE.logGroovyLibraryChanged($this$logGroovySdkChanged, type2, version);
    }

    public static final void logGroovySdkFinished(@NotNull NewProjectWizardStep $this$logGroovySdkFinished, @Nullable DistributionInfo sdk) {
        Intrinsics.checkNotNullParameter((Object)$this$logGroovySdkFinished, (String)"<this>");
        String type2 = GroovyProjectWizardUtils.getGroovySdkType(sdk);
        String version = GroovyProjectWizardUtils.getGroovySdkVersion(sdk);
        NewProjectWizardCollector.Groovy.INSTANCE.logGroovyLibraryFinished($this$logGroovySdkFinished, type2, version);
    }

    private static final String getGroovySdkType(DistributionInfo sdk) {
        String string;
        DistributionInfo distributionInfo = sdk;
        if (distributionInfo instanceof FrameworkLibraryDistributionInfo) {
            string = "Maven";
        } else if (distributionInfo instanceof LocalDistributionInfo) {
            string = "Local";
        } else if (distributionInfo == null) {
            string = "None";
        } else {
            throw new IllegalStateException(("Unexpected distribution type: " + sdk).toString());
        }
        return string;
    }

    private static final String getGroovySdkVersion(DistributionInfo sdk) {
        String string;
        DistributionInfo distributionInfo = sdk;
        if (distributionInfo instanceof FrameworkLibraryDistributionInfo) {
            string = ((FrameworkLibraryDistributionInfo)sdk).getVersion().getVersionString();
        } else if (distributionInfo instanceof LocalDistributionInfo) {
            string = GroovyConfigUtils.getInstance().getSDKVersionOrNull(((LocalDistributionInfo)sdk).getPath());
        } else if (distributionInfo == null) {
            string = null;
        } else {
            throw new IllegalStateException(("Unexpected distribution type: " + sdk).toString());
        }
        return string;
    }

    private static final void createSampleGroovyCodeFile$lambda$0(Project $project, VirtualFile $sourceDirectory, ModuleBuilder $this_createSampleGroovyCodeFile) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$sourceDirectory, (String)"$sourceDirectory");
        Intrinsics.checkNotNullParameter((Object)$this_createSampleGroovyCodeFile, (String)"$this_createSampleGroovyCodeFile");
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)$project).getCodeTemplate(MAIN_GROOVY_TEMPLATE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getCodeTemplate(...)");
        FileTemplate fileTemplate2 = fileTemplate;
        VirtualFile virtualFile = $sourceDirectory.createChildData((Object)$this_createSampleGroovyCodeFile, MAIN_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createChildData(...)");
        VirtualFile helloWorldFile = virtualFile;
        VfsUtil.saveText((VirtualFile)helloWorldFile, (String)fileTemplate2.getText());
    }

    public static final /* synthetic */ ValidationInfo access$validateGroovySdk(ValidationInfoBuilder $receiver, DistributionInfo distribution) {
        return GroovyProjectWizardUtils.validateGroovySdk($receiver, distribution);
    }

    public static final /* synthetic */ ValidationInfo access$validateGroovySdkWithDialog(ValidationInfoBuilder $receiver, DistributionInfo distribution) {
        return GroovyProjectWizardUtils.validateGroovySdkWithDialog($receiver, distribution);
    }
}

