/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GrCastFix
extends GroovyFix {
    private final PsiType myExpectedType;
    private final boolean mySafe;
    @NotNull
    private final SmartPsiElementPointer<GrExpression> pointer;
    @NotNull
    @IntentionName
    private final String myName;

    public GrCastFix(PsiType expectedType, GrExpression expression) {
        this(expectedType, expression, true);
    }

    public GrCastFix(PsiType expectedType, GrExpression expression, boolean safe) {
        this(expectedType, expression, safe, GroovyBundle.message("intention.name.cast.to.0", expectedType.getPresentableText()));
    }

    public GrCastFix(PsiType expectedType, GrExpression expression, boolean safe, @NotNull @IntentionName String name) {
        if (name == null) {
            GrCastFix.$$$reportNull$$$0(0);
        }
        this.mySafe = safe;
        this.myName = name;
        this.myExpectedType = PsiImplUtil.normalizeWildcardTypeByPosition(expectedType, expression);
        this.pointer = SmartPointerManager.getInstance((Project)expression.getProject()).createSmartPsiElementPointer((PsiElement)expression);
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
        GrExpression expression;
        if (project == null) {
            GrCastFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            GrCastFix.$$$reportNull$$$0(2);
        }
        if ((expression = (GrExpression)this.pointer.getElement()) == null) {
            return;
        }
        if (this.mySafe) {
            GrCastFix.doSafeCast(project, this.myExpectedType, expression);
        } else {
            GrCastFix.doCast(project, this.myExpectedType, expression);
        }
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        GrExpression expression;
        if (target == null) {
            GrCastFix.$$$reportNull$$$0(3);
        }
        if ((expression = (GrExpression)this.pointer.getElement()) == null) {
            return null;
        }
        GrExpression copiedExpression = (GrExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)expression, (PsiFile)target);
        return new GrCastFix(this.myExpectedType, copiedExpression, this.mySafe, this.myName);
    }

    private static void doCast(Project project, PsiType type2, GrExpression expr) {
        if (!type2.isValid()) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrTypeCastExpression cast = (GrTypeCastExpression)factory.createExpressionFromText("(String)foo");
        GrTypeElement typeElement = factory.createTypeElement(type2);
        GrExpression operand = cast.getOperand();
        if (operand == null) {
            return;
        }
        operand.replaceWithExpression(expr, true);
        cast.getCastTypeElement().replace(typeElement);
        GrExpression replaced = expr.replaceWithExpression(cast, true);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replaced);
    }

    @ApiStatus.Internal
    public static void doSafeCast(@NotNull Project project, @NotNull PsiType type2, @NotNull GrExpression expr) {
        if (project == null) {
            GrCastFix.$$$reportNull$$$0(4);
        }
        if (type2 == null) {
            GrCastFix.$$$reportNull$$$0(5);
        }
        if (expr == null) {
            GrCastFix.$$$reportNull$$$0(6);
        }
        if (!type2.isValid()) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrSafeCastExpression cast = (GrSafeCastExpression)factory.createExpressionFromText("foo as String");
        GrTypeElement typeElement = factory.createTypeElement(type2);
        cast.getOperand().replaceWithExpression(expr, true);
        GrTypeElement castTypeElement = cast.getCastTypeElement();
        if (castTypeElement != null) {
            castTypeElement.replace(typeElement);
        }
        GrExpression replaced = expr.replaceWithExpression(cast, true);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replaced);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GrCastFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("intention.family.name.add.cast", new Object[0]);
        if (string == null) {
            GrCastFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/assignment/GrCastFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/assignment/GrCastFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doSafeCast";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

