/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.lang.jvm.actions.CreateConstantActionGroup;
import com.intellij.lang.jvm.actions.CreateFieldActionGroup;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.JvmActionGroup;
import com.intellij.lang.jvm.actions.JvmGroupIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateFieldActionBase;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.GroovyFieldRenderer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreateFieldAction;", "Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreateFieldActionBase;", "Lcom/intellij/lang/jvm/actions/JvmGroupIntentionAction;", "target", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "constantField", "", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;Lcom/intellij/lang/jvm/actions/CreateFieldRequest;Z)V", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getActionGroup", "Lcom/intellij/lang/jvm/actions/JvmActionGroup;", "getText", "", "invoke", "", "intellij.groovy"})
public final class CreateFieldAction
extends CreateFieldActionBase
implements JvmGroupIntentionAction {
    private final boolean constantField;

    public CreateFieldAction(@NotNull GrTypeDefinition target, @NotNull CreateFieldRequest request, boolean constantField) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(target, request);
        this.constantField = constantField;
    }

    @NotNull
    public JvmActionGroup getActionGroup() {
        return this.constantField ? (JvmActionGroup)CreateConstantActionGroup.INSTANCE : (JvmActionGroup)CreateFieldActionGroup.INSTANCE;
    }

    @NotNull
    public String getText() {
        String string = this.getRequest().getFieldName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFieldName(...)");
        String what = string;
        String where = ClassPresentationUtil.getNameForClass((PsiClass)this.getTarget(), (boolean)false);
        String message = this.constantField ? "intention.name.create.constant.field.in.class" : "intention.name.create.field.in.class";
        Object[] objectArray = new Object[]{what, where};
        String string2 = GroovyBundle.message(message, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GrField field = new GroovyFieldRenderer(project, this.constantField, this.getTarget(), this.getRequest()).renderField();
        GrTypeDefinition grTypeDefinition = (GrTypeDefinition)this.getMyTargetPointer().getElement();
        String className = grTypeDefinition != null ? grTypeDefinition.getName() : null;
        return (IntentionPreviewInfo)new IntentionPreviewInfo.CustomDiff((FileType)GroovyFileType.GROOVY_FILE_TYPE, className, "", field.getText());
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        new GroovyFieldRenderer(project, this.constantField, this.getTarget(), this.getRequest()).doRender();
    }
}

