/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.openapi.project.Project;
import com.intellij.troubleshooting.TroubleInfoCollector;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Display;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.LogicalVolumeGroup;
import oshi.hardware.NetworkIF;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.VirtualMemory;
import oshi.software.os.FileSystem;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSFileStore;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;
import oshi.util.Util;

public class HardwareCollector
implements TroubleInfoCollector {
    final List<String> info = new ArrayList<String>();

    @NotNull
    public String collectInfo(@NotNull Project project) {
        if (project == null) {
            HardwareCollector.$$$reportNull$$$0(0);
        }
        String string = this.collectHardwareInfo();
        if (string == null) {
            HardwareCollector.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String collectHardwareInfo() {
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hal = si.getHardware();
        OperatingSystem os = si.getOperatingSystem();
        this.info.add("=====OS SUMMARY=====\n");
        this.printOperatingSystem(os);
        this.printComputerSystem(hal.getComputerSystem());
        this.info.add("\n=====CPU SUMMARY=====\n");
        this.printProcessor(hal.getProcessor());
        this.printCpu(hal.getProcessor());
        this.info.add("\n=====MEMORY SUMMARY=====\n");
        this.printMemory(hal.getMemory());
        this.info.add("\n=====PROCESSES SUMMARY=====\n");
        this.printProcesses(os, hal.getMemory());
        this.info.add("\n=====FILESYSTEM SUMMARY=====\n");
        this.printDisks(hal.getDiskStores());
        this.printLVgroups(hal.getLogicalVolumeGroups());
        this.printFileSystem(os.getFileSystem());
        this.info.add("\n=====NETWORK SUMMARY=====\n");
        this.printNetworkInterfaces(hal.getNetworkIFs());
        this.printNetworkParameters(os.getNetworkParams());
        this.info.add("\n=====GRAPHICS SUMMARY=====\n");
        this.printDisplays(hal.getDisplays());
        this.printGraphicsCards(hal.getGraphicsCards());
        StringBuilder output = new StringBuilder();
        for (String s : this.info) {
            output.append(s);
            if (s == null || s.endsWith("\n")) continue;
            output.append('\n');
        }
        return output.toString();
    }

    private void printOperatingSystem(OperatingSystem os) {
        this.info.add(String.valueOf(os));
        this.info.add("Booted: " + Instant.ofEpochSecond(os.getSystemBootTime()));
        this.info.add("Uptime: " + FormatUtil.formatElapsedSecs(os.getSystemUptime()));
        this.info.add("Running with" + (os.isElevated() ? "" : "out") + " elevated permissions.");
    }

    private void printComputerSystem(ComputerSystem computerSystem) {
        this.info.add("System: " + computerSystem.toString());
    }

    private void printProcessor(CentralProcessor processor) {
        this.info.add(processor.toString());
        this.info.add(" Cores:");
        for (CentralProcessor.PhysicalProcessor p : processor.getPhysicalProcessors()) {
            this.info.add("  " + p.getPhysicalProcessorNumber() + ": efficiency=" + p.getEfficiency() + ", id=" + p.getIdString());
        }
    }

    private void printMemory(GlobalMemory memory) {
        this.info.add("Physical Memory: \n " + memory.toString());
        VirtualMemory vm = memory.getVirtualMemory();
        this.info.add("Virtual Memory: \n " + vm.toString());
        List<PhysicalMemory> pmList = memory.getPhysicalMemory();
        if (!pmList.isEmpty()) {
            this.info.add("Physical Memory: ");
            for (PhysicalMemory pm : pmList) {
                this.info.add(" " + pm.toString());
            }
        }
    }

    private void printCpu(CentralProcessor processor) {
        long[] freqs;
        double[] load;
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        long[][] prevProcTicks = processor.getProcessorCpuLoadTicks();
        Util.sleep(1000L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long sys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
        this.info.add(String.format("User: %.1f%% Nice: %.1f%% System: %.1f%% Idle: %.1f%% IOwait: %.1f%% IRQ: %.1f%% SoftIRQ: %.1f%% Steal: %.1f%%", 100.0 * (double)user / (double)totalCpu, 100.0 * (double)nice / (double)totalCpu, 100.0 * (double)sys / (double)totalCpu, 100.0 * (double)idle / (double)totalCpu, 100.0 * (double)iowait / (double)totalCpu, 100.0 * (double)irq / (double)totalCpu, 100.0 * (double)softirq / (double)totalCpu, 100.0 * (double)steal / (double)totalCpu));
        this.info.add(String.format("CPU load: %.1f%%", processor.getSystemCpuLoadBetweenTicks(prevTicks) * 100.0));
        double[] loadAverage = processor.getSystemLoadAverage(3);
        this.info.add("CPU load averages:" + (loadAverage[0] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[0])) + (loadAverage[1] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[1])) + (loadAverage[2] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[2])));
        StringBuilder procCpu = new StringBuilder("CPU load per processor:");
        for (double avg : load = processor.getProcessorCpuLoadBetweenTicks(prevProcTicks)) {
            procCpu.append(String.format(" %.1f%%", avg * 100.0));
        }
        this.info.add(procCpu.toString());
        long freq = processor.getProcessorIdentifier().getVendorFreq();
        if (freq > 0L) {
            this.info.add("Vendor Frequency: " + FormatUtil.formatHertz(freq));
        }
        if ((freq = processor.getMaxFreq()) > 0L) {
            this.info.add("Max Frequency: " + FormatUtil.formatHertz(freq));
        }
        if ((freqs = processor.getCurrentFreq())[0] > 0L) {
            StringBuilder sb = new StringBuilder("Current Frequencies: ");
            for (int i = 0; i < freqs.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(FormatUtil.formatHertz(freqs[i]));
            }
            this.info.add(sb.toString());
        }
    }

    private void printProcesses(OperatingSystem os, GlobalMemory memory) {
        OSProcess myProc = os.getProcess(os.getProcessId());
        if (myProc == null) {
            return;
        }
        this.info.add("My PID: " + myProc.getProcessID() + " with affinity " + Long.toBinaryString(myProc.getAffinityMask()));
        this.info.add("Processes: " + os.getProcessCount() + ", Threads: " + os.getThreadCount());
        List<OSProcess> procs = os.getProcesses(OperatingSystem.ProcessFiltering.ALL_PROCESSES, OperatingSystem.ProcessSorting.CPU_DESC, 5);
        this.info.add("   PID  %CPU %MEM       VSZ       RSS Name");
        for (int i = 0; i < procs.size() && i < 5; ++i) {
            OSProcess p = procs.get(i);
            this.info.add(String.format(" %5d %5.1f %4.1f %9s %9s %s", p.getProcessID(), 100.0 * (double)(p.getKernelTime() + p.getUserTime()) / (double)p.getUpTime(), 100.0 * (double)p.getResidentSetSize() / (double)memory.getTotal(), FormatUtil.formatBytes(p.getVirtualSize()), FormatUtil.formatBytes(p.getResidentSetSize()), p.getName()));
        }
        OSProcess p = os.getProcess(os.getProcessId());
        this.info.add("Current process environment: ");
        for (Map.Entry<String, String> e : p.getEnvironmentVariables().entrySet()) {
            this.info.add("  " + e.getKey() + "=" + e.getValue());
        }
    }

    private void printDisks(List<HWDiskStore> list) {
        this.info.add("Disks:");
        for (HWDiskStore disk : list) {
            this.info.add(" " + disk.toString());
            List<HWPartition> partitions = disk.getPartitions();
            for (HWPartition part : partitions) {
                this.info.add(" |-- " + part.toString());
            }
        }
    }

    private void printLVgroups(List<LogicalVolumeGroup> list) {
        if (!list.isEmpty()) {
            this.info.add("Logical Volume Groups:");
            for (LogicalVolumeGroup lvg : list) {
                this.info.add(" " + lvg.toString());
            }
        }
    }

    private void printFileSystem(FileSystem fileSystem) {
        this.info.add("File System:");
        this.info.add(String.format(" File Descriptors: %d/%d", fileSystem.getOpenFileDescriptors(), fileSystem.getMaxFileDescriptors()));
        for (OSFileStore fs : fileSystem.getFileStores()) {
            long usable = fs.getUsableSpace();
            long total = fs.getTotalSpace();
            this.info.add(String.format(" %s (%s) [%s] %s of %s free (%.1f%%), %s of %s files free (%.1f%%) is %s " + (fs.getLogicalVolume() != null && fs.getLogicalVolume().length() > 0 ? "[%s]" : "%s") + " and is mounted at %s", fs.getName(), fs.getDescription().isEmpty() ? "file system" : fs.getDescription(), fs.getType(), FormatUtil.formatBytes(usable), FormatUtil.formatBytes(fs.getTotalSpace()), 100.0 * (double)usable / (double)total, FormatUtil.formatValue(fs.getFreeInodes(), ""), FormatUtil.formatValue(fs.getTotalInodes(), ""), 100.0 * (double)fs.getFreeInodes() / (double)fs.getTotalInodes(), fs.getVolume(), fs.getLogicalVolume(), fs.getMount()));
        }
    }

    private void printNetworkInterfaces(List<NetworkIF> list) {
        StringBuilder sb = new StringBuilder("Network Interfaces:");
        if (list.isEmpty()) {
            sb.append(" Unknown");
        } else {
            for (NetworkIF net : list) {
                if (net.getIfAlias() == null) continue;
                sb.append("\n ").append(net);
            }
        }
        this.info.add(sb.toString());
    }

    private void printNetworkParameters(NetworkParams networkParams) {
        this.info.add("Network parameters:\n " + networkParams.toString());
    }

    private void printDisplays(List<Display> list) {
        this.info.add("Displays:");
        int i = 0;
        for (Display display : list) {
            this.info.add(" Display " + i + ":");
            this.info.add(String.valueOf(display));
            ++i;
        }
    }

    private void printGraphicsCards(List<GraphicsCard> list) {
        this.info.add("Graphics Cards:");
        if (list.isEmpty()) {
            this.info.add(" None detected.");
        } else {
            for (GraphicsCard card : list) {
                this.info.add(" " + card);
            }
        }
    }

    public String toString() {
        return "Hardware";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/utils/HardwareCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/utils/HardwareCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

