/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.lang.IJPerfLanguage;
import com.jetbrains.performancePlugin.lang.psi.IJPerfFile;
import org.jetbrains.annotations.NotNull;

public class IJPerfStartStopProfileInspection
implements Annotator {
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        if (element2 == null) {
            IJPerfStartStopProfileInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            IJPerfStartStopProfileInspection.$$$reportNull$$$0(1);
        }
        if (!(element2 instanceof IJPerfFile)) {
            return;
        }
        PsiElement startCommand = null;
        PsiElement @NotNull [] children = element2.getChildren();
        for (int i = 0; i <= children.length; ++i) {
            if (i == children.length) {
                IJPerfStartStopProfileInspection.checkAndRegisterUnclosedProblem(startCommand, holder);
                break;
            }
            PsiElement currentPsiElement = children[i];
            if (currentPsiElement.getText().startsWith("%startProfile")) {
                IJPerfStartStopProfileInspection.checkAndRegisterUnclosedProblem(startCommand, holder);
                IJPerfStartStopProfileInspection.checkAndRegisterRepeatProblem(startCommand, currentPsiElement, holder);
                startCommand = currentPsiElement;
                continue;
            }
            if (!currentPsiElement.getText().startsWith("%stopProfile")) continue;
            startCommand = null;
        }
    }

    private static void checkAndRegisterUnclosedProblem(PsiElement startCommand, AnnotationHolder holder) {
        if (startCommand != null) {
            holder.newAnnotation(HighlightSeverity.WARNING, PerformanceTestingBundle.message("inspection.message.activity.started.but.never.closed.with.stopprofile", startCommand.getText())).range(startCommand).withFix((IntentionAction)new AddStopCommandFix()).create();
        }
    }

    private static void checkAndRegisterRepeatProblem(PsiElement prevStartCommand, PsiElement curStartCommand, AnnotationHolder holder) {
        if (prevStartCommand != null && curStartCommand != null) {
            holder.newAnnotation(HighlightSeverity.ERROR, PerformanceTestingBundle.message("inspection.message.two.startprofile.commands.cant.follow.each.other", curStartCommand.getText())).range(curStartCommand).withFix((IntentionAction)new AddStopCommandFix()).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/performancePlugin/lang/inspections/IJPerfStartStopProfileInspection";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddStopCommandFix
    extends BaseIntentionAction {
        private AddStopCommandFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PerformanceTestingBundle.message("intention.add.stopcommand", new Object[0]);
            if (string == null) {
                AddStopCommandFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = PerformanceTestingBundle.message("intention.add.stopcommand", new Object[0]);
            if (string == null) {
                AddStopCommandFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                AddStopCommandFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                AddStopCommandFix.$$$reportNull$$$0(3);
            }
            file.addBefore(AddStopCommandFix.createCRLF(project), file.add(AddStopCommandFix.createStopCommand(project)));
        }

        private static IJPerfFile createFile(Project project, String text2) {
            return (IJPerfFile)PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.ijperf", (Language)IJPerfLanguage.INSTANCE, (CharSequence)text2);
        }

        private static PsiElement createStopCommand(Project project) {
            return AddStopCommandFix.createFile(project, "%stopProfile").getFirstChild();
        }

        private static PsiElement createCRLF(Project project) {
            return AddStopCommandFix.createFile(project, "\n").getFirstChild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/performancePlugin/lang/inspections/IJPerfStartStopProfileInspection$AddStopCommandFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/performancePlugin/lang/inspections/IJPerfStartStopProfileInspection$AddStopCommandFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

