/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.PlaybackCommandCoroutineAdapter;
import com.jetbrains.performancePlugin.commands.CompletionCommand;
import com.jetbrains.performancePlugin.utils.DataDumper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lcom/jetbrains/performancePlugin/commands/AssertCompletionCommand;", "Lcom/intellij/openapi/ui/playback/commands/PlaybackCommandCoroutineAdapter;", "text", "", "line", "", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nAssertCompletionCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssertCompletionCommand.kt\ncom/jetbrains/performancePlugin/commands/AssertCompletionCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n819#2:61\n847#2,2:62\n1963#2,14:64\n1549#2:78\n1620#2,3:79\n*S KotlinDebug\n*F\n+ 1 AssertCompletionCommand.kt\ncom/jetbrains/performancePlugin/commands/AssertCompletionCommand\n*L\n29#1:61\n29#1:62,2\n34#1:64,14\n51#1:78\n51#1:79,3\n*E\n"})
public final class AssertCompletionCommand
extends PlaybackCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%assertCompletionCommand";
    @NotNull
    private static final String EXIST = "EXIST";
    @NotNull
    private static final String COUNT = "COUNT";
    @NotNull
    private static final String CONTAINS = "CONTAINS";

    public AssertCompletionCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        Object e$iv;
        Object v0;
        void $this$filterNotTo$iv$iv;
        Path completionItemsDir = CompletionCommand.getCompletionItemsDir();
        String[] stringArray = new String[]{" "};
        Iterable $this$filterNot$iv = StringsKt.split$default((CharSequence)this.extractCommandArgument(PREFIX), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)it)).toString(), (Object)"")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List commandArgs = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        String mode = (String)commandArgs.remove(0);
        if (completionItemsDir == null) {
            throw new IllegalStateException("Completion items dump dir not set");
        }
        Iterable $this$maxByOrNull$iv = PathsKt.listDirectoryEntries$default((Path)completionItemsDir, null, (int)1, null);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Path it = (Path)maxElem$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                FileTime fileTime = Files.getLastModifiedTime(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                Comparable maxValue$iv = fileTime;
                do {
                    e$iv = iterator$iv.next();
                    Path it2 = (Path)e$iv;
                    $i$a$-maxByOrNull-AssertCompletionCommand$doExecute$lastCompletion$1 = false;
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    FileTime fileTime2 = Files.getLastModifiedTime(it2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"getLastModifiedTime(...)");
                    Comparable v$iv = fileTime2;
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Path lastCompletion = v0;
        if (lastCompletion == null) {
            throw new IllegalStateException("No completion data items file found");
        }
        CompletionCommand.CompletionItemsReport completionItemsReport = DataDumper.read(lastCompletion, CompletionCommand.CompletionItemsReport.class);
        Intrinsics.checkNotNullExpressionValue((Object)completionItemsReport, (String)"read(...)");
        CompletionCommand.CompletionItemsReport data = completionItemsReport;
        if (data.totalNumber <= 0) {
            throw new IllegalStateException("Expected > 0 completion variants, but got only " + data.totalNumber);
        }
        switch (mode) {
            case "EXIST": {
                return Unit.INSTANCE;
            }
            case "COUNT": {
                int expected = Integer.parseInt((String)commandArgs.get(0));
                if (data.totalNumber == expected) break;
                throw new IllegalStateException("Expected " + expected + " completion variants, but got " + data.totalNumber);
            }
            case "CONTAINS": {
                void $this$mapTo$iv$iv;
                List<CompletionCommand.CompletionVariant> list = data.items;
                Intrinsics.checkNotNullExpressionValue(list, (String)"items");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                e$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CompletionCommand.CompletionVariant completionVariant = (CompletionCommand.CompletionVariant)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    collection.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                }
                List actual = (List)destination$iv$iv2;
                if (actual.containsAll(commandArgs)) break;
                throw new IllegalStateException("Actual " + actual + " does not contain expected " + commandArgs + " completion variants");
            }
            default: {
                throw new IllegalArgumentException("Specified mode is neither EXIST nor COUNT nor CONTAINS");
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/performancePlugin/commands/AssertCompletionCommand$Companion;", "", "()V", "CONTAINS", "", "COUNT", "EXIST", "PREFIX", "Lorg/jetbrains/annotations/NonNls;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

