/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.indexing.shared.platform.impl.SharedIndexProjectSettings;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.indexing.dependencies.ProjectIndexingDependenciesService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexProjectActivity;", "Lcom/intellij/openapi/startup/StartupActivity$RequiredForSmartMode;", "()V", "attachChunksFromPreviousIDESession", "", "project", "Lcom/intellij/openapi/project/Project;", "runActivity", "Companion", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexProjectActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexProjectActivity.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexProjectActivity\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,55:1\n30#2,3:56\n30#2,3:59\n*S KotlinDebug\n*F\n+ 1 SharedIndexProjectActivity.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexProjectActivity\n*L\n24#1:56,3\n50#1:59,3\n*E\n"})
public final class SharedIndexProjectActivity
implements StartupActivity.RequiredForSmartMode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            this.attachChunksFromPreviousIDESession(project);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable t) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ProjectIndexingDependenciesService> serviceClass$iv = ProjectIndexingDependenciesService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            ((ProjectIndexingDependenciesService)object).requestHeavyScanningOnProjectOpen("Could not attach some shared indexes chunks. Exception: " + t.getMessage());
            throw t;
        }
    }

    private final void attachChunksFromPreviousIDESession(Project project) {
        Set<String> chunks2 = SharedIndexProjectSettings.getInstance((Project)project).getState().attachedChunks;
        if (chunks2.isEmpty()) {
            return;
        }
        List attached = new ArrayList();
        List skipped = new ArrayList();
        for (String chunkId : chunks2) {
            boolean bl = SharedIndexChunkConfiguration.getInstance().attachExistingChunk(project, chunkId);
            if (bl) {
                Intrinsics.checkNotNull((Object)chunkId);
                attached.add(chunkId);
                continue;
            }
            if (bl) continue;
            Intrinsics.checkNotNull((Object)chunkId);
            skipped.add(chunkId);
        }
        if (!((Collection)attached).isEmpty()) {
            LOG.info("Attached " + attached.size() + " shared indexes: " + CollectionsKt.joinToString$default((Iterable)attached, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        if (!((Collection)skipped).isEmpty()) {
            LOG.warn("Skipped " + skipped.size() + " shared indexes: " + CollectionsKt.joinToString$default((Iterable)skipped, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ProjectIndexingDependenciesService> serviceClass$iv = ProjectIndexingDependenciesService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            ((ProjectIndexingDependenciesService)object).requestHeavyScanningOnProjectOpen("Shared indexes could not load " + skipped.size() + " chunks. Invalidate indexing flag in project [" + project.getName() + "] and continue.");
        }
    }

    static {
        Logger logger = Logger.getInstance(SharedIndexProjectActivity.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexProjectActivity$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.indexing.shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

