/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.VMBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MemberBox
implements Serializable {
    static final long serialVersionUID = 6358550398665688245L;
    private transient Member memberObject;
    transient Class<?>[] argTypes;
    transient Object delegateTo;
    transient boolean vararg;
    private static final Class<?>[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    MemberBox(Method method) {
        this.init(method);
    }

    MemberBox(Constructor<?> constructor) {
        this.init(constructor);
    }

    private void init(Method method) {
        this.memberObject = method;
        this.argTypes = method.getParameterTypes();
        this.vararg = VMBridge.instance.isVarArgs(method);
    }

    private void init(Constructor<?> constructor) {
        this.memberObject = constructor;
        this.argTypes = constructor.getParameterTypes();
        this.vararg = VMBridge.instance.isVarArgs(constructor);
    }

    Method method() {
        return (Method)this.memberObject;
    }

    Constructor<?> ctor() {
        return (Constructor)this.memberObject;
    }

    Member member() {
        return this.memberObject;
    }

    boolean isMethod() {
        return this.memberObject instanceof Method;
    }

    boolean isCtor() {
        return this.memberObject instanceof Constructor;
    }

    boolean isStatic() {
        return Modifier.isStatic(this.memberObject.getModifiers());
    }

    String getName() {
        return this.memberObject.getName();
    }

    Class<?> getDeclaringClass() {
        return this.memberObject.getDeclaringClass();
    }

    String toJavaDeclaration() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isMethod()) {
            Method method = this.method();
            stringBuffer.append(method.getReturnType());
            stringBuffer.append(' ');
            stringBuffer.append(method.getName());
        } else {
            Constructor<?> constructor = this.ctor();
            String string = constructor.getDeclaringClass().getName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(JavaMembers.liveConnectSignature(this.argTypes));
        return stringBuffer.toString();
    }

    public String toString() {
        return this.memberObject.toString();
    }

    Object invoke(Object object, Object[] objectArray) {
        Method method = this.method();
        try {
            try {
                return method.invoke(object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                Method method2 = MemberBox.searchAccessibleMethod(method, this.argTypes);
                if (method2 != null) {
                    this.memberObject = method2;
                    method = method2;
                } else if (!VMBridge.instance.tryToMakeAccessible(method)) {
                    throw Context.throwAsScriptRuntimeEx(illegalAccessException);
                }
                return method.invoke(object, objectArray);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException;
            while ((throwable = throwable.getTargetException()) instanceof InvocationTargetException) {
            }
            if (throwable instanceof ContinuationPending) {
                throw (ContinuationPending)throwable;
            }
            throw Context.throwAsScriptRuntimeEx(throwable);
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    Object newInstance(Object[] objectArray) {
        Constructor<?> constructor = this.ctor();
        try {
            try {
                return constructor.newInstance(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!VMBridge.instance.tryToMakeAccessible(constructor)) {
                    throw Context.throwAsScriptRuntimeEx(illegalAccessException);
                }
                return constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    private static Method searchAccessibleMethod(Method method, Class<?>[] classArray) {
        Class<?> clazz;
        int n = method.getModifiers();
        if (Modifier.isPublic(n) && !Modifier.isStatic(n) && !Modifier.isPublic((clazz = method.getDeclaringClass()).getModifiers())) {
            String string = method.getName();
            Class<?>[] classArray2 = clazz.getInterfaces();
            int n2 = 0;
            int n3 = classArray2.length;
            while (n2 != n3) {
                Class<?> clazz2 = classArray2[n2];
                if (Modifier.isPublic(clazz2.getModifiers())) {
                    try {
                        return clazz2.getMethod(string, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {}
                }
                ++n2;
            }
            while ((clazz = clazz.getSuperclass()) != null) {
                if (!Modifier.isPublic(clazz.getModifiers())) continue;
                try {
                    Method method2 = clazz.getMethod(string, classArray);
                    n3 = method2.getModifiers();
                    if (!Modifier.isPublic(n3) || Modifier.isStatic(n3)) continue;
                    return method2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                }
            }
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Member member = MemberBox.readMember(objectInputStream);
        if (member instanceof Method) {
            this.init((Method)member);
        } else {
            this.init((Constructor)member);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        MemberBox.writeMember(objectOutputStream, this.memberObject);
    }

    private static void writeMember(ObjectOutputStream objectOutputStream, Member member) throws IOException {
        if (member == null) {
            objectOutputStream.writeBoolean(false);
            return;
        }
        objectOutputStream.writeBoolean(true);
        if (!(member instanceof Method) && !(member instanceof Constructor)) {
            throw new IllegalArgumentException("not Method or Constructor");
        }
        objectOutputStream.writeBoolean(member instanceof Method);
        objectOutputStream.writeObject(member.getName());
        objectOutputStream.writeObject(member.getDeclaringClass());
        if (member instanceof Method) {
            MemberBox.writeParameters(objectOutputStream, ((Method)member).getParameterTypes());
        } else {
            MemberBox.writeParameters(objectOutputStream, ((Constructor)member).getParameterTypes());
        }
    }

    private static Member readMember(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (!objectInputStream.readBoolean()) {
            return null;
        }
        boolean bl = objectInputStream.readBoolean();
        String string = (String)objectInputStream.readObject();
        Class clazz = (Class)objectInputStream.readObject();
        Class<?>[] classArray = MemberBox.readParameters(objectInputStream);
        try {
            if (bl) {
                return clazz.getMethod(string, classArray);
            }
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("Cannot find member: " + noSuchMethodException);
        }
    }

    private static void writeParameters(ObjectOutputStream objectOutputStream, Class<?>[] classArray) throws IOException {
        objectOutputStream.writeShort(classArray.length);
        int n = 0;
        while (n < classArray.length) {
            block5: {
                Class<?> clazz = classArray[n];
                boolean bl = clazz.isPrimitive();
                objectOutputStream.writeBoolean(bl);
                if (!bl) {
                    objectOutputStream.writeObject(clazz);
                } else {
                    int n2 = 0;
                    while (n2 < primitives.length) {
                        if (clazz.equals(primitives[n2])) {
                            objectOutputStream.writeByte(n2);
                            break block5;
                        }
                        ++n2;
                    }
                    throw new IllegalArgumentException("Primitive " + clazz + " not found");
                }
            }
            ++n;
        }
    }

    private static Class<?>[] readParameters(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class[] classArray = new Class[objectInputStream.readShort()];
        int n = 0;
        while (n < classArray.length) {
            classArray[n] = !objectInputStream.readBoolean() ? (Class)objectInputStream.readObject() : primitives[objectInputStream.readByte()];
            ++n;
        }
        return classArray;
    }
}

