# powerflex_lia

Role to manage the installation and uninstallation of Powerflex LIA.

## Requirements

```
ansible
python
```

## Ansible collections

Collections required to use the role.

```
dellemc.powerflex
```

## Role Variables

<table>
<thead>
  <tr>
    <th>Name</th>
    <th>Required</th>
    <th>Description</th>
    <th>Choices</th>
    <th>Type</th>
    <th>Default Value</th>
  </tr>
</thead>
<tbody>
  <tr>
    <td>hostname</td>
    <td>true</td>
    <td>IP or FQDN of the PowerFlex gateway.</td>
    <td></td>
    <td>str</td>
    <td>10.1.1.1</td>
  </tr>
  <tr>
    <td>username</td>
    <td>true</td>
    <td>The username of the PowerFlex gateway.</td>
    <td></td>
    <td>str</td>
    <td>admin</td>
  </tr>
  <tr>
    <td>password</td>
    <td>true</td>
    <td>The password of the PowerFlex gateway.</td>
    <td></td>
    <td>str</td>
    <td>password</td>
  </tr>
  <tr>
    <td>port</td>
    <td>false</td>
    <td>Port</td>
    <td></td>
    <td>int</td>
    <td>443</td>
  </tr>
  <tr>
    <td>validate_certs</td>
    <td>false</td>
    <td>If C(false), the SSL certificates will not be validated.<br>Configure C(false) only on personally controlled sites where self-signed certificates are used.</td>
    <td></td>
    <td>bool</td>
    <td>false</td>
  </tr>
  <tr>
    <td>timeout</td>
    <td>false</td>
    <td>Timeout</td>
    <td></td>
    <td>int</td>
    <td>120</td>
  </tr>
  <tr>
    <td>powerflex_common_file_install_location</td>
    <td>true</td>
    <td>Location of installation and rpm gpg files to be installed.
    <br>The required, compatible installation software package based on the operating system of the node. The files can be downloaded from the Dell Product support page for PowerFlex software.</td>
    <td></td>
    <td>str</td>
    <td>/var/tmp</td>
  </tr>
  <tr>
    <td>powerflex_lia_token</td>
    <td>true</td>
    <td>Lia password for node management.</td>
    <td></td>
    <td>str</td>
    <td>Cluster1!</td>
  </tr>
  <tr>
    <td>powerflex_lia_state</td>
    <td>false</td>
    <td>Specify state of LIA.<br></td>
    <td>absent, present</td>
    <td>str</td>
    <td>present</td>
  </tr>
</tbody>
</table>

## Examples
----
```
  - name: Install and configure PowerFlex LIA
    ansible.builtin.import_role:
      name: powerflex_lia
    vars:
      hostname: "{{ hostname }}"
      username: "{{ username }}"
      password: "{{ password }}"
      validate_certs: "{{ validate_certs }}"
      port: "{{ port }}"
      powerflex_lia_token: "Cluster1!"
      powerflex_lia_state: present

  - name: Uninstall powerflex LIA
    ansible.builtin.import_role:
      name: powerflex_lia
    vars:
      powerflex_lia_state: absent

```

## Usage instructions
----
### To install all dependency packages, including LIA, on node:
  ansible-playbook -i inventory site.yml

### To uninstall LIA:
  ansible-playbook -i inventory uninstall_powerflex.yml

Sample playbooks and inventory can be found in the playbooks directory.

## Author Information
------------------

Dell Technologies
Pavan Mudunuri (ansible.team@Dell.com)  2023
